/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.extensions;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.provider.ContactsContract;
import com.netacom.lite.entity.ui.contact.LocalContactInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0001\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u0001\u001a\u001a\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n*\u00020\u000b\u001a<\u0010\f\u001a4\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\b0\rj\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00010\bj\b\u0012\u0004\u0012\u00020\u0001`\n`\u000e*\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"PHONE_REGEX_GLOBAL", "", "PHONE_REGEX_GLOBAL_FULL", "PHONE_REGEX_NORMAL", "checkPhone", "", "convertPhoneNumber", "getContactName", "Ljava/util/ArrayList;", "Lcom/netacom/lite/entity/ui/contact/LocalContactInfo;", "Lkotlin/collections/ArrayList;", "Landroid/content/Context;", "getContactNumbers", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "netacom-sdk-full_NetAloProdRelease"})
public final class ContactExtensionKt {
    @NotNull
    public static final String PHONE_REGEX_NORMAL = "^[0-9]{10,13}$";
    @NotNull
    public static final String PHONE_REGEX_GLOBAL_FULL = "^([\\+]?84)?[0-9]{9}$";
    @NotNull
    public static final String PHONE_REGEX_GLOBAL = "^([8]4)?[0-9]{9}$";

    @Nullable
    public static final String convertPhoneNumber(@NotNull String $this$convertPhoneNumber) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$convertPhoneNumber, (String)"$this$convertPhoneNumber");
        String string3 = $this$convertPhoneNumber;
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String first = string4;
        if (ContactExtensionKt.checkPhone($this$convertPhoneNumber) && $this$convertPhoneNumber.length() >= 10) {
            switch (first) {
                case "0": {
                    String stringSplit = StringsKt.substringAfter$default((String)$this$convertPhoneNumber, (String)"0", null, (int)2, null);
                    string2 = "+84" + stringSplit;
                    break;
                }
                case "8": {
                    string2 = '+' + $this$convertPhoneNumber;
                    break;
                }
                default: {
                    string2 = $this$convertPhoneNumber;
                    break;
                }
            }
        } else {
            return null;
        }
        return string2;
    }

    public static final boolean checkPhone(@NotNull String $this$checkPhone) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$checkPhone, (String)"$this$checkPhone");
        CharSequence charSequence = $this$checkPhone;
        int n = 0;
        if (charSequence.length() == 0) {
            return false;
        }
        charSequence = $this$checkPhone;
        n = 0;
        int n2 = 1;
        boolean bl2 = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        switch (string2) {
            case "0": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_NORMAL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            case "+": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_GLOBAL_FULL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            case "8": {
                Pattern pattern = Pattern.compile(PHONE_REGEX_GLOBAL);
                bl = pattern.matcher($this$checkPhone).matches();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final ArrayList<LocalContactInfo> getContactName(@NotNull Context $this$getContactName) {
        Cursor contactsCursor;
        Intrinsics.checkNotNullParameter((Object)$this$getContactName, (String)"$this$getContactName");
        long startTime = System.currentTimeMillis();
        ArrayList<LocalContactInfo> contactsList = new ArrayList<LocalContactInfo>();
        ContentResolver contentResolver = $this$getContactName.getContentResolver();
        Cursor cursor = contactsCursor = contentResolver != null ? contentResolver.query(ContactsContract.Contacts.CONTENT_URI, null, null, null, "display_name ASC") : null;
        if (contactsCursor != null && contactsCursor.getCount() > 0) {
            while (contactsCursor.moveToNext()) {
                String string2;
                String string3;
                Intrinsics.checkNotNullExpressionValue((Object)contactsCursor.getString(contactsCursor.getColumnIndex("has_phone_number")), (String)"contactsCursor.getString\u2026NUMBER)\n                )");
                boolean bl = false;
                int hasPhoneNumber = Integer.parseInt(string3);
                if (hasPhoneNumber <= 0) continue;
                int idIndex = contactsCursor.getColumnIndex("_id");
                int nameIndex = contactsCursor.getColumnIndex("display_name");
                String id2 = contactsCursor.getString(idIndex);
                String name = contactsCursor.getString(nameIndex);
                if (name == null) continue;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string2;
                boolean bl4 = false;
                contactsList.add(new LocalContactInfo(id2, it, null, null, 12, null));
            }
            contactsCursor.close();
        }
        return contactsList;
    }

    @NotNull
    public static final HashMap<String, ArrayList<String>> getContactNumbers(@NotNull Context $this$getContactNumbers) {
        Intrinsics.checkNotNullParameter((Object)$this$getContactNumbers, (String)"$this$getContactNumbers");
        long startTime = System.currentTimeMillis();
        HashMap<String, ArrayList<String>> contactNumbers = new HashMap<String, ArrayList<String>>();
        Cursor phoneCursor = $this$getContactNumbers.getContentResolver().query(ContactsContract.CommonDataKinds.Phone.CONTENT_URI, null, null, null, null);
        if (phoneCursor != null && phoneCursor.getCount() > 0) {
            int contactIdIndex = phoneCursor.getColumnIndex("contact_id");
            int numberIndex = phoneCursor.getColumnIndex("data1");
            while (phoneCursor.moveToNext()) {
                String number;
                String contactId = phoneCursor.getString(contactIdIndex);
                Intrinsics.checkNotNullExpressionValue((Object)phoneCursor.getString(numberIndex), (String)"phoneCursor.getString(numberIndex)");
                if (contactNumbers.containsKey(contactId)) {
                    ArrayList<String> arrayList = contactNumbers.get(contactId);
                    if (arrayList != null) {
                        arrayList.add(number);
                    }
                    continue;
                }
                Map map = contactNumbers;
                String string2 = contactId;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"contactId");
                map.put(string2, CollectionsKt.arrayListOf((Object[])new String[]{number}));
            }
            phoneCursor.close();
        }
        return contactNumbers;
    }
}

