/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.app;

import android.content.Context;
import android.content.Intent;
import androidx.hilt.work.HiltWorkerFactory;
import androidx.work.Configuration;
import androidx.work.WorkerFactory;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.security.ProviderInstaller;
import com.netacom.base.chat.app.BaseApplication;
import com.netacom.full.ui.main.theme.ThemeHelperImpl;
import com.netacom.full.utils.ThemeUtils;
import io.realm.Realm;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/netacom/full/app/SDKApplication;", "Lcom/netacom/base/chat/app/BaseApplication;", "Landroidx/work/Configuration$Provider;", "()V", "themeHelperImpl", "Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "getThemeHelperImpl", "()Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "setThemeHelperImpl", "(Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;)V", "workerFactory", "Landroidx/hilt/work/HiltWorkerFactory;", "getWorkerFactory", "()Landroidx/hilt/work/HiltWorkerFactory;", "setWorkerFactory", "(Landroidx/hilt/work/HiltWorkerFactory;)V", "attachBaseContext", "", "base", "Landroid/content/Context;", "getWorkManagerConfiguration", "Landroidx/work/Configuration;", "initData", "initSentry", "initTheme", "onCreate", "upgradeSecurityProvider", "netacom-sdk-full_NetAloDevRelease"})
public class SDKApplication
extends BaseApplication
implements Configuration.Provider {
    @Inject
    public ThemeHelperImpl themeHelperImpl;
    @Inject
    public HiltWorkerFactory workerFactory;

    @NotNull
    public final ThemeHelperImpl getThemeHelperImpl() {
        ThemeHelperImpl themeHelperImpl = this.themeHelperImpl;
        if (themeHelperImpl != null) {
            return themeHelperImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"themeHelperImpl");
        throw null;
    }

    public final void setThemeHelperImpl(@NotNull ThemeHelperImpl themeHelperImpl) {
        Intrinsics.checkNotNullParameter((Object)themeHelperImpl, (String)"<set-?>");
        this.themeHelperImpl = themeHelperImpl;
    }

    @NotNull
    public final HiltWorkerFactory getWorkerFactory() {
        HiltWorkerFactory hiltWorkerFactory = this.workerFactory;
        if (hiltWorkerFactory != null) {
            return hiltWorkerFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"workerFactory");
        throw null;
    }

    public final void setWorkerFactory(@NotNull HiltWorkerFactory hiltWorkerFactory) {
        Intrinsics.checkNotNullParameter((Object)hiltWorkerFactory, (String)"<set-?>");
        this.workerFactory = hiltWorkerFactory;
    }

    @NotNull
    public Configuration getWorkManagerConfiguration() {
        Configuration configuration = new Configuration.Builder().setWorkerFactory((WorkerFactory)this.getWorkerFactory()).build();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Builder()\n            .setWorkerFactory(workerFactory)\n            .build()");
        return configuration;
    }

    protected void attachBaseContext(@Nullable Context base) {
        super.attachBaseContext(base);
        Realm.init((Context)((Context)this));
    }

    public void onCreate() {
        super.onCreate();
        this.initData();
        this.initTheme();
    }

    private final void initData() {
        this.upgradeSecurityProvider();
    }

    private final void initTheme() {
        ThemeUtils.setDarkModeInSystem(ThemeUtils.INSTANCE.isOsDarkTheme((Context)this));
        ThemeUtils.INSTANCE.enableDisplayMode(this.getThemeHelperImpl().getDisplayMode());
    }

    private final void upgradeSecurityProvider() {
        ProviderInstaller.installIfNeededAsync((Context)((Context)this), (ProviderInstaller.ProviderInstallListener)new ProviderInstaller.ProviderInstallListener(this){
            final /* synthetic */ SDKApplication this$0;
            {
                this.this$0 = $receiver;
            }

            public void onProviderInstalled() {
            }

            public void onProviderInstallFailed(int errorCode, @Nullable Intent recoveryIntent) {
                GoogleApiAvailability.getInstance().showErrorNotification(this.this$0.getApplicationContext(), errorCode);
            }
        });
    }

    private final void initSentry() {
    }
}

