/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.ui.main.theme;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.StateSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.core.content.ContextCompat;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.tabs.TabLayout;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.CoreUtilsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.R;
import com.netacom.full.databinding.BindingAdaptersKt;
import com.netacom.full.utils.ThemeUtils;
import com.netacom.full.widget.toolbar.CoreToolBar;
import com.netacom.lite.entity.ui.theme.NeTheme;
import com.netacom.lite.local.prefs.PreferencesHelperImpl;
import com.netacom.lite.sdk.SdkConfig;
import dagger.hilt.android.qualifiers.ApplicationContext;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\bH\u0002J\u0006\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020,H\u0002J\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u000200H\u0002J\u000e\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203J\u000e\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020.2\u0006\u00105\u001a\u000206J\u000e\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020:J\u0012\u0010;\u001a\u0004\u0018\u00010:2\b\u0010<\u001a\u0004\u0018\u00010:J\u001e\u0010=\u001a\u00020.2\u0006\u00105\u001a\u0002062\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\bJ\u000e\u0010@\u001a\u00020.2\u0006\u00105\u001a\u000206J\u001f\u0010A\u001a\u00020.2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002060C\"\u000206\u00a2\u0006\u0002\u0010DJ\u001f\u0010E\u001a\u00020.2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002060C\"\u000206\u00a2\u0006\u0002\u0010DJ\u001f\u0010F\u001a\u00020.2\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u0002060C\"\u000206\u00a2\u0006\u0002\u0010DJ\u0016\u0010F\u001a\u00020.2\f\u0010B\u001a\b\u0012\u0004\u0012\u0002060GH\u0002J\u000e\u0010H\u001a\u00020.2\u0006\u00105\u001a\u000206R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0014\u0010\u0014\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0007\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000bR\u0014\u0010\u001e\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000bR\u0014\u0010 \u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0011\u0010\"\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000bR\u0011\u0010$\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000b\u00a8\u0006I"}, d2={"Lcom/netacom/full/ui/main/theme/ThemeHelperImpl;", "", "preferencesHelperImpl", "Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;", "application", "Landroid/content/Context;", "(Lcom/netacom/lite/local/prefs/PreferencesHelperImpl;Landroid/content/Context;)V", "value", "", "displayMode", "getDisplayMode", "()I", "setDisplayMode", "(I)V", "isDarkMode", "", "()Z", "isDefaultColor", "mainColor", "getMainColor", "menuColor", "getMenuColor", "Lcom/netacom/lite/entity/ui/theme/NeTheme;", "neTheme", "getNeTheme", "()Lcom/netacom/lite/entity/ui/theme/NeTheme;", "setNeTheme", "(Lcom/netacom/lite/entity/ui/theme/NeTheme;)V", "referralDrawableId", "getReferralDrawableId", "secretColor", "getSecretColor", "secretMessageColor", "getSecretMessageColor", "subColor", "getSubColor", "toolbarDrawableId", "getToolbarDrawableId", "createShapeDrawable", "Landroid/graphics/drawable/GradientDrawable;", "color", "createThemeColorStateList", "Landroid/graphics/drawable/StateListDrawable;", "createThemeMenu", "Landroid/content/res/ColorStateList;", "resetToDefault", "", "sdkConfig", "Lcom/netacom/lite/sdk/SdkConfig;", "setButtonBackgroundAndText", "button", "Landroidx/appcompat/widget/AppCompatButton;", "setHeaderTheme", "view", "Landroid/view/View;", "setThemeColorForBackground", "setThemeColorForBorder", "drawable", "Landroid/graphics/drawable/Drawable;", "setThemeColorForDrawable", "drawables", "setThemeColorForMessage", "messageType", "groupType", "setThemeColorForSecretBackground", "setThemeColorForSecretChat", "views", "", "([Landroid/view/View;)V", "setThemeColorForSubBackground", "setThemeColorForViews", "", "setThemeStateListForButtonAction", "netacom-sdk-full_NetAloDevRelease"})
public final class ThemeHelperImpl {
    @NotNull
    private final PreferencesHelperImpl preferencesHelperImpl;
    @NotNull
    private final Context application;

    @Inject
    public ThemeHelperImpl(@NotNull PreferencesHelperImpl preferencesHelperImpl, @ApplicationContext @NotNull Context application) {
        Intrinsics.checkNotNullParameter((Object)preferencesHelperImpl, (String)"preferencesHelperImpl");
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        this.preferencesHelperImpl = preferencesHelperImpl;
        this.application = application;
    }

    private final SdkConfig sdkConfig() {
        SdkConfig sdkConfig = this.preferencesHelperImpl.getSdkConfig();
        return sdkConfig == null ? new SdkConfig(0, null, null, null, false, null, false, false, false, false, 1023, null) : sdkConfig;
    }

    @Nullable
    public final NeTheme getNeTheme() {
        return this.preferencesHelperImpl.getNeTheme();
    }

    public final void setNeTheme(@Nullable NeTheme value) {
        this.preferencesHelperImpl.setNeTheme(value);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getMainColor() {
        String string2;
        int n;
        NeTheme neTheme;
        if (ExtensionsUtilsKt.isNotNull((Object)this.preferencesHelperImpl.getNeTheme())) {
            neTheme = this.preferencesHelperImpl.getNeTheme();
            Intrinsics.checkNotNull((Object)neTheme);
            if (ExtensionsUtilsKt.isNotZero((int)CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getMainColor()))) {
                neTheme = this.preferencesHelperImpl.getNeTheme();
                Intrinsics.checkNotNull((Object)neTheme);
                n = CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getMainColor());
                return n;
            }
        }
        if (Intrinsics.areEqual((neTheme = this.preferencesHelperImpl.getNeTheme()) == null ? null : ((string2 = neTheme.getMainColor()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string2, (String)"#", (boolean)false, (int)2, null))), (Object)true)) {
            String string3;
            string2 = this.preferencesHelperImpl.getNeTheme();
            Integer n2 = string2 == null ? null : (neTheme = (string3 = string2.getMainColor()) == null ? null : ExtensionsUtilsKt.getAsColor((String)string3));
            if (neTheme == null) {
                n = R.color.color_orange_f5783f;
                return n;
            }
            n = neTheme.intValue();
            return n;
        }
        int n3 = this.sdkConfig().getAppId();
        if (n3 == 3) {
            n = R.color.color_green_gchat;
            return n;
        }
        n = R.color.color_orange_f5783f;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getSubColor() {
        String string2;
        int n;
        NeTheme neTheme;
        if (ExtensionsUtilsKt.isNotNull((Object)this.preferencesHelperImpl.getNeTheme())) {
            neTheme = this.preferencesHelperImpl.getNeTheme();
            Intrinsics.checkNotNull((Object)neTheme);
            if (ExtensionsUtilsKt.isNotZero((int)CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getSubColor()))) {
                neTheme = this.preferencesHelperImpl.getNeTheme();
                Intrinsics.checkNotNull((Object)neTheme);
                n = CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getSubColor());
                return n;
            }
        }
        if (Intrinsics.areEqual((neTheme = this.preferencesHelperImpl.getNeTheme()) == null ? null : ((string2 = neTheme.getSubColor()) == null ? null : Boolean.valueOf(StringsKt.startsWith$default((String)string2, (String)"#", (boolean)false, (int)2, null))), (Object)true)) {
            String string3;
            string2 = this.preferencesHelperImpl.getNeTheme();
            Integer n2 = string2 == null ? null : (neTheme = (string3 = string2.getSubColor()) == null ? null : ExtensionsUtilsKt.getAsColor((String)string3));
            if (neTheme == null) {
                n = R.color.color_orange_4df5783f;
                return n;
            }
            n = neTheme.intValue();
            return n;
        }
        int n3 = this.sdkConfig().getAppId();
        if (n3 == 3) {
            n = R.color.color_green_sub_gchat;
            return n;
        }
        n = R.color.color_orange_4df5783f;
        return n;
    }

    public final int getToolbarDrawableId() {
        int n;
        Integer n2;
        NeTheme neTheme = this.preferencesHelperImpl.getNeTheme();
        if (neTheme == null) {
            n2 = null;
        } else {
            NeTheme neTheme2 = neTheme;
            boolean bl = false;
            boolean bl2 = false;
            NeTheme it = neTheme2;
            boolean bl3 = false;
            Integer n3 = CoreUtilsKt.resIdByNameDrawable((Context)this.application, (String)it.getToolbarDrawable());
            Intrinsics.checkNotNull((Object)n3);
            if (ExtensionsUtilsKt.isNotZero((int)n3)) {
                n2 = CoreUtilsKt.resIdByNameDrawable((Context)this.application, (String)it.getToolbarDrawable());
            } else if (ExtensionsUtilsKt.isNotZero((int)CoreUtilsKt.resIdByNameColor((Context)this.application, (String)it.getToolbarDrawable()))) {
                n2 = CoreUtilsKt.resIdByNameColor((Context)this.application, (String)it.getToolbarDrawable());
            } else if (StringsKt.startsWith$default((String)it.getToolbarDrawable(), (String)"#", (boolean)false, (int)2, null)) {
                Logger.INSTANCE.e(Intrinsics.stringPlus((String)"toolbarDrawable====", (Object)it.getToolbarDrawable()), new Object[0]);
                n3 = ExtensionsUtilsKt.getAsColor((String)it.getToolbarDrawable());
                n2 = n3 == null ? R.drawable.bg_header_orange : n3;
            } else {
                int n4 = this.sdkConfig().getAppId();
                n2 = n4 == 3 ? R.color.color_green_gchat : R.drawable.bg_header_orange;
            }
        }
        Integer n5 = n2;
        return n5 == null ? ((n = this.sdkConfig().getAppId()) == 3 ? R.color.color_green_gchat : R.drawable.bg_header_orange) : n5;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getReferralDrawableId() {
        int n;
        if (ExtensionsUtilsKt.isNotNull((Object)this.preferencesHelperImpl.getNeTheme())) {
            Object object = this.preferencesHelperImpl.getNeTheme();
            Intrinsics.checkNotNull((Object)object);
            if (object.getColorIdReferral() != null) {
                NeTheme neTheme = this.preferencesHelperImpl.getNeTheme();
                Intrinsics.checkNotNull((Object)neTheme);
                object = CoreUtilsKt.resIdByNameDrawable((Context)this.application, (String)neTheme.getColorIdReferral());
                Intrinsics.checkNotNull((Object)object);
                if (ExtensionsUtilsKt.isNotZero((int)((Integer)object))) {
                    neTheme = this.preferencesHelperImpl.getNeTheme();
                    Intrinsics.checkNotNull((Object)neTheme);
                    object = CoreUtilsKt.resIdByNameDrawable((Context)this.application, (String)neTheme.getColorIdReferral());
                    if (object == null) {
                        return 0;
                    }
                    n = (Integer)object;
                    return n;
                }
            }
        }
        n = R.drawable.ic_bg_referral_code_orange;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int getMenuColor() {
        int n;
        int n2;
        if (ExtensionsUtilsKt.isNotNull((Object)this.preferencesHelperImpl.getNeTheme())) {
            NeTheme neTheme = this.preferencesHelperImpl.getNeTheme();
            Intrinsics.checkNotNull((Object)neTheme);
            if (ExtensionsUtilsKt.isNotZero((int)CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getMenuColor()))) {
                neTheme = this.preferencesHelperImpl.getNeTheme();
                Intrinsics.checkNotNull((Object)neTheme);
                n2 = CoreUtilsKt.resIdByNameColor((Context)this.application, (String)neTheme.getMenuColor());
                return n2;
            }
        }
        if ((n = this.sdkConfig().getAppId()) == 3) {
            n2 = R.color.bottom_navigation_menu_green;
            return n2;
        }
        n2 = R.color.bottom_navigation_menu_orange;
        return n2;
    }

    public final boolean isDefaultColor() {
        boolean bl;
        NeTheme neTheme = this.preferencesHelperImpl.getNeTheme();
        return neTheme == null ? false : (bl = neTheme.isDefaultColor());
    }

    public final int getDisplayMode() {
        return this.preferencesHelperImpl.getDisplayMode();
    }

    public final void setDisplayMode(int value) {
        this.preferencesHelperImpl.setDisplayMode(value);
    }

    public final boolean isDarkMode() {
        boolean bl;
        int n = this.getDisplayMode();
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = ThemeUtils.INSTANCE.isOsDarkTheme(this.application);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final int getSecretColor() {
        return this.isDarkMode() ? R.color.color_grey_a0a0a0 : R.color.color_black_25272a;
    }

    private final int getSecretMessageColor() {
        return R.color.color_black_4b4c4e;
    }

    public final void setThemeColorForViews(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        View[] $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        View[] viewArray = $this$forEach$iv;
        int n = viewArray.length;
        for (int i = 0; i < n; ++i) {
            View element$iv;
            View it = element$iv = viewArray[i];
            boolean bl = false;
            View view = it;
            if (view instanceof AppCompatTextView) {
                BindingAdaptersKt.setTextColorTheme((TextView)it, this.getMainColor());
                continue;
            }
            if (view instanceof AppCompatEditText) {
                BindingAdaptersKt.setTextColorTheme((TextView)it, this.getMainColor());
                continue;
            }
            if (view instanceof ImageView) {
                BindingAdaptersKt.setImageColorTheme((ImageView)it, this.getMainColor());
                continue;
            }
            if (view instanceof CoreToolBar) {
                ((CoreToolBar)it).setBackgroundTheme(this.sdkConfig().getAppId(), this.isDarkMode(), this.getToolbarDrawableId());
                continue;
            }
            if (view instanceof BottomNavigationView) {
                BindingAdaptersKt.setupNavigationTheme((BottomNavigationView)it, this.createThemeMenu());
                continue;
            }
            if (view instanceof AppCompatButton) {
                BindingAdaptersKt.setButtonTheme((AppCompatButton)it, this.getMainColor());
                continue;
            }
            if (view instanceof TabLayout) {
                BindingAdaptersKt.setTabLayoutTheme((TabLayout)it, this.getMainColor());
                continue;
            }
            if (view instanceof ProgressBar) {
                BindingAdaptersKt.setProgressTintListTheme((ProgressBar)it, this.getMainColor());
                continue;
            }
            BindingAdaptersKt.setBackgroundColorTheme(it, this.getMainColor());
        }
    }

    public final void setThemeColorForSecretChat(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        try {
            View[] $this$forEach$iv = views;
            boolean $i$f$forEach = false;
            View[] viewArray = $this$forEach$iv;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                View element$iv;
                View it = element$iv = viewArray[i];
                boolean bl = false;
                View view = it;
                if (view instanceof AppCompatTextView) {
                    BindingAdaptersKt.setTextColorTheme((TextView)it, this.getSecretColor());
                    continue;
                }
                if (view instanceof AppCompatEditText) {
                    BindingAdaptersKt.setTextColorTheme((TextView)it, this.getSecretColor());
                    continue;
                }
                if (view instanceof ImageView) {
                    BindingAdaptersKt.setImageColorTheme((ImageView)it, this.getSecretColor());
                    continue;
                }
                if (view instanceof AppCompatButton) {
                    BindingAdaptersKt.setButtonTheme((AppCompatButton)it, this.getSecretColor());
                    continue;
                }
                if (view instanceof TabLayout) {
                    BindingAdaptersKt.setTabLayoutTheme((TabLayout)it, this.getSecretColor());
                    continue;
                }
                if (view instanceof ProgressBar) {
                    BindingAdaptersKt.setProgressTintListTheme((ProgressBar)it, this.getSecretColor());
                    continue;
                }
                BindingAdaptersKt.setBackgroundColorTheme(it, this.getSecretColor());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void setHeaderTheme(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (this.getDisplayMode() == 1) {
            view.setBackgroundColor(ContextCompat.getColor((Context)((Context)Utils.getApp()), (int)R.color.color_black_25272a));
        } else if (this.getDisplayMode() == 0) {
            if (ExtensionsUtilsKt.isResource((Context)view.getContext(), (int)this.getToolbarDrawableId())) {
                view.setBackgroundResource(this.getToolbarDrawableId());
            } else {
                view.setBackgroundColor(this.getToolbarDrawableId());
            }
        }
    }

    private final void setThemeColorForViews(List<? extends View> views) {
        Iterable $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View it = (View)element$iv;
            boolean bl = false;
            View view = it;
            if (view instanceof TextView) {
                BindingAdaptersKt.setTextColorTheme((TextView)it, this.getMainColor());
                continue;
            }
            if (!(view instanceof ImageView)) continue;
            BindingAdaptersKt.setImageColorTheme((ImageView)it, this.getMainColor());
        }
    }

    public final void setThemeStateListForButtonAction(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        StateListDrawable stateListDrawable = new StateListDrawable();
        int[] nArray = new int[]{16842910};
        stateListDrawable.addState(nArray, (Drawable)this.createShapeDrawable(ExtensionsUtilsKt.getThemeColor((int)this.getMainColor())));
        if (this.getDisplayMode() == 1) {
            stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)this.createShapeDrawable(ContextCompat.getColor((Context)this.application, (int)R.color.color_grey_b7b7b7)));
        } else {
            stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)this.createShapeDrawable(ContextCompat.getColor((Context)this.application, (int)R.color.color_disable_btn)));
        }
        view.setBackground((Drawable)stateListDrawable);
    }

    @NotNull
    public final StateListDrawable createThemeColorStateList() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        int[] nArray = new int[]{16842910};
        stateListDrawable.addState(nArray, (Drawable)this.createShapeDrawable(ContextCompat.getColor((Context)this.application, (int)this.getMainColor())));
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)this.createShapeDrawable(ContextCompat.getColor((Context)this.application, (int)R.color.color_grey_3325272A)));
        return stateListDrawable;
    }

    private final ColorStateList createThemeMenu() {
        Object object = new int[2][];
        int[] nArray = new int[]{-16842912};
        object[0] = nArray;
        nArray = new int[]{0x10100A0};
        object[1] = nArray;
        int[][] nArrayArray = object;
        object = new int[2];
        object[0] = (int[])ContextCompat.getColor((Context)((Context)Utils.getApp()), (int)R.color.color_grey_b7b7b7);
        object[1] = (int[])ExtensionsUtilsKt.getThemeColor((int)this.getMainColor());
        return new ColorStateList((int[][])nArrayArray, (int[])object);
    }

    private final GradientDrawable createShapeDrawable(int color2) {
        GradientDrawable shape = new GradientDrawable();
        shape.setShape(0);
        shape.setColor(color2);
        shape.setCornerRadius(4.0f);
        return shape;
    }

    @Nullable
    public final Drawable setThemeColorForDrawable(@Nullable Drawable drawables) {
        Drawable drawable2 = drawables;
        if (drawable2 != null) {
            drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(ExtensionsUtilsKt.getThemeColor((int)this.getMainColor()), PorterDuff.Mode.SRC_IN));
        }
        return drawables;
    }

    public final void setThemeColorForSubBackground(View ... views) {
        Intrinsics.checkNotNullParameter((Object)views, (String)"views");
        View[] $this$forEach$iv = views;
        boolean $i$f$forEach = false;
        View[] viewArray = $this$forEach$iv;
        int n = viewArray.length;
        for (int i = 0; i < n; ++i) {
            View element$iv;
            View it = element$iv = viewArray[i];
            boolean bl = false;
            View view = it;
            if (view instanceof AppCompatImageView) {
                BindingAdaptersKt.setBackgroundColorTheme(it, this.getSubColor());
                continue;
            }
            BindingAdaptersKt.setBackgroundColorTheme(it, this.getSubColor());
        }
    }

    public final void setThemeColorForBackground(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BindingAdaptersKt.setBackgroundColorTheme(view, this.getMainColor());
    }

    public final void setThemeColorForSecretBackground(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BindingAdaptersKt.setBackgroundColorTheme(view, this.getSecretColor());
    }

    public final void setButtonBackgroundAndText(@NotNull AppCompatButton button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        BindingAdaptersKt.setButtonTheme(button, this.getMainColor());
        button.setTextColor(ExtensionsUtilsKt.getThemeColor((int)this.getMainColor()));
    }

    public final void setThemeColorForMessage(@NotNull View view, int messageType, int groupType) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int n = messageType;
        switch (n) {
            case 1: 
            case 6: {
                view.setBackgroundResource(R.drawable.bg_single_sender);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                view.setBackgroundResource(R.drawable.bg_media_opacity_45);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: {
                view.setBackgroundResource(R.drawable.bg_media_opacity_30);
            }
        }
        if (groupType == 1) {
            BindingAdaptersKt.setBackgroundColorTheme(view, this.getSecretMessageColor());
        } else {
            BindingAdaptersKt.setBackgroundColorTheme(view, this.getMainColor());
        }
    }

    public final void setThemeColorForBorder(@NotNull Drawable drawable2) {
        GradientDrawable strokeDrawable;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        GradientDrawable gradientDrawable = strokeDrawable = drawable2 instanceof GradientDrawable ? (GradientDrawable)drawable2 : null;
        if (gradientDrawable != null) {
            gradientDrawable.setStroke(2, ContextCompat.getColor((Context)this.application, (int)this.getMainColor()));
        }
    }

    public final void resetToDefault() {
        this.preferencesHelperImpl.setNeTheme(null);
        this.preferencesHelperImpl.setDisplayMode(0);
        ThemeUtils.INSTANCE.enableDisplayMode(0);
    }
}

