/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.widget.video;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackPreparer;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.PlayerControlView;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.netacom.base.chat.android_utils.AppUtils;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.full.R;
import com.netacom.full.widget.video.IPlayerClickListener;
import com.netacom.full.widget.video.PlayerExoHelper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\t\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u001d\b\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u0004\u0018\u00010\"J\u0006\u0010#\u001a\u00020\u0013J\u0006\u0010$\u001a\u00020\u001eJ\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001cJ\u0006\u0010(\u001a\u00020\u001eJ\u0006\u0010)\u001a\u00020\u001eJ\r\u0010*\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010+J\r\u0010,\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\u0002\u0010+J;\u0010-\u001a\u00020\u001e2\b\u0010.\u001a\u0004\u0018\u00010\u00192\b\u0010/\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0002\u00102J\u0015\u00103\u001a\u0004\u0018\u00010\u001e2\u0006\u00100\u001a\u000201\u00a2\u0006\u0002\u00104J\u0006\u00105\u001a\u00020\u001eJ\u000e\u00106\u001a\u00020\u001e2\u0006\u00107\u001a\u00020\u001cJ\u000e\u00108\u001a\u00020\u001e2\u0006\u00109\u001a\u00020\bJ\u0006\u0010:\u001a\u00020\u001eJ\u0006\u0010;\u001a\u00020\u001eJ\u001a\u0010<\u001a\u00020\u001e2\b\u0010=\u001a\u0004\u0018\u00010\u00002\b\u0010>\u001a\u0004\u0018\u00010\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/netacom/full/widget/video/ExoPlayerView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dataSourceFactory", "Lcom/google/android/exoplayer2/upstream/DefaultHttpDataSource$Factory;", "exoPlayer", "Lcom/google/android/exoplayer2/SimpleExoPlayer;", "loadControl", "Lcom/google/android/exoplayer2/LoadControl;", "playerView", "Lcom/google/android/exoplayer2/ui/PlayerView;", "trackSelector", "Lcom/google/android/exoplayer2/trackselection/DefaultTrackSelector;", "buildMediaResource", "Lcom/google/android/exoplayer2/source/MediaSource;", "linkStream", "Landroid/net/Uri;", "apphash", "", "token", "checkPlayer", "", "createExoPlayer", "", "playerExoHelper", "Lcom/netacom/full/widget/video/PlayerExoHelper;", "getPlayer", "Lcom/google/android/exoplayer2/Player;", "getTrackSelector", "hideController", "initializePlayer", "isPlaying", "isShowController", "pauseExoPlayer", "releasePlayer", "replay", "()Lkotlin/Unit;", "retry", "runExoPlayer", "linkUrl", "subtitle", "position", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;)V", "seekTo", "(J)Lkotlin/Unit;", "setMutePlayer", "setPlayWhenReady", "shouldAutoPlay", "setResizeModeRaw", "resizeMode", "setUnMutePlayer", "stopExoPlayer", "switchTargetView", "oldPlayerView", "newPlayerView", "netacom-sdk-full_NetAloDevRelease"})
public final class ExoPlayerView
extends FrameLayout {
    private PlayerView playerView;
    private SimpleExoPlayer exoPlayer;
    private DefaultHttpDataSource.Factory dataSourceFactory;
    private DefaultTrackSelector trackSelector;
    private LoadControl loadControl;

    public final void initializePlayer() {
        if (this.playerView == null) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context context2 = context.getApplicationContext();
            LayoutInflater.from((Context)context2).inflate(R.layout.view_video_player, (ViewGroup)this);
            this.playerView = (PlayerView)this.findViewById(R.id.exoPlayer);
            DefaultHttpDataSource.Factory factory = new DefaultHttpDataSource.Factory().setUserAgent(Util.getUserAgent((Context)context2, (String)((Object)((Object)this)).getClass().getSimpleName()));
            Intrinsics.checkNotNullExpressionValue((Object)factory, (String)"DefaultHttpDataSource.Fa\u2026::class.java.simpleName))");
            this.dataSourceFactory = factory;
        }
    }

    public final void createExoPlayer(@NotNull PlayerExoHelper playerExoHelper) {
        block4: {
            SimpleExoPlayer $this$apply;
            boolean bl;
            boolean bl2;
            SimpleExoPlayer simpleExoPlayer;
            Intrinsics.checkNotNullParameter((Object)playerExoHelper, (String)"playerExoHelper");
            if (this.exoPlayer != null) break block4;
            DefaultLoadControl defaultLoadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 2500, 5000).build();
            Intrinsics.checkNotNullExpressionValue((Object)defaultLoadControl, (String)"DefaultLoadControl.Build\u2026\n                .build()");
            this.loadControl = (LoadControl)defaultLoadControl;
            this.trackSelector = new DefaultTrackSelector(this.getContext(), (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
            SimpleExoPlayer.Builder builder = new SimpleExoPlayer.Builder(this.getContext());
            DefaultTrackSelector defaultTrackSelector = this.trackSelector;
            if (defaultTrackSelector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"trackSelector");
            }
            SimpleExoPlayer.Builder builder2 = builder.setTrackSelector((TrackSelector)defaultTrackSelector);
            LoadControl loadControl = this.loadControl;
            if (loadControl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadControl");
            }
            SimpleExoPlayer simpleExoPlayer2 = this.exoPlayer = builder2.setLoadControl(loadControl).build();
            if (simpleExoPlayer2 != null) {
                simpleExoPlayer = simpleExoPlayer2;
                bl2 = false;
                bl = false;
                $this$apply = simpleExoPlayer;
                boolean bl3 = false;
                $this$apply.addVideoListener((VideoListener)playerExoHelper);
                $this$apply.addListener((Player.EventListener)playerExoHelper);
            }
            PlayerView playerView = this.playerView;
            if (playerView != null) {
                simpleExoPlayer = playerView;
                bl2 = false;
                bl = false;
                $this$apply = simpleExoPlayer;
                boolean bl4 = false;
                $this$apply.setPlayer((Player)this.exoPlayer);
                $this$apply.setControllerVisibilityListener(new PlayerControlView.VisibilityListener(this, playerExoHelper){
                    final /* synthetic */ ExoPlayerView this$0;
                    final /* synthetic */ PlayerExoHelper $playerExoHelper$inlined;
                    {
                        this.this$0 = exoPlayerView;
                        this.$playerExoHelper$inlined = playerExoHelper;
                    }

                    public final void onVisibilityChange(int it) {
                        block0: {
                            IPlayerClickListener iPlayerClickListener = this.$playerExoHelper$inlined.getPlayerClickListener();
                            if (iPlayerClickListener == null) break block0;
                            iPlayerClickListener.isShowController(it == 0);
                        }
                    }
                });
                $this$apply.setPlaybackPreparer((PlaybackPreparer)playerExoHelper);
            }
        }
    }

    public final boolean checkPlayer() {
        return this.exoPlayer != null;
    }

    @org.jetbrains.annotations.Nullable
    public final Player getPlayer() {
        return (Player)this.exoPlayer;
    }

    @NotNull
    public final DefaultTrackSelector getTrackSelector() {
        DefaultTrackSelector defaultTrackSelector = this.trackSelector;
        if (defaultTrackSelector == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"trackSelector");
        }
        return defaultTrackSelector;
    }

    public final void setMutePlayer() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.setVolume(0.0f);
        }
    }

    public final void setUnMutePlayer() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.setVolume(1.0f);
        }
    }

    public final void runExoPlayer(@org.jetbrains.annotations.Nullable String linkUrl, @org.jetbrains.annotations.Nullable String subtitle, @org.jetbrains.annotations.Nullable Long position, @NotNull String apphash, @NotNull String token) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)apphash, (String)"apphash");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            CharSequence charSequence = linkUrl;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return;
            }
            Logger.INSTANCE.e("runExoPlayer = " + linkUrl + " subtitle = " + subtitle, new Object[0]);
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block3;
            charSequence = simpleExoPlayer;
            bl = false;
            bl2 = false;
            CharSequence player = charSequence;
            boolean bl3 = false;
            String $this$toUri$iv = linkUrl;
            boolean $i$f$toUri = false;
            Uri uri = Uri.parse((String)$this$toUri$iv);
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"Uri.parse(this)");
            player.setMediaSource(this.buildMediaResource(uri, apphash, token));
            player.prepare();
            if (position != null && position != 0L) {
                player.seekTo(position);
            }
            player.setPlayWhenReady(true);
            StringBuilder stringBuilder = new StringBuilder().append("check header = ");
            DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
            if (factory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
            }
            Logger.INSTANCE.d(stringBuilder.append(factory.getDefaultRequestProperties()).toString(), new Object[0]);
        }
    }

    public static /* synthetic */ void runExoPlayer$default(ExoPlayerView exoPlayerView, String string2, String string3, Long l, String string4, String string5, int n, Object object) {
        if ((n & 4) != 0) {
            l = 0L;
        }
        exoPlayerView.runExoPlayer(string2, string3, l, string4, string5);
    }

    /*
     * WARNING - void declaration
     */
    private final MediaSource buildMediaResource(Uri linkStream, String apphash, String token) {
        MediaSource mediaSource;
        void type;
        DefaultHttpDataSource.Factory factory = this.dataSourceFactory;
        if (factory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
        }
        factory.getDefaultRequestProperties().set("TC-Token", token);
        int n = Util.inferContentType((Uri)linkStream);
        switch (type) {
            case 0: {
                DefaultHttpDataSource.Factory factory2 = this.dataSourceFactory;
                if (factory2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory2.getDefaultRequestProperties().set("app", AppUtils.getAppPackageName());
                DefaultHttpDataSource.Factory factory3 = this.dataSourceFactory;
                if (factory3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory3.getDefaultRequestProperties().set("apphash", apphash);
                DefaultHttpDataSource.Factory factory4 = this.dataSourceFactory;
                if (factory4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                DashMediaSource dashMediaSource = new DashMediaSource.Factory((DataSource.Factory)factory4).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)dashMediaSource, (String)"DashMediaSource.Factory(\u2026Item.fromUri(linkStream))");
                mediaSource = (MediaSource)dashMediaSource;
                break;
            }
            case 1: {
                DefaultHttpDataSource.Factory factory5 = this.dataSourceFactory;
                if (factory5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory5.getDefaultRequestProperties().set("app", AppUtils.getAppPackageName());
                DefaultHttpDataSource.Factory factory6 = this.dataSourceFactory;
                if (factory6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory6.getDefaultRequestProperties().set("apphash", apphash);
                DefaultHttpDataSource.Factory factory7 = this.dataSourceFactory;
                if (factory7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                SsMediaSource ssMediaSource = new SsMediaSource.Factory((DataSource.Factory)factory7).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)ssMediaSource, (String)"SsMediaSource.Factory(da\u2026Item.fromUri(linkStream))");
                mediaSource = (MediaSource)ssMediaSource;
                break;
            }
            case 2: {
                DefaultHttpDataSource.Factory factory8 = this.dataSourceFactory;
                if (factory8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory8.getDefaultRequestProperties().set("app", AppUtils.getAppPackageName());
                DefaultHttpDataSource.Factory factory9 = this.dataSourceFactory;
                if (factory9 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                factory9.getDefaultRequestProperties().set("apphash", apphash);
                DefaultHttpDataSource.Factory factory10 = this.dataSourceFactory;
                if (factory10 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                }
                HlsMediaSource hlsMediaSource = new HlsMediaSource.Factory((DataSource.Factory)factory10).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                Intrinsics.checkNotNullExpressionValue((Object)hlsMediaSource, (String)"HlsMediaSource.Factory(d\u2026Item.fromUri(linkStream))");
                mediaSource = (MediaSource)hlsMediaSource;
                break;
            }
            case 3: {
                BaseMediaSource baseMediaSource;
                String string2 = linkStream.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"linkStream.toString()");
                if (ExtensionsUtilsKt.isLocalLink((String)string2)) {
                    DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory(this.getContext(), Util.getUserAgent((Context)this.getContext(), (String)((Object)((Object)this)).getClass().getSimpleName()));
                    baseMediaSource = (BaseMediaSource)new ExtractorMediaSource(linkStream, (DataSource.Factory)dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), null, null);
                } else {
                    DefaultHttpDataSource.Factory factory11 = this.dataSourceFactory;
                    if (factory11 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    }
                    factory11.getDefaultRequestProperties().set("app", AppUtils.getAppPackageName());
                    DefaultHttpDataSource.Factory factory12 = this.dataSourceFactory;
                    if (factory12 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    }
                    factory12.getDefaultRequestProperties().set("apphash", apphash);
                    DefaultHttpDataSource.Factory factory13 = this.dataSourceFactory;
                    if (factory13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
                    }
                    ProgressiveMediaSource progressiveMediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)factory13).createMediaSource(MediaItem.fromUri((Uri)linkStream));
                    Intrinsics.checkNotNullExpressionValue((Object)progressiveMediaSource, (String)"ProgressiveMediaSource.F\u2026Item.fromUri(linkStream))");
                    baseMediaSource = (BaseMediaSource)progressiveMediaSource;
                }
                mediaSource = (MediaSource)baseMediaSource;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Unsupported type: " + (int)type);
            }
        }
        return mediaSource;
    }

    public final void releasePlayer() {
        this.stopExoPlayer();
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.release();
        }
        this.exoPlayer = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isPlaying() {
        if (this.exoPlayer == null) return false;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer == null) return false;
        if (!simpleExoPlayer.isPlaying()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isShowController() {
        if (this.playerView == null) return false;
        PlayerView playerView = this.playerView;
        if (playerView == null) return false;
        boolean bl = playerView.isControllerVisible();
        if (!bl) return false;
        return true;
    }

    public final void setPlayWhenReady(boolean shouldAutoPlay) {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            simpleExoPlayer.setPlayWhenReady(shouldAutoPlay);
        }
    }

    @org.jetbrains.annotations.Nullable
    public final Unit retry() {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.prepare();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void pauseExoPlayer() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer $this$apply = simpleExoPlayer2;
            boolean bl3 = false;
            $this$apply.pause();
        }
    }

    public final void stopExoPlayer() {
        block0: {
            SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
            if (simpleExoPlayer == null) break block0;
            SimpleExoPlayer simpleExoPlayer2 = simpleExoPlayer;
            boolean bl = false;
            boolean bl2 = false;
            SimpleExoPlayer $this$apply = simpleExoPlayer2;
            boolean bl3 = false;
            $this$apply.seekTo(0L);
            $this$apply.stop();
        }
    }

    @org.jetbrains.annotations.Nullable
    public final Unit replay() {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.seekTo(0L);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @org.jetbrains.annotations.Nullable
    public final Unit seekTo(long position) {
        Unit unit;
        SimpleExoPlayer simpleExoPlayer = this.exoPlayer;
        if (simpleExoPlayer != null) {
            simpleExoPlayer.seekTo(position);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void setResizeModeRaw(int resizeMode) {
        block0: {
            PlayerView playerView = this.playerView;
            if (playerView == null) break block0;
            playerView.setResizeMode(resizeMode);
        }
    }

    public final void switchTargetView(@org.jetbrains.annotations.Nullable ExoPlayerView oldPlayerView, @org.jetbrains.annotations.Nullable ExoPlayerView newPlayerView) {
        if (oldPlayerView == newPlayerView) {
            return;
        }
        if (newPlayerView != null) {
            newPlayerView.exoPlayer = this.exoPlayer;
        }
        if (oldPlayerView != null) {
            oldPlayerView.exoPlayer = null;
        }
    }

    public final void hideController() {
        block0: {
            PlayerView playerView = this.playerView;
            if (playerView == null) break block0;
            playerView.setUseController(false);
        }
    }

    public ExoPlayerView(@NonNull @NotNull Context context, @Nullable @org.jetbrains.annotations.Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    @JvmOverloads
    public ExoPlayerView(@NonNull @NotNull Context context, @Nullable @org.jetbrains.annotations.Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public /* synthetic */ ExoPlayerView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @JvmOverloads
    public ExoPlayerView(@NonNull @NotNull Context context) {
        this(context, null, 2, null);
    }
}

