/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.full.app;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.Keep;
import androidx.hilt.work.HiltWorkerFactory;
import androidx.work.Configuration;
import androidx.work.WorkerFactory;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.security.ProviderInstaller;
import com.netacom.base.chat.app.BaseApplication;
import com.netacom.base.chat.app.ConfigAppKt;
import com.netacom.full.app.SDKApplication;
import io.realm.Realm;
import io.sentry.Sentry;
import io.sentry.android.core.SentryAndroid;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/netacom/full/app/SDKApplication;", "Lcom/netacom/base/chat/app/BaseApplication;", "Landroidx/work/Configuration$Provider;", "()V", "workerFactory", "Landroidx/hilt/work/HiltWorkerFactory;", "getWorkerFactory", "()Landroidx/hilt/work/HiltWorkerFactory;", "setWorkerFactory", "(Landroidx/hilt/work/HiltWorkerFactory;)V", "getWorkManagerConfiguration", "Landroidx/work/Configuration;", "initData", "", "initSentry", "onCreate", "upgradeSecurityProvider", "netacom-sdk-full_NetAloDevRelease"})
@Keep
public class SDKApplication
extends BaseApplication
implements Configuration.Provider {
    @Inject
    public HiltWorkerFactory workerFactory;

    @NotNull
    public final HiltWorkerFactory getWorkerFactory() {
        HiltWorkerFactory hiltWorkerFactory = this.workerFactory;
        if (hiltWorkerFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workerFactory");
        }
        return hiltWorkerFactory;
    }

    public final void setWorkerFactory(@NotNull HiltWorkerFactory hiltWorkerFactory) {
        Intrinsics.checkNotNullParameter((Object)hiltWorkerFactory, (String)"<set-?>");
        this.workerFactory = hiltWorkerFactory;
    }

    @NotNull
    public Configuration getWorkManagerConfiguration() {
        Configuration.Builder builder = new Configuration.Builder();
        HiltWorkerFactory hiltWorkerFactory = this.workerFactory;
        if (hiltWorkerFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"workerFactory");
        }
        Configuration configuration = builder.setWorkerFactory((WorkerFactory)hiltWorkerFactory).build();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Configuration.Builder()\n\u2026ory)\n            .build()");
        return configuration;
    }

    public void onCreate() {
        super.onCreate();
        this.initData();
    }

    private final void initData() {
        Realm.init((Context)((Context)this));
        this.initSentry();
        this.upgradeSecurityProvider();
    }

    private final void upgradeSecurityProvider() {
        ProviderInstaller.installIfNeededAsync((Context)((Context)this), (ProviderInstaller.ProviderInstallListener)new ProviderInstaller.ProviderInstallListener(this){
            final /* synthetic */ SDKApplication this$0;

            public void onProviderInstalled() {
            }

            public void onProviderInstallFailed(int errorCode, @Nullable Intent recoveryIntent) {
                GoogleApiAvailability.getInstance().showErrorNotification(this.this$0.getApplicationContext(), errorCode);
            }
            {
                this.this$0 = this$0;
            }
        });
    }

    private final void initSentry() {
        if (ConfigAppKt.isProduction()) {
            SentryAndroid.init((Context)((Context)this), (Sentry.OptionsConfiguration)initSentry.1.INSTANCE);
        }
    }
}

