/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.content.res.Resources;
import android.os.Build;
import android.text.Html;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import androidx.annotation.StringRes;
import com.netacom.base.chat.android_utils.Utils;
import java.util.Arrays;
import java.util.IllegalFormatException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0007\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\rJ-\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\r2\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0007\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004\u00a8\u0006\u001a"}, d2={"Lcom/netacom/base/chat/android_utils/StringUtils;", "", "()V", "format", "", "str", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "fromHtmlText", "code", "getString", "id", "", "formatArgs", "(I[Ljava/lang/Object;)Ljava/lang/String;", "handleSpecialChar", "text", "isTextType", "", "isSpace", "s", "spanText", "Landroid/text/Spannable;", "senderName", "content", "netacom-base-chat_NetAloProdRelease"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();

    private StringUtils() {
    }

    private final String format(String str, Object ... args) {
        String text = str;
        if (text != null) {
            T[] TArray = args;
            boolean bl = false;
            T[] TArray2 = TArray;
            boolean bl2 = false;
            if (!(TArray2.length == 0)) {
                try {
                    TArray = StringCompanionObject.INSTANCE;
                    Intrinsics.checkNotNull((Object)str);
                    String string = str;
                    TArray2 = Arrays.copyOf(args, args.length);
                    bl2 = false;
                    String string2 = String.format(string, Arrays.copyOf(TArray2, TArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                    text = string2;
                }
                catch (IllegalFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return text;
    }

    @NotNull
    public final String getString(@StringRes int id2) {
        String string;
        try {
            string = Utils.getApp().getResources().getString(id2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            Utils.getApp().resources.getString(id)\n        }");
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            string = String.valueOf(id2);
        }
        return string;
    }

    @NotNull
    public final String getString(@StringRes int id2, Object ... formatArgs) {
        String string;
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        try {
            string = this.format(Utils.getApp().getResources().getString(id2), Arrays.copyOf(formatArgs, formatArgs.length));
            string = string == null ? "" : string;
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
            string = String.valueOf(id2);
        }
        return string;
    }

    public final boolean isSpace(@Nullable String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Spannable spanText(@NotNull String senderName, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)senderName, (String)"senderName");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        SpannableString span = new SpannableString((CharSequence)Intrinsics.stringPlus((String)senderName, (Object)content));
        CharSequence charSequence = senderName;
        boolean bl = false;
        if (charSequence.length() > 0) {
            span.setSpan((Object)new StyleSpan(1), 0, senderName.length(), 34);
        }
        return (Spannable)span;
    }

    @NotNull
    public final String fromHtmlText(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return Build.VERSION.SDK_INT >= 24 ? Html.fromHtml((String)code, (int)0).toString() : Html.fromHtml((String)code).toString();
    }

    @Nullable
    public final String handleSpecialChar(@Nullable String text, boolean isTextType) {
        String string;
        String string2 = text;
        if (string2 == null) {
            return null;
        }
        if (StringsKt.isBlank((CharSequence)text)) {
            string = "";
        } else if (isTextType) {
            string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\r", (String)"\\r", (boolean)false, (int)4, null), (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        } else {
            string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
            boolean bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        }
        return string;
    }

    public static /* synthetic */ String handleSpecialChar$default(StringUtils stringUtils, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stringUtils.handleSpecialChar(string, bl);
    }
}

