/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.netacom.base.chat.android_utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class AdaptScreenUtils {
    private static List<Field> sMetricsFields;

    private AdaptScreenUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static Resources adaptWidth(Resources resources, int designWidth) {
        float newXdpi = (float)resources.getDisplayMetrics().widthPixels * 72.0f / (float)designWidth;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        return resources;
    }

    public static Resources adaptHeight(Resources resources, int designHeight) {
        return AdaptScreenUtils.adaptHeight(resources, designHeight, false);
    }

    public static Resources adaptHeight(Resources resources, int designHeight, boolean includeNavBar) {
        float screenHeight = (float)(resources.getDisplayMetrics().heightPixels + (includeNavBar ? AdaptScreenUtils.getNavBarHeight(resources) : 0)) * 72.0f;
        float newXdpi = screenHeight / (float)designHeight;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        return resources;
    }

    private static int getNavBarHeight(Resources resources) {
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId != 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static Resources closeAdapt(Resources resources) {
        float newXdpi = Resources.getSystem().getDisplayMetrics().density * 72.0f;
        AdaptScreenUtils.applyDisplayMetrics(resources, newXdpi);
        return resources;
    }

    public static int pt2Px(float ptValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(ptValue * metrics.xdpi / 72.0f) + 0.5);
    }

    public static int px2Pt(float pxValue) {
        DisplayMetrics metrics = Utils.getApp().getResources().getDisplayMetrics();
        return (int)((double)(pxValue * 72.0f / metrics.xdpi) + 0.5);
    }

    private static void applyDisplayMetrics(Resources resources, float newXdpi) {
        resources.getDisplayMetrics().xdpi = newXdpi;
        Utils.getApp().getResources().getDisplayMetrics().xdpi = newXdpi;
        AdaptScreenUtils.applyOtherDisplayMetrics(resources, newXdpi);
    }

    static Runnable getPreLoadRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                AdaptScreenUtils.preLoad();
            }
        };
    }

    private static void preLoad() {
        AdaptScreenUtils.applyDisplayMetrics(Resources.getSystem(), Resources.getSystem().getDisplayMetrics().xdpi);
    }

    private static void applyOtherDisplayMetrics(Resources resources, float newXdpi) {
        if (sMetricsFields == null) {
            sMetricsFields = new ArrayList<Field>();
            Class<?> resCls = resources.getClass();
            Field[] declaredFields = resCls.getDeclaredFields();
            while (declaredFields != null && declaredFields.length > 0) {
                for (Field field : declaredFields) {
                    if (!field.getType().isAssignableFrom(DisplayMetrics.class)) continue;
                    field.setAccessible(true);
                    DisplayMetrics tmpDm = AdaptScreenUtils.getMetricsFromField(resources, field);
                    if (tmpDm == null) continue;
                    sMetricsFields.add(field);
                    tmpDm.xdpi = newXdpi;
                }
                if ((resCls = resCls.getSuperclass()) != null) {
                    declaredFields = resCls.getDeclaredFields();
                    continue;
                }
                break;
            }
        } else {
            AdaptScreenUtils.applyMetricsFields(resources, newXdpi);
        }
    }

    private static void applyMetricsFields(Resources resources, float newXdpi) {
        for (Field metricsField : sMetricsFields) {
            try {
                DisplayMetrics dm = (DisplayMetrics)metricsField.get(resources);
                if (dm == null) continue;
                dm.xdpi = newXdpi;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static DisplayMetrics getMetricsFromField(Resources resources, Field field) {
        try {
            return (DisplayMetrics)field.get(resources);
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

