/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.logger;

import androidx.annotation.NonNull;
import com.netacom.base.chat.logger.LogAdapter;
import com.netacom.base.chat.logger.Printer;
import com.netacom.base.chat.logger.Utils;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J3\u0010\u0010\u001a\u00020\u00052\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0003\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u00020\r2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00010\u0014H\u0016J3\u0010\u0016\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J3\u0010\u0019\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J?\u0010\u0019\u001a\u00020\r2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u001cJ3\u0010\u001d\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u001e\u001a\u00020\r2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0016J4\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016JG\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u00020\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0016J3\u0010%\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J3\u0010&\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J3\u0010'\u001a\u00020\r2\n\b\u0001\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0018\b\u0001\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010(\u001a\u00020\r2\n\b\u0001\u0010(\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\u00058CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/netacom/base/chat/logger/LoggerPrinter;", "Lcom/netacom/base/chat/logger/Printer;", "()V", "localTag", "Ljava/lang/ThreadLocal;", "", "logAdapters", "", "Lcom/netacom/base/chat/logger/LogAdapter;", "tag", "getTag", "()Ljava/lang/String;", "addAdapter", "", "adapter", "clearLogAdapters", "createMessage", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "d", "object", "(Ljava/lang/String;[Ljava/lang/Object;)V", "e", "throwable", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "i", "json", "log", "priority", "", "msg", "(ILjava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "t", "v", "w", "wtf", "xml", "Companion", "netacom-base-chat_NetAloProdRelease"})
public final class LoggerPrinter
implements Printer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadLocal<String> localTag = new ThreadLocal();
    @NotNull
    private final List<LogAdapter> logAdapters = new ArrayList();
    private static final int JSON_INDENT = 2;

    @Override
    @NotNull
    public Printer t(@Nullable String tag) {
        if (tag != null) {
            this.localTag.set(tag);
        }
        return this;
    }

    @Override
    public void d(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(3, null, message, objectArray);
    }

    @Override
    public void d(@androidx.annotation.Nullable @Nullable Object object) {
        this.log(3, null, Utils.INSTANCE.toString(object), new Object[0]);
    }

    @Override
    public void e(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(6, null, message, objectArray);
    }

    @Override
    public void e(@androidx.annotation.Nullable @Nullable Throwable throwable, @NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(6, throwable, message, objectArray);
    }

    @Override
    public void w(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(5, null, message, objectArray);
    }

    @Override
    public void i(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(4, null, message, objectArray);
    }

    @Override
    public void v(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(2, null, message, objectArray);
    }

    @Override
    public void wtf(@NonNull @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        this.log(7, null, message, objectArray);
    }

    @Override
    public void json(@androidx.annotation.Nullable @Nullable String json) {
        if (json == null) {
            return;
        }
        String json2 = json;
        if (Utils.INSTANCE.isEmpty(json2)) {
            this.d("Empty/Null json content", new Object[0]);
            return;
        }
        try {
            String $this$trim$iv = json2;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (StringsKt.startsWith$default((String)(json2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (String)"{", (boolean)false, (int)2, null)) {
                JSONObject jsonObject = new JSONObject(json2);
                String message = jsonObject.toString(2);
                this.d(message, new Object[0]);
                return;
            }
            if (StringsKt.startsWith$default((String)json2, (String)"[", (boolean)false, (int)2, null)) {
                JSONArray jsonArray = new JSONArray(json2);
                String message = jsonArray.toString(2);
                this.d(message, new Object[0]);
                return;
            }
            this.e("Invalid Json", new Object[0]);
        }
        catch (JSONException e) {
            this.e("Invalid Json", new Object[0]);
        }
    }

    @Override
    public void xml(@androidx.annotation.Nullable @Nullable String xml) {
        if (Utils.INSTANCE.isEmpty(xml)) {
            this.d("Empty/Null xml content", new Object[0]);
            return;
        }
        try {
            Source xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            CharSequence charSequence = xmlOutput.getWriter().toString();
            String string2 = ">";
            boolean bl = false;
            string2 = new Regex(string2);
            String string3 = ">\n";
            boolean bl2 = false;
            this.d(string2.replaceFirst(charSequence, string3), new Object[0]);
        }
        catch (TransformerException e) {
            this.e("Invalid xml", new Object[0]);
        }
    }

    @Override
    public synchronized void log(int priority, @androidx.annotation.Nullable @Nullable String tag, @androidx.annotation.Nullable @Nullable String message, @androidx.annotation.Nullable @Nullable Throwable throwable) {
        String message2 = message;
        if (throwable != null && message2 != null) {
            message2 = message2 + " : " + Utils.INSTANCE.getStackTraceString(throwable);
        }
        if (throwable != null && message2 == null) {
            message2 = Utils.INSTANCE.getStackTraceString(throwable);
        }
        if (Utils.INSTANCE.isEmpty(message2)) {
            message2 = "Empty/NULL log message";
        }
        for (LogAdapter adapter : this.logAdapters) {
            if (!adapter.isLoggable(priority, tag)) continue;
            adapter.log(priority, tag, message2);
        }
    }

    @Override
    public void clearLogAdapters() {
        this.logAdapters.clear();
    }

    @Override
    public void addAdapter(@NonNull @Nullable LogAdapter adapter) {
        this.logAdapters.add(Utils.INSTANCE.checkNotNull(adapter));
    }

    private final synchronized void log(int priority, @androidx.annotation.Nullable Throwable throwable, @NonNull String msg, Object ... args) {
        Utils.INSTANCE.checkNotNull(msg);
        String tag = this.getTag();
        Object[] objectArray = new Object[args.length];
        System.arraycopy(args, 0, objectArray, 0, args.length);
        String message = this.createMessage(msg, objectArray);
        this.log(priority, tag, message, throwable);
    }

    @androidx.annotation.Nullable
    private final String getTag() {
        String tag = this.localTag.get();
        if (tag != null) {
            this.localTag.remove();
            return tag;
        }
        return null;
    }

    @NonNull
    private final String createMessage(@NonNull String message, Object ... args) {
        String string2;
        if (message == null) {
            return "";
        }
        Object object = args;
        boolean bl = false;
        if (((Object[])object).length == 0) {
            string2 = message;
        } else {
            try {
                object = StringCompanionObject.INSTANCE;
                Object[] objectArray = new Object[((StringCompanionObject)args).length];
                System.arraycopy(args, 0, objectArray, 0, ((StringCompanionObject)args).length);
                boolean bl2 = false;
                String string3 = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                object = string3;
            }
            catch (Exception e) {
                object = "";
            }
            string2 = object;
        }
        return string2;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netacom/base/chat/logger/LoggerPrinter$Companion;", "", "()V", "JSON_INDENT", "", "netacom-base-chat_NetAloProdRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

