/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.logger;

import androidx.annotation.NonNull;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u0001H\u0004H\u0007\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0017"}, d2={"Lcom/netacom/base/chat/logger/Utils;", "", "()V", "checkNotNull", "T", "obj", "(Ljava/lang/Object;)Ljava/lang/Object;", "equals", "", "a", "", "b", "getStackTraceString", "", "tr", "", "isEmpty", "str", "logLevel", "value", "", "toString", "object", "netacom-base-chat_NetAloProdRelease"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEmpty(@Nullable CharSequence str) {
        if (str == null) return true;
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    public final boolean equals(@Nullable CharSequence a, @Nullable CharSequence b) {
        int length;
        if (a == b) {
            return true;
        }
        if (a != null && b != null && (length = a.length()) == b.length()) {
            boolean bl;
            if (a instanceof String && b instanceof String) {
                bl = Intrinsics.areEqual((Object)a, (Object)b);
            } else {
                int n = 0;
                if (n < length) {
                    do {
                        int i;
                        if (a.charAt(i = n++) == b.charAt(i)) continue;
                        return false;
                    } while (n < length);
                }
                bl = true;
            }
            return bl;
        }
        return false;
    }

    @NotNull
    public final String getStackTraceString(@Nullable Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        String string2 = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sw.toString()");
        return string2;
    }

    @NotNull
    public final String logLevel(int value) {
        String string2;
        int n = value;
        switch (n) {
            case 2: {
                string2 = "VERBOSE";
                break;
            }
            case 3: {
                string2 = "DEBUG";
                break;
            }
            case 4: {
                string2 = "INFO";
                break;
            }
            case 5: {
                string2 = "WARN";
                break;
            }
            case 6: {
                string2 = "ERROR";
                break;
            }
            case 7: {
                string2 = "ASSERT";
                break;
            }
            default: {
                string2 = "UNKNOWN";
            }
        }
        return string2;
    }

    @NotNull
    public final String toString(@Nullable Object object) {
        String string2;
        if (object == null) {
            return "null";
        }
        if (!object.getClass().isArray()) {
            return object.toString();
        }
        if (object instanceof boolean[]) {
            String string3 = Arrays.toString((boolean[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(`object` as BooleanArray?)");
            return string3;
        }
        if (object instanceof byte[]) {
            String string4 = Arrays.toString((byte[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(`object` as ByteArray?)");
            return string4;
        }
        if (object instanceof char[]) {
            String string5 = Arrays.toString((char[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(`object` as CharArray?)");
            return string5;
        }
        if (object instanceof short[]) {
            String string6 = Arrays.toString((short[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(`object` as ShortArray?)");
            return string6;
        }
        if (object instanceof int[]) {
            String string7 = Arrays.toString((int[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(`object` as IntArray?)");
            return string7;
        }
        if (object instanceof long[]) {
            String string8 = Arrays.toString((long[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(`object` as LongArray?)");
            return string8;
        }
        if (object instanceof float[]) {
            String string9 = Arrays.toString((float[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toString(`object` as FloatArray?)");
            return string9;
        }
        if (object instanceof double[]) {
            String string10 = Arrays.toString((double[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(`object` as DoubleArray?)");
            return string10;
        }
        if (object instanceof Object[]) {
            String string11 = Arrays.deepToString((Object[])object);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"{\n            Arrays.deepToString(`object` as Array<Any?>?)\n        }");
            string2 = string11;
        } else {
            string2 = "Couldn't find a correct com.netacom.com.netacom.base.chat.type for the object";
        }
        return string2;
    }

    @NonNull
    public final <T> T checkNotNull(@androidx.annotation.Nullable @Nullable T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }
}

