/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DebouncingUtils {
    private static final int CACHE_SIZE = 64;
    private static final Map<String, Long> KEY_MILLIS_MAP = new ConcurrentHashMap<String, Long>(64);
    private static final long DEBOUNCING_DEFAULT_VALUE = 1000L;

    private DebouncingUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isValid(@NonNull View view) {
        return DebouncingUtils.isValid(view, 1000L);
    }

    public static boolean isValid(@NonNull View view, long duration) {
        return DebouncingUtils.isValid(String.valueOf(view.hashCode()), duration);
    }

    public static boolean isValid(@NonNull String key, long duration) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("The key is null.");
        }
        if (duration < 0L) {
            throw new IllegalArgumentException("The duration is less than 0.");
        }
        long curTime = SystemClock.elapsedRealtime();
        DebouncingUtils.clearIfNecessary(curTime);
        Long validTime = KEY_MILLIS_MAP.get(key);
        if (validTime == null || curTime >= validTime) {
            KEY_MILLIS_MAP.put(key, curTime + duration);
            return true;
        }
        return false;
    }

    private static void clearIfNecessary(long curTime) {
        if (KEY_MILLIS_MAP.size() < 64) {
            return;
        }
        Iterator<Map.Entry<String, Long>> it = KEY_MILLIS_MAP.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Long> entry = it.next();
            Long validTime = entry.getValue();
            if (curTime < validTime) continue;
            it.remove();
        }
    }
}

