/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.logger;

import androidx.annotation.NonNull;
import com.netacom.base.chat.logger.FormatStrategy;
import com.netacom.base.chat.logger.LogStrategy;
import com.netacom.base.chat.logger.LogcatLogStrategy;
import com.netacom.base.chat.logger.Logger;
import com.netacom.base.chat.logger.LoggerPrinter;
import com.netacom.base.chat.logger.Utils;
import java.nio.charset.Charset;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\r2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\rH\u0003J\u0012\u0010\u000f\u001a\u00020\r2\b\b\u0001\u0010\u0010\u001a\u00020\rH\u0002J\u001d\u0010\u0011\u001a\u00020\b2\u000e\b\u0001\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\r2\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002J$\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u001e\u001a\u00020\rH\u0002J&\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\r2\n\b\u0001\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002J\u001a\u0010 \u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002J\"\u0010!\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\"\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0002R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/netacom/base/chat/logger/PrettyFormatStrategy;", "Lcom/netacom/base/chat/logger/FormatStrategy;", "builder", "Lcom/netacom/base/chat/logger/PrettyFormatStrategy$Builder;", "(Lcom/netacom/base/chat/logger/PrettyFormatStrategy$Builder;)V", "logStrategy", "Lcom/netacom/base/chat/logger/LogStrategy;", "methodCount", "", "methodOffset", "showThreadInfo", "", "tag", "", "formatTag", "getSimpleClassName", "name", "getStackOffset", "trace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)I", "log", "", "priority", "onceOnlyTag", "message", "logBottomBorder", "logType", "logChunk", "chunk", "logContent", "logDivider", "logHeaderContent", "logTopBorder", "Builder", "Companion", "netacom-base-chat_NetAloProdRelease"})
public final class PrettyFormatStrategy
implements FormatStrategy {
    private final int methodCount;
    private final int methodOffset;
    private final boolean showThreadInfo;
    @NonNull
    private final LogStrategy logStrategy;
    @androidx.annotation.Nullable
    private final String tag;
    private static final int CHUNK_SIZE = 4000;
    private static final int MIN_STACK_OFFSET = 5;
    private static final char TOP_LEFT_CORNER = '\u250c';
    private static final char BOTTOM_LEFT_CORNER = '\u2514';
    private static final char MIDDLE_CORNER = '\u251c';
    private static final char HORIZONTAL_LINE = '\u2502';
    private static final String DOUBLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String SINGLE_DIVIDER = "\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    private static final String TOP_BORDER = "\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String BOTTOM_BORDER = "\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String MIDDLE_BORDER = "\u251c\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504\u2504";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void log(int priority, @androidx.annotation.Nullable @Nullable String onceOnlyTag, @NonNull @Nullable String message) {
        Utils.INSTANCE.checkNotNull(message);
        String tag = this.formatTag(onceOnlyTag);
        this.logTopBorder(priority, tag);
        this.logHeaderContent(priority, tag, this.methodCount);
        String string2 = message;
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        int length = bytes.length;
        if (length <= 4000) {
            if (this.methodCount > 0) {
                this.logDivider(priority, tag);
            }
            this.logContent(priority, tag, message);
            this.logBottomBorder(priority, tag);
            return;
        }
        if (this.methodCount > 0) {
            this.logDivider(priority, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            boolean bl2 = false;
            this.logContent(priority, tag, new String(bytes, i, count, Charsets.UTF_8));
        }
        this.logBottomBorder(priority, tag);
    }

    private final void logTopBorder(int logType, @androidx.annotation.Nullable String tag) {
        this.logChunk(logType, tag, TOP_BORDER);
    }

    /*
     * WARNING - void declaration
     */
    private final void logHeaderContent(int logType, @androidx.annotation.Nullable String tag, int methodCount) {
        int methodCount2 = methodCount;
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"Thread.currentThread()");
        StackTraceElement[] trace = thread.getStackTrace();
        if (this.showThreadInfo) {
            StringBuilder stringBuilder = new StringBuilder().append("\u2502 Thread: ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"Thread.currentThread()");
            this.logChunk(logType, tag, stringBuilder.append(thread2.getName()).toString());
            this.logDivider(logType, tag);
        }
        String level = "";
        Intrinsics.checkNotNullExpressionValue((Object)trace, (String)"trace");
        int stackOffset = this.getStackOffset(trace) + this.methodOffset;
        if (methodCount2 + stackOffset > trace.length) {
            methodCount2 = trace.length - stackOffset - 1;
        }
        int n = methodCount2;
        int n2 = 1;
        while (n >= n2) {
            void i;
            void stackIndex = i + stackOffset;
            if (stackIndex < trace.length) {
                StringBuilder builder = new StringBuilder();
                StringBuilder stringBuilder = builder.append('\u2502').append(' ').append(level);
                StackTraceElement stackTraceElement = trace[stackIndex];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"trace[stackIndex]");
                String string2 = stackTraceElement.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trace[stackIndex].className");
                StringBuilder stringBuilder2 = stringBuilder.append(this.getSimpleClassName(string2)).append(".");
                StackTraceElement stackTraceElement2 = trace[stackIndex];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement2, (String)"trace[stackIndex]");
                StringBuilder stringBuilder3 = stringBuilder2.append(stackTraceElement2.getMethodName()).append(" ").append(" (");
                StackTraceElement stackTraceElement3 = trace[stackIndex];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement3, (String)"trace[stackIndex]");
                StringBuilder stringBuilder4 = stringBuilder3.append(stackTraceElement3.getFileName()).append(":");
                StackTraceElement stackTraceElement4 = trace[stackIndex];
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement4, (String)"trace[stackIndex]");
                stringBuilder4.append(stackTraceElement4.getLineNumber()).append(")");
                level = level + "   ";
                String string3 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"builder.toString()");
                this.logChunk(logType, tag, string3);
            }
            --i;
        }
    }

    private final void logBottomBorder(int logType, @androidx.annotation.Nullable String tag) {
        this.logChunk(logType, tag, BOTTOM_BORDER);
    }

    private final void logDivider(int logType, @androidx.annotation.Nullable String tag) {
        this.logChunk(logType, tag, MIDDLE_BORDER);
    }

    private final void logContent(int logType, @androidx.annotation.Nullable String tag, @NonNull String chunk) {
        String[] lines;
        Utils.INSTANCE.checkNotNull(chunk);
        String string2 = chunk;
        Intrinsics.checkNotNull((Object)string2);
        CharSequence charSequence = string2;
        String[] stringArray = new String[1];
        String string3 = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"System.getProperty(\"line.separator\")");
        stringArray[0] = string3;
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        for (String line : lines = stringArray2) {
            this.logChunk(logType, tag, "\u2502 " + line);
        }
    }

    private final void logChunk(int priority, @androidx.annotation.Nullable String tag, @NonNull String chunk) {
        Utils.INSTANCE.checkNotNull(chunk);
        LogStrategy logStrategy = this.logStrategy;
        Intrinsics.checkNotNull((Object)logStrategy);
        logStrategy.log(priority, tag, chunk);
    }

    private final String getSimpleClassName(@NonNull String name) {
        Utils.INSTANCE.checkNotNull(name);
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null);
        String string2 = name;
        int n = lastIndex + 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        return string4;
    }

    private final int getStackOffset(@NonNull StackTraceElement[] trace) {
        Utils.INSTANCE.checkNotNull(trace);
        for (int i = 5; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (!(Intrinsics.areEqual((Object)name, (Object)LoggerPrinter.class.getName()) ^ true) || !(Intrinsics.areEqual((Object)name, (Object)Logger.class.getName()) ^ true)) continue;
            return --i;
        }
        return -1;
    }

    @androidx.annotation.Nullable
    private final String formatTag(@androidx.annotation.Nullable String tag) {
        return !Utils.INSTANCE.isEmpty(tag) && !Utils.INSTANCE.equals(this.tag, tag) ? this.tag + "-" + tag : this.tag;
    }

    private PrettyFormatStrategy(@NonNull Builder builder) {
        Utils.INSTANCE.checkNotNull(builder);
        this.methodCount = builder.getMethodCount();
        this.methodOffset = builder.getMethodOffset();
        this.showThreadInfo = builder.getShowThreadInfo();
        this.logStrategy = builder.getLogStrategy();
        this.tag = builder.getTag();
    }

    public /* synthetic */ PrettyFormatStrategy(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J\u0014\u0010\u0003\u001a\u00020\u00002\n\b\u0001\u0010 \u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nH\u0007J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\nH\u0007J\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0013H\u0007J\u0012\u0010\u0018\u001a\u00020\u00002\b\b\u0001\u0010\u0018\u001a\u00020\u0019H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00198\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006!"}, d2={"Lcom/netacom/base/chat/logger/PrettyFormatStrategy$Builder;", "", "()V", "logStrategy", "Lcom/netacom/base/chat/logger/LogStrategy;", "getLogStrategy", "()Lcom/netacom/base/chat/logger/LogStrategy;", "setLogStrategy", "(Lcom/netacom/base/chat/logger/LogStrategy;)V", "methodCount", "", "getMethodCount", "()I", "setMethodCount", "(I)V", "methodOffset", "getMethodOffset", "setMethodOffset", "showThreadInfo", "", "getShowThreadInfo", "()Z", "setShowThreadInfo", "(Z)V", "tag", "", "getTag", "()Ljava/lang/String;", "setTag", "(Ljava/lang/String;)V", "build", "Lcom/netacom/base/chat/logger/PrettyFormatStrategy;", "val", "netacom-base-chat_NetAloProdRelease"})
    public static final class Builder {
        private int methodCount = 2;
        private int methodOffset;
        private boolean showThreadInfo = true;
        @androidx.annotation.Nullable
        @Nullable
        private LogStrategy logStrategy;
        @androidx.annotation.Nullable
        @NotNull
        private String tag = "PRETTY_LOGGER";

        public final int getMethodCount() {
            return this.methodCount;
        }

        public final void setMethodCount(int n) {
            this.methodCount = n;
        }

        public final int getMethodOffset() {
            return this.methodOffset;
        }

        public final void setMethodOffset(int n) {
            this.methodOffset = n;
        }

        public final boolean getShowThreadInfo() {
            return this.showThreadInfo;
        }

        public final void setShowThreadInfo(boolean bl) {
            this.showThreadInfo = bl;
        }

        @Nullable
        public final LogStrategy getLogStrategy() {
            return this.logStrategy;
        }

        public final void setLogStrategy(@Nullable LogStrategy logStrategy) {
            this.logStrategy = logStrategy;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.tag = string2;
        }

        @NonNull
        @NotNull
        public final Builder methodCount(int val) {
            this.methodCount = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder methodOffset(int val) {
            this.methodOffset = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder showThreadInfo(boolean val) {
            this.showThreadInfo = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder logStrategy(@androidx.annotation.Nullable @Nullable LogStrategy val) {
            this.logStrategy = val;
            return this;
        }

        @NonNull
        @NotNull
        public final Builder tag(@androidx.annotation.Nullable @NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.tag = tag;
            return this;
        }

        @NonNull
        @NotNull
        public final PrettyFormatStrategy build() {
            if (this.logStrategy == null) {
                this.logStrategy = new LogcatLogStrategy();
            }
            return new PrettyFormatStrategy(this, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/netacom/base/chat/logger/PrettyFormatStrategy$Companion;", "", "()V", "BOTTOM_BORDER", "", "BOTTOM_LEFT_CORNER", "", "CHUNK_SIZE", "", "DOUBLE_DIVIDER", "HORIZONTAL_LINE", "MIDDLE_BORDER", "MIDDLE_CORNER", "MIN_STACK_OFFSET", "SINGLE_DIVIDER", "TOP_BORDER", "TOP_LEFT_CORNER", "newBuilder", "Lcom/netacom/base/chat/logger/PrettyFormatStrategy$Builder;", "netacom-base-chat_NetAloProdRelease"})
    public static final class Companion {
        @NonNull
        @NotNull
        public final Builder newBuilder() {
            return new Builder();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

