/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import androidx.core.content.ContextCompat;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.livedata.EventLiveData;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import com.netacom.base.chat.util.ExtensionsUtilsKt$onEachEvent$;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u0001\u001a\u0018\u0010\"\u001a\u00020\u00062\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010!\u001a\u00020\u0001\u001a\n\u0010%\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010&\u001a\u00020\u0006*\u00020\u0002\u001aP\u0010'\u001a\b\u0012\u0004\u0012\u0002H)0(\"\u0004\b\u0000\u0010)*\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001H)0*0(2\"\u0010+\u001a\u001e\b\u0001\u0012\u0004\u0012\u0002H)\u0012\n\u0012\b\u0012\u0004\u0012\u00020.0-\u0012\u0006\u0012\u0004\u0018\u00010\u00130,\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/\u001a$\u00100\u001a\u00020.*\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001H\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\"\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\"\u0017\u0010\u0012\u001a\u00020\u0006*\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u00020\u0006*\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\"\u0015\u0010\u0018\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\"\u0015\u0010\u001a\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\r\"\u0015\u0010\u001c\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\r\"\u0015\u0010\u001e\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"asColor", "", "", "getAsColor", "(Ljava/lang/String;)Ljava/lang/Integer;", "containsDigit", "", "getContainsDigit", "(Ljava/lang/String;)Z", "containsLatinLetter", "getContainsLatinLetter", "creditCardFormatted", "getCreditCardFormatted", "(Ljava/lang/String;)Ljava/lang/String;", "hasLettersAndDigits", "getHasLettersAndDigits", "isAlphanumeric", "isIntegerNumber", "isNotNull", "", "(Ljava/lang/Object;)Z", "isNotZero", "(I)Z", "isNull", "lastPathComponent", "getLastPathComponent", "md5", "getMd5", "sha1", "getSha1", "toDecimalNumber", "getToDecimalNumber", "getThemeColor", "resId", "isResource", "context", "Landroid/content/Context;", "isEmailValid", "isLocalLink", "onEachEvent", "Lkotlinx/coroutines/flow/Flow;", "T", "Lcom/netacom/base/chat/livedata/EventLiveData;", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "(Lkotlinx/coroutines/flow/Flow;Lkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/flow/Flow;", "writeBitmap", "Ljava/io/File;", "bitmap", "Landroid/graphics/Bitmap;", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "netacom-base-chat_NetAloProdRelease"})
public final class ExtensionsUtilsKt {
    @NotNull
    public static final String getMd5(@NotNull String $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"$this$md5");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string2 = $this$md5;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, (Function1)md5.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String getSha1(@NotNull String $this$sha1) {
        Intrinsics.checkNotNullParameter((Object)$this$sha1, (String)"$this$sha1");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string2 = $this$sha1;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, (Function1)sha1.1.INSTANCE, (int)30, null);
    }

    public static final boolean isEmailValid(@NotNull String $this$isEmailValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmailValid, (String)"$this$isEmailValid");
        String expression = "^[\\w.-]+@([\\w\\-]+\\.)+[A-Z]{2,8}$";
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher($this$isEmailValid);
        return matcher.matches();
    }

    public static final boolean isLocalLink(@NotNull String $this$isLocalLink) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalLink, (String)"$this$isLocalLink");
        return StringsKt.startsWith$default((String)$this$isLocalLink, (String)"/storage", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLocalLink, (String)"/data/user", (boolean)false, (int)2, null);
    }

    public static final boolean getContainsLatinLetter(@NotNull String $this$containsLatinLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLatinLetter, (String)"$this$containsLatinLetter");
        CharSequence charSequence = $this$containsLatinLetter;
        Regex regex = new Regex(".*[A-Za-z].*");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    public static final boolean getContainsDigit(@NotNull String $this$containsDigit) {
        Intrinsics.checkNotNullParameter((Object)$this$containsDigit, (String)"$this$containsDigit");
        CharSequence charSequence = $this$containsDigit;
        Regex regex = new Regex(".*[0-9].*");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    public static final boolean isAlphanumeric(@NotNull String $this$isAlphanumeric) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlphanumeric, (String)"$this$isAlphanumeric");
        CharSequence charSequence = $this$isAlphanumeric;
        Regex regex = new Regex("[A-Za-z0-9]*");
        boolean bl = false;
        return regex.matches(charSequence);
    }

    public static final boolean getHasLettersAndDigits(@NotNull String $this$hasLettersAndDigits) {
        Intrinsics.checkNotNullParameter((Object)$this$hasLettersAndDigits, (String)"$this$hasLettersAndDigits");
        return ExtensionsUtilsKt.getContainsLatinLetter($this$hasLettersAndDigits) && ExtensionsUtilsKt.getContainsDigit($this$hasLettersAndDigits);
    }

    public static final boolean isIntegerNumber(@NotNull String $this$isIntegerNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntegerNumber, (String)"$this$isIntegerNumber");
        return StringsKt.toIntOrNull((String)$this$isIntegerNumber) != null;
    }

    public static final boolean getToDecimalNumber(@NotNull String $this$toDecimalNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$toDecimalNumber, (String)"$this$toDecimalNumber");
        return StringsKt.toDoubleOrNull((String)$this$toDecimalNumber) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNull(@Nullable Object $this$isNull) {
        Object object = $this$isNull;
        if (Intrinsics.areEqual((Object)object, (Object)($this$isNull == null ? 1 : 0))) {
            return true;
        }
        Object object2 = object;
        if (object2 != null ? object2 instanceof Collection : true) {
            Collection collection = (Collection)$this$isNull;
            if (collection == null) return true;
            int n = collection.size();
            if (n != 0) return false;
            return true;
        }
        Object object3 = object;
        if (object3 != null ? object3 instanceof String : true) {
            String string2 = (String)$this$isNull;
            if (string2 != null) {
                if (string2.length() == 0) return true;
            }
            CharSequence charSequence = (CharSequence)$this$isNull;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null) return true;
            if (!StringsKt.isBlank((CharSequence)charSequence)) return false;
            return true;
        }
        Object object4 = object;
        if (!(object4 != null ? object4 instanceof Long : true)) {
            if ($this$isNull != null) return false;
            return true;
        }
        boolean bl = Intrinsics.areEqual((Object)$this$isNull, (Object)0L);
        return bl;
    }

    public static final boolean isNotNull(@Nullable Object $this$isNotNull) {
        return !ExtensionsUtilsKt.isNull($this$isNotNull);
    }

    public static final boolean isNotZero(int $this$isNotZero) {
        return $this$isNotZero != 0;
    }

    @NotNull
    public static final String getLastPathComponent(@NotNull String $this$lastPathComponent) {
        int index;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$lastPathComponent, (String)"$this$lastPathComponent");
        String path = $this$lastPathComponent;
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            String string2 = path;
            int n3 = 0;
            n2 = path.length() - 1;
            n = 0;
            String string3 = string2.substring(n3, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            path = string3;
        }
        if ((index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null)) < 0) {
            if (StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
                String string4 = path;
                n2 = 0;
                n = path.length() - 1;
                boolean bl = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n2, n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                path = string6;
            }
            if ((index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null)) < 0) {
                return path;
            }
        }
        String string7 = path;
        n2 = index + 1;
        n = 0;
        String string8 = string7;
        if (string8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n2);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
        return string9;
    }

    @Nullable
    public static final Integer getAsColor(@NotNull String $this$asColor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$asColor, (String)"$this$asColor");
        try {
            n = Color.parseColor((String)$this$asColor);
        }
        catch (IllegalArgumentException e) {
            n = null;
        }
        return n;
    }

    public static final boolean isResource(@Nullable Context context, int resId) {
        if (context != null) {
            try {
                return context.getResources().getResourceName(resId) != null;
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final int getThemeColor(int resId) {
        return ExtensionsUtilsKt.isResource((Context)Utils.getApp(), resId) ? ContextCompat.getColor((Context)((Context)Utils.getApp()), (int)resId) : resId;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getCreditCardFormatted(@NotNull String $this$creditCardFormatted) {
        Intrinsics.checkNotNullParameter((Object)$this$creditCardFormatted, (String)"$this$creditCardFormatted");
        String string2 = StringsKt.replace$default((String)$this$creditCardFormatted, (String)" ", (String)"", (boolean)false, (int)4, null);
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String preparedString = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        StringBuilder result = new StringBuilder();
        n = 0;
        int n2 = ((CharSequence)preparedString).length();
        while (n < n2) {
            void i;
            if (i % 4 == false && i != false) {
                result.append(" ");
            }
            result.append(preparedString.charAt((int)i));
            ++i;
        }
        String string4 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"result.toString()");
        return string4;
    }

    @NotNull
    public static final <T> Flow<T> onEachEvent(@NotNull Flow<? extends EventLiveData<? extends T>> $this$onEachEvent, @NotNull Function2<? super T, ? super Continuation<? super Unit>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter($this$onEachEvent, (String)"$this$onEachEvent");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Flow<? extends EventLiveData<? extends T>> $this$transform$iv = $this$onEachEvent;
        boolean $i$f$transform = false;
        return FlowKt.flow((Function2)new Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object>($this$transform$iv, null, action){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ Flow $this_transform;
            final /* synthetic */ Function2 $action$inlined;
            {
                this.$this_transform = flow;
                this.$action$inlined = function2;
                super(2, continuation);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$flow = (FlowCollector)this.L$0;
                        Flow flow = this.$this_transform;
                        onEachEvent$$inlined$transform$1 var5_5 = this;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<EventLiveData<? extends T>>(this, $this$flow){
                            final /* synthetic */ onEachEvent$$inlined$transform$1 this$0;
                            final /* synthetic */ FlowCollector $this_flow$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$this_flow$inlined = flowCollector;
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                                block9: {
                                    if (!(var2_2 instanceof onEachEvent$$inlined$transform$1$1$1)) ** GOTO lbl-1000
                                    var3_3 = var2_2;
                                    if ((var3_3.label & -2147483648) != 0) {
                                        var3_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, var2_2){
                                            /* synthetic */ Object result;
                                            int label;
                                            final /* synthetic */ onEachEvent$$inlined$transform$1$1 this$0;
                                            Object L$0;
                                            Object L$1;
                                            {
                                                this.this$0 = var1_1;
                                                super(continuation);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation)this);
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var6_6 = $continuation;
                                            value = value;
                                            $i$a$-collect-FlowKt__EmittersKt$transform$1$1 = false;
                                            var9_11 = (Continuation)$continuation;
                                            var10_12 = (EventLiveData)value;
                                            $receiver = this.$this_flow$inlined;
                                            $i$a$-transform-ExtensionsUtilsKt$onEachEvent$1 = false;
                                            v0 = value.getContentIfNotHandled();
                                            if (v0 == null) break;
                                            var13_17 = v0;
                                            var14_18 = false;
                                            var15_19 = false;
                                            it = var13_17;
                                            $i$a$-let-ExtensionsUtilsKt$onEachEvent$1$1 = false;
                                            v1 = this.this$0.$action$inlined;
                                            $continuation.L$0 = $receiver;
                                            $continuation.L$1 = it;
                                            $continuation.label = 1;
                                            InlineMarker.mark((int)6);
                                            v2 = v1.invoke(it, (Object)$continuation);
                                            InlineMarker.mark((int)7);
                                            v3 = v2;
                                            if (v2 == var5_5) {
                                                return var5_5;
                                            }
                                            ** GOTO lbl45
                                        }
                                        case 1: {
                                            $i$a$-collect-FlowKt__EmittersKt$transform$1$1 = false;
                                            $i$a$-transform-ExtensionsUtilsKt$onEachEvent$1 = false;
                                            $i$a$-let-ExtensionsUtilsKt$onEachEvent$1$1 = false;
                                            it = $continuation.L$1;
                                            $receiver = (FlowCollector)$continuation.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v3 = $result;
lbl45:
                                            // 2 sources

                                            $continuation.L$0 = null;
                                            $continuation.L$1 = null;
                                            $continuation.label = 2;
                                            v4 = $receiver.emit(it, (Continuation)$continuation);
                                            if (v4 == var5_5) {
                                                return var5_5;
                                            }
                                            ** GOTO lbl58
                                        }
                                        case 2: {
                                            $i$a$-collect-FlowKt__EmittersKt$transform$1$1 = false;
                                            $i$a$-transform-ExtensionsUtilsKt$onEachEvent$1 = false;
                                            $i$a$-let-ExtensionsUtilsKt$onEachEvent$1$1 = false;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v4 = $result;
lbl58:
                                            // 2 sources

                                            v5 = Unit.INSTANCE;
                                            break block9;
                                        }
                                    }
                                    v5 = Unit.INSTANCE;
                                }
                                return v5;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                        }, (Continuation)var5_5);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                Function2<FlowCollector<? super T>, Continuation<? super Unit>, Object> function22 = function2;
                return function22;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeBitmap(File $this$writeBitmap, Bitmap bitmap, Bitmap.CompressFormat format, int quality) {
        Object object = $this$writeBitmap;
        boolean bl = false;
        object = new FileOutputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)object;
            boolean bl3 = false;
            bitmap.compress(format, quality, (OutputStream)out);
            out.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }
}

