/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import android.app.ActivityManager;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import androidx.core.content.ContextCompat;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.util.ExtensionsUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a>\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020\"0 \"\u0004\b\u0000\u0010!2\b\b\u0002\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H!\u0012\u0004\u0012\u00020\"0 \u001a\u000e\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\u0001\u001a\u0018\u0010*\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010)\u001a\u00020\u0001\u001a\n\u0010-\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010.\u001a\u00020\u0006*\u00020\u0002\u001a\u0016\u0010/\u001a\u00020\u0006*\u00020,2\n\u00100\u001a\u0006\u0012\u0002\b\u000301\u001a$\u00102\u001a\u00020\"*\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0001H\u0002\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\t\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000e\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\"\u0015\u0010\u0010\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\b\"\u0017\u0010\u0012\u001a\u00020\u0006*\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0017\u0010\u0015\u001a\u00020\u0006*\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\"\u0017\u0010\u0016\u001a\u00020\u0006*\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\"\u0015\u0010\u0017\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\r\"\u0015\u0010\u0019\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\r\"\u0015\u0010\u001b\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\r\"\u0015\u0010\u001d\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\b\u00a8\u00069"}, d2={"asColor", "", "", "getAsColor", "(Ljava/lang/String;)Ljava/lang/Integer;", "containsDigit", "", "getContainsDigit", "(Ljava/lang/String;)Z", "containsLatinLetter", "getContainsLatinLetter", "creditCardFormatted", "getCreditCardFormatted", "(Ljava/lang/String;)Ljava/lang/String;", "hasLettersAndDigits", "getHasLettersAndDigits", "isAlphanumeric", "isIntegerNumber", "isNotNull", "", "(Ljava/lang/Object;)Z", "isNull", "isValid", "lastPathComponent", "getLastPathComponent", "md5", "getMd5", "sha1", "getSha1", "toDecimalNumber", "getToDecimalNumber", "debounce", "Lkotlin/Function1;", "T", "", "delayMillis", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "action", "getThemeColor", "resId", "isResource", "context", "Landroid/content/Context;", "isEmailValid", "isLocalLink", "isServiceRunning", "serviceClass", "Ljava/lang/Class;", "writeBitmap", "Ljava/io/File;", "bitmap", "Landroid/graphics/Bitmap;", "format", "Landroid/graphics/Bitmap$CompressFormat;", "quality", "netacom-base-chat_NetAloDevRelease"})
public final class ExtensionsUtilsKt {
    @NotNull
    public static final String getMd5(@NotNull String $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string2 = $this$md5;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, (Function1)md5.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String getSha1(@NotNull String $this$sha1) {
        Intrinsics.checkNotNullParameter((Object)$this$sha1, (String)"<this>");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        String string2 = $this$sha1;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return ArraysKt.joinToString$default((byte[])bytes, (CharSequence)"", null, null, (int)0, null, (Function1)sha1.1.INSTANCE, (int)30, null);
    }

    public static final boolean isEmailValid(@NotNull String $this$isEmailValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmailValid, (String)"<this>");
        String expression = "^[\\w.-]+@([\\w\\-]+\\.)+[A-Z]{2,8}$";
        Pattern pattern = Pattern.compile(expression, 2);
        Matcher matcher = pattern.matcher($this$isEmailValid);
        return matcher.matches();
    }

    public static final boolean isLocalLink(@NotNull String $this$isLocalLink) {
        Intrinsics.checkNotNullParameter((Object)$this$isLocalLink, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isLocalLink, (String)"/storage", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isLocalLink, (String)"/data/user", (boolean)false, (int)2, null);
    }

    public static final boolean isValid(@Nullable String $this$isValid) {
        String string2 = $this$isValid;
        return (string2 == null ? null : StringsKt.toLongOrNull((String)string2)) != null;
    }

    public static final boolean getContainsLatinLetter(@NotNull String $this$containsLatinLetter) {
        Intrinsics.checkNotNullParameter((Object)$this$containsLatinLetter, (String)"<this>");
        CharSequence charSequence = $this$containsLatinLetter;
        return new Regex(".*[A-Za-z].*").matches(charSequence);
    }

    public static final boolean getContainsDigit(@NotNull String $this$containsDigit) {
        Intrinsics.checkNotNullParameter((Object)$this$containsDigit, (String)"<this>");
        CharSequence charSequence = $this$containsDigit;
        return new Regex(".*[0-9].*").matches(charSequence);
    }

    public static final boolean isAlphanumeric(@NotNull String $this$isAlphanumeric) {
        Intrinsics.checkNotNullParameter((Object)$this$isAlphanumeric, (String)"<this>");
        CharSequence charSequence = $this$isAlphanumeric;
        return new Regex("[A-Za-z0-9]*").matches(charSequence);
    }

    public static final boolean getHasLettersAndDigits(@NotNull String $this$hasLettersAndDigits) {
        Intrinsics.checkNotNullParameter((Object)$this$hasLettersAndDigits, (String)"<this>");
        return ExtensionsUtilsKt.getContainsLatinLetter($this$hasLettersAndDigits) && ExtensionsUtilsKt.getContainsDigit($this$hasLettersAndDigits);
    }

    public static final boolean isIntegerNumber(@NotNull String $this$isIntegerNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isIntegerNumber, (String)"<this>");
        return StringsKt.toIntOrNull((String)$this$isIntegerNumber) != null;
    }

    public static final boolean getToDecimalNumber(@NotNull String $this$toDecimalNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$toDecimalNumber, (String)"<this>");
        return StringsKt.toDoubleOrNull((String)$this$toDecimalNumber) != null;
    }

    public static final boolean isNull(@Nullable Object $this$isNull) {
        boolean bl;
        Object object = $this$isNull;
        if (Intrinsics.areEqual((Object)object, (Object)($this$isNull == null ? 1 : 0))) {
            bl = true;
        } else {
            Object object2 = object;
            if (object2 == null ? true : object2 instanceof Collection) {
                int n;
                Object object3 = $this$isNull;
                bl = (object3 == null ? 0 : (n = ((Collection)object3).size())) == 0;
            } else {
                Object object4 = object;
                if (object4 == null ? true : object4 instanceof String) {
                    CharSequence charSequence;
                    Object object5 = $this$isNull;
                    bl = (object5 == null ? false : ((String)object5).length() == 0) || (charSequence = (CharSequence)$this$isNull) == null || StringsKt.isBlank((CharSequence)charSequence);
                } else {
                    Object object6 = object;
                    bl = (object6 == null ? true : object6 instanceof Long) ? Intrinsics.areEqual((Object)$this$isNull, (Object)0L) : $this$isNull == null;
                }
            }
        }
        return bl;
    }

    public static final boolean isNotNull(@Nullable Object $this$isNotNull) {
        return !ExtensionsUtilsKt.isNull($this$isNotNull);
    }

    @NotNull
    public static final String getLastPathComponent(@NotNull String $this$lastPathComponent) {
        int index;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$lastPathComponent, (String)"<this>");
        String path = $this$lastPathComponent;
        if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            string2 = path.substring(0, path.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            path = string2;
        }
        if ((index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null)) < 0) {
            if (StringsKt.endsWith$default((String)path, (String)"\\", (boolean)false, (int)2, null)) {
                String string3 = path.substring(0, path.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                path = string3;
            }
            if ((index = StringsKt.lastIndexOf$default((CharSequence)path, (char)'\\', (int)0, (boolean)false, (int)6, null)) < 0) {
                return path;
            }
        }
        string2 = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        return string2;
    }

    @Nullable
    public static final Integer getAsColor(@NotNull String $this$asColor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$asColor, (String)"<this>");
        try {
            n = Color.parseColor((String)$this$asColor);
        }
        catch (IllegalArgumentException e) {
            n = null;
        }
        return n;
    }

    public static final boolean isResource(@Nullable Context context, int resId) {
        if (context != null) {
            try {
                return context.getResources().getResourceName(resId) != null;
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public static final int getThemeColor(int resId) {
        return ExtensionsUtilsKt.isResource((Context)Utils.getApp(), resId) ? ContextCompat.getColor((Context)((Context)Utils.getApp()), (int)resId) : resId;
    }

    @NotNull
    public static final String getCreditCardFormatted(@NotNull String $this$creditCardFormatted) {
        Intrinsics.checkNotNullParameter((Object)$this$creditCardFormatted, (String)"<this>");
        String preparedString = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)$this$creditCardFormatted, (String)" ", (String)"", (boolean)false, (int)4, null))).toString();
        StringBuilder result = new StringBuilder();
        int n = 0;
        int n2 = preparedString.length();
        while (n < n2) {
            int i;
            if ((i = n++) % 4 == 0 && i != 0) {
                result.append(" ");
            }
            result.append(preparedString.charAt(i));
        }
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeBitmap(File $this$writeBitmap, Bitmap bitmap, Bitmap.CompressFormat format, int quality) {
        Closeable closeable = new FileOutputStream($this$writeBitmap);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            bitmap.compress(format, quality, (OutputStream)out);
            out.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean isServiceRunning(@NotNull Context $this$isServiceRunning, @NotNull Class<?> serviceClass) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$isServiceRunning, (String)"<this>");
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Object object = $this$isServiceRunning.getSystemService("activity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.ActivityManager");
            }
            ActivityManager manager = (ActivityManager)object;
            List list = manager.getRunningServices(Integer.MAX_VALUE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manager.getRunningServices(Integer.MAX_VALUE)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityManager.RunningServiceInfo it = (ActivityManager.RunningServiceInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.service.getClassName(), (Object)serviceClass.getName())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final <T> Function1<T, Unit> debounce(long delayMillis, @NotNull CoroutineScope scope, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Ref.ObjectRef debounceJob = new Ref.ObjectRef();
        return new Function1<T, Unit>((Ref.ObjectRef<Job>)debounceJob, scope, action, delayMillis){
            final /* synthetic */ Ref.ObjectRef<Job> $debounceJob;
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ Function1<T, Unit> $action;
            final /* synthetic */ long $delayMillis;
            {
                this.$debounceJob = $debounceJob;
                this.$scope = $scope;
                this.$action = $action;
                this.$delayMillis = $delayMillis;
                super(1);
            }

            public final void invoke(T param) {
                if (this.$debounceJob.element == null) {
                    this.$debounceJob.element = BuildersKt.launch$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$action, param, this.$delayMillis, this.$debounceJob, null){
                        int label;
                        final /* synthetic */ Function1<T, Unit> $action;
                        final /* synthetic */ T $param;
                        final /* synthetic */ long $delayMillis;
                        final /* synthetic */ Ref.ObjectRef<Job> $debounceJob;
                        {
                            this.$action = $action;
                            this.$param = $param;
                            this.$delayMillis = $delayMillis;
                            this.$debounceJob = $debounceJob;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object var1_1) {
                            var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    this.$action.invoke(this.$param);
                                    this.label = 1;
                                    v0 = DelayKt.delay((long)this.$delayMillis, (Continuation)((Continuation)this));
                                    if (v0 == var2_2) {
                                        return var2_2;
                                    }
                                    ** GOTO lbl15
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl15:
                                    // 2 sources

                                    this.$debounceJob.element = null;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        @Nullable
                        public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
        };
    }

    public static /* synthetic */ Function1 debounce$default(long l, CoroutineScope coroutineScope, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            l = 500L;
        }
        return ExtensionsUtilsKt.debounce(l, coroutineScope, function1);
    }
}

