/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.network.logging;

import android.util.Log;
import com.netacom.base.chat.network.logging.BufferListener;
import com.netacom.base.chat.network.logging.Level;
import com.netacom.base.chat.network.logging.Logger;
import com.netacom.base.chat.network.logging.Printer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Connection;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001#B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002JF\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0018\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0002JV\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u00062\b\u0010\"\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/netacom/base/chat/network/logging/LoggingInterceptor;", "Lokhttp3/Interceptor;", "builder", "Lcom/netacom/base/chat/network/logging/LoggingInterceptor$Builder;", "(Lcom/netacom/base/chat/network/logging/LoggingInterceptor$Builder;)V", "isDebug", "", "utf8", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "createFileRequestRunnable", "Ljava/lang/Runnable;", "request", "Lokhttp3/Request;", "createFileResponseRunnable", "chainMs", "", "isSuccessful", "code", "", "headers", "", "segments", "", "message", "createPrintJsonRequestRunnable", "createPrintJsonResponseRunnable", "bodyString", "responseUrl", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isNotFileRequest", "subtype", "Builder", "netacom-base-chat_NetAloDevRelease"})
public final class LoggingInterceptor
implements Interceptor {
    @NotNull
    private final Builder builder;
    private final boolean isDebug;
    private final Charset utf8;

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.utf8 = Charset.forName("UTF-8");
        this.isDebug = this.builder.isDebug$netacom_base_chat_NetAloDevRelease();
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException, Exception {
        ResponseBody responseBody;
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        Connection connection2 = connection = chain.connection();
        Object object = connection2 == null ? null : connection2.protocol();
        if (object == null) {
            object = Protocol.HTTP_1_1;
        }
        Protocol protocol = object;
        Request requestBuilder = request.newBuilder().build();
        Buffer bufferRequest = new Buffer();
        RequestBody requestBody = requestBuilder.body();
        if (requestBody != null) {
            requestBody.writeTo((BufferedSink)bufferRequest);
        }
        String requestStartMessage = null;
        requestStartMessage = "--> " + request.method() + ' ' + request.url() + ' ' + protocol;
        RequestBody requestBody2 = request.body();
        if (requestBody2 != null) {
            RequestBody it = requestBody2;
            boolean bl = false;
            String string2 = "%s\nContent-Header:: \n%sContent-Type:: %s\nContent-Length:: %s\nContent-Body:: %s";
            Object[] objectArray = new Object[]{requestStartMessage, request.headers().toString(), it.contentType(), it.contentLength(), bufferRequest.readUtf8()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            requestStartMessage = string3;
        }
        Log.i((String)"INFO", (String)requestStartMessage);
        long startNs = System.nanoTime();
        Response response = chain.proceed(request);
        long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        ResponseBody responseBody2 = responseBody = response.body();
        if (responseBody2 != null) {
            ResponseBody it = responseBody2;
            boolean bl = false;
            long contentLength = responseBody.contentLength();
            String bodySize = contentLength != -1L ? contentLength + "-byte" : "unknown-length";
            Log.i((String)"INFO", (String)response.headers().toString());
            Log.i((String)"INFO", (String)("<-- " + response.code() + ' ' + response.message() + ' ' + response.request().url() + " (" + tookMs + "ms, " + bodySize + ')'));
            BufferedSource source = responseBody.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.getBuffer();
            Charset charset = null;
            Charset charset2 = this.utf8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"utf8");
            charset = charset2;
            MediaType mediaType = responseBody.contentType();
            if (mediaType != null) {
                MediaType it2 = mediaType;
                boolean bl2 = false;
                try {
                    Charset charset3 = it2.charset(this.utf8);
                    Intrinsics.checkNotNull((Object)charset3);
                    charset = charset3;
                    Unit unit = Unit.INSTANCE;
                }
                catch (Exception e) {
                    Log.i((String)"INFO", (String)"");
                    Log.i((String)"INFO", (String)"Couldn't decode the response body; charset is likely malformed.");
                    Log.i((String)"INFO", (String)String.valueOf(e.getMessage()));
                    Integer n = Log.i((String)"INFO", (String)"<-- END HTTP");
                }
            }
            if (contentLength != 0L) {
                Log.i((String)"INFO", (String)"");
                Log.i((String)"INFO", (String)buffer.clone().readString(charset));
            }
            Log.i((String)"INFO", (String)("<-- END HTTP (" + buffer.size() + "-byte body)"));
        }
        return response;
    }

    private final boolean isNotFileRequest(String subtype) {
        return subtype != null && (StringsKt.contains$default((CharSequence)subtype, (CharSequence)"json", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"xml", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"plain", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)subtype, (CharSequence)"html", (boolean)false, (int)2, null));
    }

    private final Runnable createPrintJsonRequestRunnable(Builder builder, Request request) {
        return () -> LoggingInterceptor.createPrintJsonRequestRunnable$lambda-3(builder, request);
    }

    private final Runnable createFileRequestRunnable(Builder builder, Request request) {
        return () -> LoggingInterceptor.createFileRequestRunnable$lambda-4(builder, request);
    }

    private final Runnable createPrintJsonResponseRunnable(Builder builder, long chainMs, boolean isSuccessful, int code, String headers, String bodyString, List<String> segments, String message, String responseUrl) {
        return () -> LoggingInterceptor.createPrintJsonResponseRunnable$lambda-5(builder, chainMs, isSuccessful, code, headers, bodyString, segments, message, responseUrl);
    }

    private final Runnable createFileResponseRunnable(Builder builder, long chainMs, boolean isSuccessful, int code, String headers, List<String> segments, String message) {
        return () -> LoggingInterceptor.createFileResponseRunnable$lambda-6(builder, chainMs, isSuccessful, code, headers, segments, message);
    }

    private static final void createPrintJsonRequestRunnable$lambda-3(Builder $builder, Request $request) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Printer.Companion.printJsonRequest($builder, $request);
    }

    private static final void createFileRequestRunnable$lambda-4(Builder $builder, Request $request) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Printer.Companion.printFileRequest($builder, $request);
    }

    private static final void createPrintJsonResponseRunnable$lambda-5(Builder $builder, long $chainMs, boolean $isSuccessful, int $code, String $headers, String $bodyString, List $segments, String $message, String $responseUrl) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)$bodyString, (String)"$bodyString");
        Intrinsics.checkNotNullParameter((Object)$segments, (String)"$segments");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$responseUrl, (String)"$responseUrl");
        Printer.Companion.printJsonResponse($builder, $chainMs, $isSuccessful, $code, $headers, $bodyString, $segments, $message, $responseUrl);
    }

    private static final void createFileResponseRunnable$lambda-6(Builder $builder, long $chainMs, boolean $isSuccessful, int $code, String $headers, List $segments, String $message) {
        Intrinsics.checkNotNullParameter((Object)$builder, (String)"$builder");
        Intrinsics.checkNotNullParameter((Object)$headers, (String)"$headers");
        Intrinsics.checkNotNullParameter((Object)$segments, (String)"$segments");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Printer.Companion.printFileResponse($builder, $chainMs, $isSuccessful, $code, $headers, $segments, $message);
    }

    public /* synthetic */ LoggingInterceptor(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 O2\u00020\u0001:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u00109\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\u0016\u0010<\u001a\u00020\u00002\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0011J\u001e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u00112\u0006\u0010C\u001a\u0002002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\r\u0010D\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u00020\n2\u0006\u0010G\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bHJ\u000e\u0010I\u001a\u00020\u00002\u0006\u00106\u001a\u000205J\u000e\u0010J\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020#J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\nJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\nJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010L\u001a\u00020\nR\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R0\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR0\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0011@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0003\u001a\u0004\u0018\u00010#@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010)\"\u0004\b.\u0010+R\u001a\u0010/\u001a\u000200X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001e\u00106\u001a\u0002052\u0006\u0010\u0003\u001a\u000205@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006P"}, d2={"Lcom/netacom/base/chat/network/logging/LoggingInterceptor$Builder;", "", "()V", "<set-?>", "Ljava/util/concurrent/Executor;", "executor", "getExecutor$netacom_base_chat_NetAloDevRelease", "()Ljava/util/concurrent/Executor;", "headers", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getHeaders$netacom_base_chat_NetAloDevRelease", "()Ljava/util/HashMap;", "httpUrl", "getHttpUrl$netacom_base_chat_NetAloDevRelease", "isDebug", "", "isDebug$netacom_base_chat_NetAloDevRelease", "()Z", "setDebug$netacom_base_chat_NetAloDevRelease", "(Z)V", "isLogHackEnable", "isLogHackEnable$netacom_base_chat_NetAloDevRelease", "isMockEnabled", "isMockEnabled$netacom_base_chat_NetAloDevRelease", "setMockEnabled$netacom_base_chat_NetAloDevRelease", "level", "Lcom/netacom/base/chat/network/logging/Level;", "listener", "Lcom/netacom/base/chat/network/logging/BufferListener;", "getListener$netacom_base_chat_NetAloDevRelease", "()Lcom/netacom/base/chat/network/logging/BufferListener;", "setListener$netacom_base_chat_NetAloDevRelease", "(Lcom/netacom/base/chat/network/logging/BufferListener;)V", "Lcom/netacom/base/chat/network/logging/Logger;", "logger", "getLogger$netacom_base_chat_NetAloDevRelease", "()Lcom/netacom/base/chat/network/logging/Logger;", "requestTag", "getRequestTag$netacom_base_chat_NetAloDevRelease", "()Ljava/lang/String;", "setRequestTag$netacom_base_chat_NetAloDevRelease", "(Ljava/lang/String;)V", "responseTag", "getResponseTag$netacom_base_chat_NetAloDevRelease", "setResponseTag$netacom_base_chat_NetAloDevRelease", "sleepMs", "", "getSleepMs$netacom_base_chat_NetAloDevRelease", "()J", "setSleepMs$netacom_base_chat_NetAloDevRelease", "(J)V", "", "type", "getType$netacom_base_chat_NetAloDevRelease", "()I", "addHeader", "name", "value", "addQueryParam", "build", "Lcom/netacom/base/chat/network/logging/LoggingInterceptor;", "enableAndroidStudio_v3_LogsHack", "useHack", "enableMock", "useMock", "sleep", "getLevel", "getLevel$netacom_base_chat_NetAloDevRelease", "getTag", "isRequest", "getTag$netacom_base_chat_NetAloDevRelease", "log", "loggable", "request", "tag", "response", "setLevel", "Companion", "netacom-base-chat_NetAloDevRelease"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final HashMap<String, String> headers = new HashMap();
        @NotNull
        private final HashMap<String, String> httpUrl;
        private boolean isLogHackEnable;
        private boolean isDebug;
        private int type = 4;
        @NotNull
        private String requestTag = "";
        @NotNull
        private String responseTag = "";
        @NotNull
        private Level level = Level.BASIC;
        @Nullable
        private Logger logger;
        @Nullable
        private Executor executor;
        private boolean isMockEnabled;
        private long sleepMs;
        @Nullable
        private BufferListener listener;
        @NotNull
        private static String TAG = "Netalo";

        public Builder() {
            this.httpUrl = new HashMap();
        }

        @NotNull
        public final HashMap<String, String> getHeaders$netacom_base_chat_NetAloDevRelease() {
            return this.headers;
        }

        @NotNull
        public final HashMap<String, String> getHttpUrl$netacom_base_chat_NetAloDevRelease() {
            return this.httpUrl;
        }

        public final boolean isLogHackEnable$netacom_base_chat_NetAloDevRelease() {
            return this.isLogHackEnable;
        }

        public final boolean isDebug$netacom_base_chat_NetAloDevRelease() {
            return this.isDebug;
        }

        public final void setDebug$netacom_base_chat_NetAloDevRelease(boolean bl) {
            this.isDebug = bl;
        }

        public final int getType$netacom_base_chat_NetAloDevRelease() {
            return this.type;
        }

        @NotNull
        public final String getRequestTag$netacom_base_chat_NetAloDevRelease() {
            return this.requestTag;
        }

        public final void setRequestTag$netacom_base_chat_NetAloDevRelease(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.requestTag = string2;
        }

        @NotNull
        public final String getResponseTag$netacom_base_chat_NetAloDevRelease() {
            return this.responseTag;
        }

        public final void setResponseTag$netacom_base_chat_NetAloDevRelease(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            this.responseTag = string2;
        }

        @Nullable
        public final Logger getLogger$netacom_base_chat_NetAloDevRelease() {
            return this.logger;
        }

        @Nullable
        public final Executor getExecutor$netacom_base_chat_NetAloDevRelease() {
            return this.executor;
        }

        public final boolean isMockEnabled$netacom_base_chat_NetAloDevRelease() {
            return this.isMockEnabled;
        }

        public final void setMockEnabled$netacom_base_chat_NetAloDevRelease(boolean bl) {
            this.isMockEnabled = bl;
        }

        public final long getSleepMs$netacom_base_chat_NetAloDevRelease() {
            return this.sleepMs;
        }

        public final void setSleepMs$netacom_base_chat_NetAloDevRelease(long l) {
            this.sleepMs = l;
        }

        @Nullable
        public final BufferListener getListener$netacom_base_chat_NetAloDevRelease() {
            return this.listener;
        }

        public final void setListener$netacom_base_chat_NetAloDevRelease(@Nullable BufferListener bufferListener) {
            this.listener = bufferListener;
        }

        @NotNull
        public final Level getLevel$netacom_base_chat_NetAloDevRelease() {
            return this.level;
        }

        @NotNull
        public final Builder setLevel(@NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            this.level = level;
            return this;
        }

        @NotNull
        public final String getTag$netacom_base_chat_NetAloDevRelease(boolean isRequest) {
            return isRequest ? (((CharSequence)this.requestTag).length() == 0 ? TAG : this.requestTag) : (((CharSequence)this.responseTag).length() == 0 ? TAG : this.responseTag);
        }

        @NotNull
        public final Builder addHeader(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ((Map)this.headers).put(name, value);
            return this;
        }

        @NotNull
        public final Builder addQueryParam(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ((Map)this.httpUrl).put(name, value);
            return this;
        }

        @NotNull
        public final Builder tag(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            TAG = tag;
            return this;
        }

        @NotNull
        public final Builder request(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.requestTag = tag;
            return this;
        }

        @NotNull
        public final Builder response(@NotNull String tag) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.responseTag = tag;
            return this;
        }

        @NotNull
        public final Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        @NotNull
        public final Builder log(int type) {
            this.type = type;
            return this;
        }

        @NotNull
        public final Builder logger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
            return this;
        }

        @NotNull
        public final Builder executor(@NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            this.executor = executor;
            return this;
        }

        @NotNull
        public final Builder enableMock(boolean useMock, long sleep, @NotNull BufferListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.isMockEnabled = useMock;
            this.sleepMs = sleep;
            this.listener = listener;
            return this;
        }

        @NotNull
        public final Builder enableAndroidStudio_v3_LogsHack(boolean useHack) {
            this.isLogHackEnable = useHack;
            return this;
        }

        @NotNull
        public final LoggingInterceptor build() {
            return new LoggingInterceptor(this, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/netacom/base/chat/network/logging/LoggingInterceptor$Builder$Companion;", "", "()V", "TAG", "", "netacom-base-chat_NetAloDevRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

