/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import com.netacom.base.chat.logger.LogStrategy;
import com.netacom.base.chat.logger.Utils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0011\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/orhanobut/logger/DiskLogStrategy;", "Lcom/netacom/base/chat/logger/LogStrategy;", "handler", "Landroid/os/Handler;", "(Landroid/os/Handler;)V", "log", "", "level", "", "tag", "", "message", "WriteHandler", "netacom-base-chat_NetAloDevRelease"})
public final class DiskLogStrategy
implements LogStrategy {
    @NonNull
    @NotNull
    private final Handler handler;

    public DiskLogStrategy(@NonNull @Nullable Handler handler) {
        this.handler = Utils.INSTANCE.checkNotNull(handler);
    }

    @Override
    public void log(int level, @androidx.annotation.Nullable @Nullable String tag, @NonNull @Nullable String message) {
        Utils.INSTANCE.checkNotNull(message);
        this.handler.sendMessage(this.handler.obtainMessage(level, (Object)message));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\f\u001a\u00020\u0005H\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u000e2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/orhanobut/logger/DiskLogStrategy$WriteHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "folder", "", "maxFileSize", "", "(Landroid/os/Looper;Ljava/lang/String;I)V", "getLogFile", "Ljava/io/File;", "folderName", "fileName", "handleMessage", "", "msg", "Landroid/os/Message;", "writeLog", "fileWriter", "Ljava/io/FileWriter;", "content", "netacom-base-chat_NetAloDevRelease"})
    public static final class WriteHandler
    extends Handler {
        @NonNull
        @NotNull
        private final String folder;
        private final int maxFileSize;

        public WriteHandler(@NonNull @Nullable Looper looper, @NonNull @Nullable String folder, int maxFileSize) {
            super(Utils.INSTANCE.checkNotNull(looper));
            this.folder = Utils.INSTANCE.checkNotNull(folder);
            this.maxFileSize = maxFileSize;
        }

        public void handleMessage(@NonNull @NotNull Message msg) {
            block5: {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                Object object = msg.obj;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String content = (String)object;
                FileWriter fileWriter = null;
                File logFile = this.getLogFile(this.folder, "logs");
                try {
                    fileWriter = new FileWriter(logFile, true);
                    this.writeLog(fileWriter, content);
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (IOException e) {
                    if (fileWriter == null) break block5;
                    try {
                        fileWriter.flush();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        private final void writeLog(@NonNull FileWriter fileWriter, @NonNull String content) throws IOException {
            Utils.INSTANCE.checkNotNull(fileWriter);
            Utils.INSTANCE.checkNotNull(content);
            fileWriter.append(content);
        }

        private final File getLogFile(@NonNull String folderName, @NonNull String fileName) {
            Utils.INSTANCE.checkNotNull(folderName);
            Utils.INSTANCE.checkNotNull(fileName);
            File folder = new File(folderName);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            int newFileCount = 0;
            File newFile = null;
            File existingFile = null;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "%s_%s.csv";
            Object[] objectArray = new Object[]{fileName, newFileCount};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
            newFile = new File(folder, string3);
            while (newFile.exists()) {
                existingFile = newFile;
                int n = newFileCount;
                newFileCount = n + 1;
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = "%s_%s.csv";
                objectArray = new Object[]{fileName, newFileCount};
                bl = false;
                String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                newFile = new File(folder, string4);
            }
            return existingFile != null ? (existingFile.length() >= (long)this.maxFileSize ? newFile : existingFile) : newFile;
        }
    }
}

