/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import android.util.Patterns;
import com.netacom.base.chat.R;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.type.ValidationResult;
import com.netacom.base.chat.type.ValidationType;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/netacom/base/chat/util/ValidationUtil;", "", "()V", "Companion", "netacom-base-chat_NetAloDevRelease"})
public final class ValidationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final String getMessageRes(@NotNull ValidationType validationType, @NotNull ValidationResult validation) {
        return Companion.getMessageRes(validationType, validation);
    }

    @JvmStatic
    public static final boolean isValid(@NotNull ValidationResult result) {
        return Companion.isValid(result);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateEmail(@Nullable String email) {
        return Companion.validateEmail(email);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateOrg(@Nullable String org) {
        return Companion.validateOrg(org);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateName(@Nullable String name) {
        return Companion.validateName(name);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateUserName(@Nullable String name) {
        return Companion.validateUserName(name);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePhone(@Nullable String phone) {
        return Companion.validatePhone(phone);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePassword(@Nullable String password) {
        return Companion.validatePassword(password);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePasswordNormal(@Nullable String password) {
        return Companion.validatePasswordNormal(password);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateConfirmPassword(@Nullable String password, @Nullable String confirmPassword) {
        return Companion.validateConfirmPassword(password, confirmPassword);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateOTP(@Nullable String otp) {
        return Companion.validateOTP(otp);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateIMEI(@Nullable String imei) {
        return Companion.validateIMEI(imei);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateIdCardNumber(@Nullable String id2) {
        return Companion.validateIdCardNumber(id2);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePassport(@Nullable String passport) {
        return Companion.validatePassport(passport);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0018\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\"\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010#\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010$\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010&\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006'"}, d2={"Lcom/netacom/base/chat/util/ValidationUtil$Companion;", "", "()V", "getMessageRes", "", "validationType", "Lcom/netacom/base/chat/type/ValidationType;", "validation", "Lcom/netacom/base/chat/type/ValidationResult;", "isValid", "", "result", "isValidIMEI", "imeiStr", "sumDig", "", "num", "validateConfirmPassword", "password", "confirmPassword", "validateEmail", "email", "validateIMEI", "imei", "validateIdCardNumber", "id", "validateName", "name", "validateOTP", "otp", "validateOrg", "org", "validatePassport", "passport", "validatePassword", "validatePasswordNormal", "validatePhone", "phone", "validateUserName", "netacom-base-chat_NetAloDevRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getMessageRes(@NotNull ValidationType validationType, @NotNull ValidationResult validation) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)validationType), (String)"validationType");
            Intrinsics.checkNotNullParameter((Object)((Object)validation), (String)"validation");
            ValidationType validationType2 = validationType;
            int n2 = WhenMappings.$EnumSwitchMapping$0[validationType2.ordinal()];
            block0 : switch (n2) {
                case 1: {
                    ValidationResult validationResult = validation;
                    int n3 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n3) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_email_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_email_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_email_wrong_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_email_existed_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_email_email_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 2: {
                    ValidationResult validationResult = validation;
                    int n4 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n4) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_phone_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_phone_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_phone_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_phone_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_phone_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 3: {
                    ValidationResult validationResult = validation;
                    int n5 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n5) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_name_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_name_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_name_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_name_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_name_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 4: {
                    ValidationResult validationResult = validation;
                    int n6 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n6) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_name_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_name_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_name_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_name_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_name_existed_msg;
                            break block0;
                        }
                        case 7: {
                            n = R.string.validate_name_invalid_length_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 5: {
                    ValidationResult validationResult = validation;
                    int n7 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n7) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_code_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_code_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_code_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_code_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_code_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 6: {
                    ValidationResult validationResult = validation;
                    int n8 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n8) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_confirm_password_empty_msg;
                            break block0;
                        }
                        case 8: {
                            n = R.string.validate_confirm_password_not_match_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 7: {
                    ValidationResult validationResult = validation;
                    int n9 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n9) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_password_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_password_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_password_wrong_msg;
                            break block0;
                        }
                        case 7: {
                            n = R.string.validate_password_invalid_length_msg;
                            break block0;
                        }
                        case 9: {
                            n = R.string.validate_password_invalid_digit_msg;
                            break block0;
                        }
                        case 10: {
                            n = R.string.validate_password_invalid_special_character_msg;
                            break block0;
                        }
                        case 11: {
                            n = R.string.validate_password_invalid_lower_case_msg;
                            break block0;
                        }
                        case 12: {
                            n = R.string.validate_password_invalid_upper_case_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 8: {
                    ValidationResult validationResult = validation;
                    int n10 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n10) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_imei_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_imei_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_imei_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_imei_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 9: {
                    ValidationResult validationResult = validation;
                    int n11 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n11) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_id_card_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_id_card_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_id_card_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_id_card_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 10: {
                    ValidationResult validationResult = validation;
                    int n12 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n12) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_passport_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_passport_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_passport_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_passport_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 11: {
                    ValidationResult validationResult = validation;
                    int n13 = WhenMappings.$EnumSwitchMapping$1[validationResult.ordinal()];
                    switch (n13) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_confirm_org_empty_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_confirm_org_wrong_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                default: {
                    n = R.string.validate_valid;
                }
            }
            return StringUtils.INSTANCE.getString(n);
        }

        @JvmStatic
        public final boolean isValid(@NotNull ValidationResult result) {
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            return result == ValidationResult.VALID;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateEmail(@Nullable String email) {
            CharSequence charSequence = email;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (Patterns.EMAIL_ADDRESS.matcher(email).matches() ? ValidationResult.VALID : ValidationResult.INVALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateOrg(@Nullable String org) {
            CharSequence charSequence = org;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : ValidationResult.VALID;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateName(@Nullable String name) {
            CharSequence charSequence = name;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (!Pattern.matches("^[\\p{L} .'-]+$", name) ? ValidationResult.INVALID : ValidationResult.VALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateUserName(@Nullable String name) {
            CharSequence charSequence = name;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (name.length() < 3 ? ValidationResult.INVALID_LENGTH : (Pattern.matches("[a-zA-Z0-9_]+", name) ? ValidationResult.VALID : ValidationResult.INVALID));
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final ValidationResult validatePhone(@Nullable String phone) {
            ValidationResult validationResult;
            CharSequence charSequence = phone;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
                return validationResult;
            }
            if (Patterns.PHONE.matcher(phone).matches()) {
                int n = phone.length();
                boolean bl3 = 8 <= n ? n <= 15 : false;
                if (bl3) {
                    validationResult = ValidationResult.VALID;
                    return validationResult;
                }
            }
            validationResult = ValidationResult.INVALID;
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePassword(@Nullable String password) {
            ValidationResult validationResult;
            CharSequence charSequence = password;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
            } else if (password.length() < 6) {
                validationResult = ValidationResult.INVALID_LENGTH;
            } else {
                charSequence = password;
                bl = false;
                CharSequence charSequence2 = charSequence;
                if (charSequence2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = ((String)charSequence2).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                if (Intrinsics.areEqual((Object)password, (Object)string2)) {
                    validationResult = ValidationResult.MISSING_UPPER_CASE_CHARACTER;
                } else {
                    charSequence = password;
                    bl = false;
                    CharSequence charSequence3 = charSequence;
                    if (charSequence3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = ((String)charSequence3).toUpperCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                    validationResult = Intrinsics.areEqual((Object)password, (Object)string3) ? ValidationResult.MISSING_LOWER_CASE_CHARACTER : (!Pattern.compile(".*\\d+.*").matcher(password).matches() ? ValidationResult.MISSING_DIGIT : ValidationResult.VALID);
                }
            }
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePasswordNormal(@Nullable String password) {
            CharSequence charSequence = password;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (password.length() < 6 ? ValidationResult.INVALID_LENGTH : ValidationResult.VALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateConfirmPassword(@Nullable String password, @Nullable String confirmPassword) {
            CharSequence charSequence = confirmPassword;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (Intrinsics.areEqual((Object)confirmPassword, (Object)password) ? ValidationResult.VALID : ValidationResult.NOT_MATCH);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final ValidationResult validateOTP(@Nullable String otp) {
            ValidationResult validationResult;
            CharSequence charSequence = otp;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
                return validationResult;
            }
            if (otp.length() == 6) {
                charSequence = otp;
                String string2 = "\\d+";
                bl2 = false;
                string2 = new Regex(string2);
                bl2 = false;
                if (string2.matches(charSequence)) {
                    validationResult = ValidationResult.VALID;
                    return validationResult;
                }
            }
            validationResult = ValidationResult.INVALID;
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateIMEI(@Nullable String imei) {
            CharSequence charSequence = imei;
            boolean bl = false;
            boolean bl2 = false;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (imei.length() > 20 ? ValidationResult.INVALID_LENGTH : ValidationResult.VALID);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final ValidationResult validateIdCardNumber(@Nullable String id2) {
            ValidationResult validationResult;
            CharSequence charSequence = id2;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
                return validationResult;
            }
            if (id2.length() == 9 || id2.length() == 12) {
                charSequence = id2;
                String string2 = "\\d+";
                bl2 = false;
                string2 = new Regex(string2);
                bl2 = false;
                if (string2.matches(charSequence)) {
                    validationResult = ValidationResult.VALID;
                    return validationResult;
                }
            }
            validationResult = ValidationResult.INVALID;
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePassport(@Nullable String passport) {
            ValidationResult validationResult;
            CharSequence charSequence = passport;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
            } else if (passport.length() < 6 || passport.length() > 20) {
                validationResult = ValidationResult.INVALID;
            } else {
                charSequence = passport;
                String string2 = "[a-zA-Z0-9]+";
                bl2 = false;
                string2 = new Regex(string2);
                bl2 = false;
                validationResult = !string2.matches(charSequence) ? ValidationResult.INVALID : ValidationResult.VALID;
            }
            return validationResult;
        }

        private final boolean isValidIMEI(String imeiStr) {
            if (!Pattern.compile("\\d+").matcher(imeiStr).matches() || imeiStr.length() != 15) {
                return false;
            }
            String string2 = imeiStr;
            boolean bl = false;
            long imeiNumber = Long.parseLong(string2);
            int d = 0;
            int sum = 0;
            int n = 15;
            do {
                int i = n--;
                d = (int)(imeiNumber % (long)10);
                if (i % 2 == 0) {
                    d *= 2;
                }
                sum += this.sumDig(d);
                imeiNumber /= (long)10;
            } while (1 <= n);
            return sum % 10 == 0 && sum != 0;
        }

        private final int sumDig(int num) {
            int a = 0;
            for (int n = num; n > 0; n /= 10) {
                a += n % 10;
            }
            return a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[ValidationType.values().length];
                nArray[ValidationType.EMAIL.ordinal()] = 1;
                nArray[ValidationType.PHONE_NUMBER.ordinal()] = 2;
                nArray[ValidationType.FULL_NAME.ordinal()] = 3;
                nArray[ValidationType.USER_NAME.ordinal()] = 4;
                nArray[ValidationType.OTP.ordinal()] = 5;
                nArray[ValidationType.CONFIRM_PASSWORD.ordinal()] = 6;
                nArray[ValidationType.PASSWORD.ordinal()] = 7;
                nArray[ValidationType.IMEI.ordinal()] = 8;
                nArray[ValidationType.ID_CARD_NUMBER.ordinal()] = 9;
                nArray[ValidationType.PASSPORT_NUMBER.ordinal()] = 10;
                nArray[ValidationType.ORGANIZATION_CODE.ordinal()] = 11;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ValidationResult.values().length];
                nArray[ValidationResult.VALID.ordinal()] = 1;
                nArray[ValidationResult.INVALID.ordinal()] = 2;
                nArray[ValidationResult.EMPTY.ordinal()] = 3;
                nArray[ValidationResult.WRONG.ordinal()] = 4;
                nArray[ValidationResult.EXISTED.ordinal()] = 5;
                nArray[ValidationResult.NOT_EXIST.ordinal()] = 6;
                nArray[ValidationResult.INVALID_LENGTH.ordinal()] = 7;
                nArray[ValidationResult.NOT_MATCH.ordinal()] = 8;
                nArray[ValidationResult.MISSING_DIGIT.ordinal()] = 9;
                nArray[ValidationResult.MISSING_SPECIAL_CHARACTER.ordinal()] = 10;
                nArray[ValidationResult.MISSING_LOWER_CASE_CHARACTER.ordinal()] = 11;
                nArray[ValidationResult.MISSING_UPPER_CASE_CHARACTER.ordinal()] = 12;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

