/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class TimeUtils {
    private static final ThreadLocal<Map<String, SimpleDateFormat>> SDF_THREAD_LOCAL = new ThreadLocal<Map<String, SimpleDateFormat>>(){

        @Override
        protected Map<String, SimpleDateFormat> initialValue() {
            return new HashMap<String, SimpleDateFormat>();
        }
    };
    private static final String[] CHINESE_ZODIAC = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final int[] ZODIAC_FLAGS = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 24, 23, 22};
    private static final String[] ZODIAC = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u6469\u7faf\u5ea7"};

    private static SimpleDateFormat getDefaultFormat() {
        return TimeUtils.getSafeDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static SimpleDateFormat getSafeDateFormat(String pattern) {
        Map<String, SimpleDateFormat> sdfMap = SDF_THREAD_LOCAL.get();
        SimpleDateFormat simpleDateFormat = sdfMap.get(pattern);
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat(pattern);
            sdfMap.put(pattern, simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private TimeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String millis2String(long millis) {
        long hour = millis / 3600000L;
        if (hour > 0L) {
            return TimeUtils.millis2String(millis, "hh:mm");
        }
        return TimeUtils.millis2String(millis, "mm:ss");
    }

    public static String second2String(long second) {
        long millis = second * 1000L;
        return TimeUtils.millis2String(millis);
    }

    public static String millis2String(long millis, @NonNull String pattern) {
        return TimeUtils.millis2String(millis, TimeUtils.getSafeDateFormat(pattern));
    }

    public static String millis2String(long millis, @NonNull DateFormat format) {
        return format.format(new Date(millis));
    }

    public static long string2Millis(String time) {
        return TimeUtils.string2Millis(time, TimeUtils.getDefaultFormat());
    }

    public static long string2Millis(String time, @NonNull String pattern) {
        return TimeUtils.string2Millis(time, TimeUtils.getSafeDateFormat(pattern));
    }

    public static long string2Millis(String time, @NonNull DateFormat format) {
        try {
            return format.parse(time).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public static Date string2Date(String time) {
        return TimeUtils.string2Date(time, TimeUtils.getDefaultFormat());
    }

    public static Date string2Date(String time, @NonNull String pattern) {
        return TimeUtils.string2Date(time, TimeUtils.getSafeDateFormat(pattern));
    }

    public static Date string2Date(String time, @NonNull DateFormat format) {
        try {
            return format.parse(time);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String date2String(Date date) {
        return TimeUtils.date2String(date, TimeUtils.getDefaultFormat());
    }

    public static String date2String(Date date, @NonNull String pattern) {
        return TimeUtils.getSafeDateFormat(pattern).format(date);
    }

    public static String date2String(Date date, @NonNull DateFormat format) {
        return format.format(date);
    }

    public static long date2Millis(Date date) {
        return date.getTime();
    }

    public static Date millis2Date(long millis) {
        return new Date(millis);
    }

    public static long getTimeSpan(String time1, String time2, int unit) {
        return TimeUtils.getTimeSpan(time1, time2, TimeUtils.getDefaultFormat(), unit);
    }

    public static long getTimeSpan(String time1, String time2, @NonNull DateFormat format, int unit) {
        return TimeUtils.millis2TimeSpan(TimeUtils.string2Millis(time1, format) - TimeUtils.string2Millis(time2, format), unit);
    }

    public static long getTimeSpan(Date date1, Date date2, int unit) {
        return TimeUtils.millis2TimeSpan(TimeUtils.date2Millis(date1) - TimeUtils.date2Millis(date2), unit);
    }

    public static long getTimeSpan(long millis1, long millis2, int unit) {
        return TimeUtils.millis2TimeSpan(millis1 - millis2, unit);
    }

    public static String getFitTimeSpan(String time1, String time2, int precision) {
        long delta = TimeUtils.string2Millis(time1, TimeUtils.getDefaultFormat()) - TimeUtils.string2Millis(time2, TimeUtils.getDefaultFormat());
        return TimeUtils.millis2FitTimeSpan(delta, precision);
    }

    public static String getFitTimeSpan(String time1, String time2, @NonNull DateFormat format, int precision) {
        long delta = TimeUtils.string2Millis(time1, format) - TimeUtils.string2Millis(time2, format);
        return TimeUtils.millis2FitTimeSpan(delta, precision);
    }

    public static String getFitTimeSpan(Date date1, Date date2, int precision) {
        return TimeUtils.millis2FitTimeSpan(TimeUtils.date2Millis(date1) - TimeUtils.date2Millis(date2), precision);
    }

    public static String getFitTimeSpan(long millis1, long millis2, int precision) {
        return TimeUtils.millis2FitTimeSpan(millis1 - millis2, precision);
    }

    public static long getNowMills() {
        return System.currentTimeMillis();
    }

    public static String getNowString() {
        return TimeUtils.millis2String(System.currentTimeMillis(), TimeUtils.getDefaultFormat());
    }

    public static String getNowString(@NonNull DateFormat format) {
        return TimeUtils.millis2String(System.currentTimeMillis(), format);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static long getTimeSpanByNow(String time, int unit) {
        return TimeUtils.getTimeSpan(time, TimeUtils.getNowString(), TimeUtils.getDefaultFormat(), unit);
    }

    public static long getTimeSpanByNow(String time, @NonNull DateFormat format, int unit) {
        return TimeUtils.getTimeSpan(time, TimeUtils.getNowString(format), format, unit);
    }

    public static long getTimeSpanByNow(Date date, int unit) {
        return TimeUtils.getTimeSpan(date, new Date(), unit);
    }

    public static long getTimeSpanByNow(long millis, int unit) {
        return TimeUtils.getTimeSpan(millis, System.currentTimeMillis(), unit);
    }

    public static String getFitTimeSpanByNow(String time, int precision) {
        return TimeUtils.getFitTimeSpan(time, TimeUtils.getNowString(), TimeUtils.getDefaultFormat(), precision);
    }

    public static String getFitTimeSpanByNow(String time, @NonNull DateFormat format, int precision) {
        return TimeUtils.getFitTimeSpan(time, TimeUtils.getNowString(format), format, precision);
    }

    public static String getFitTimeSpanByNow(Date date, int precision) {
        return TimeUtils.getFitTimeSpan(date, TimeUtils.getNowDate(), precision);
    }

    public static String getFitTimeSpanByNow(long millis, int precision) {
        return TimeUtils.getFitTimeSpan(millis, System.currentTimeMillis(), precision);
    }

    public static String getFriendlyTimeSpanByNow(String time) {
        return TimeUtils.getFriendlyTimeSpanByNow(time, TimeUtils.getDefaultFormat());
    }

    public static String getFriendlyTimeSpanByNow(String time, @NonNull DateFormat format) {
        return TimeUtils.getFriendlyTimeSpanByNow(TimeUtils.string2Millis(time, format));
    }

    public static String getFriendlyTimeSpanByNow(Date date) {
        return TimeUtils.getFriendlyTimeSpanByNow(date.getTime());
    }

    public static String getFriendlyTimeSpanByNow(long millis) {
        long now = System.currentTimeMillis();
        long span = now - millis;
        if (span < 0L) {
            return String.format("%tc", millis);
        }
        if (span < 1000L) {
            return "\u521a\u521a";
        }
        if (span < 60000L) {
            return String.format(Locale.getDefault(), "%d\u79d2\u524d", span / 1000L);
        }
        if (span < 3600000L) {
            return String.format(Locale.getDefault(), "%d\u5206\u949f\u524d", span / 60000L);
        }
        long wee = TimeUtils.getWeeOfToday();
        if (millis >= wee) {
            return String.format("\u4eca\u5929%tR", millis);
        }
        if (millis >= wee - 86400000L) {
            return String.format("\u6628\u5929%tR", millis);
        }
        return String.format("%tF", millis);
    }

    private static long getWeeOfToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long getMillis(long millis, long timeSpan, int unit) {
        return millis + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static long getMillis(String time, long timeSpan, int unit) {
        return TimeUtils.getMillis(time, TimeUtils.getDefaultFormat(), timeSpan, unit);
    }

    public static long getMillis(String time, @NonNull DateFormat format, long timeSpan, int unit) {
        return TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static long getMillis(Date date, long timeSpan, int unit) {
        return TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit);
    }

    public static String getString(long millis, long timeSpan, int unit) {
        return TimeUtils.getString(millis, (DateFormat)TimeUtils.getDefaultFormat(), timeSpan, unit);
    }

    public static String getString(long millis, @NonNull DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(millis + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static String getString(String time, long timeSpan, int unit) {
        return TimeUtils.getString(time, (DateFormat)TimeUtils.getDefaultFormat(), timeSpan, unit);
    }

    public static String getString(String time, @NonNull DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static String getString(Date date, long timeSpan, int unit) {
        return TimeUtils.getString(date, (DateFormat)TimeUtils.getDefaultFormat(), timeSpan, unit);
    }

    public static String getString(Date date, @NonNull DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2String(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit), format);
    }

    public static Date getDate(long millis, long timeSpan, int unit) {
        return TimeUtils.millis2Date(millis + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static Date getDate(String time, long timeSpan, int unit) {
        return TimeUtils.getDate(time, TimeUtils.getDefaultFormat(), timeSpan, unit);
    }

    public static Date getDate(String time, @NonNull DateFormat format, long timeSpan, int unit) {
        return TimeUtils.millis2Date(TimeUtils.string2Millis(time, format) + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static Date getDate(Date date, long timeSpan, int unit) {
        return TimeUtils.millis2Date(TimeUtils.date2Millis(date) + TimeUtils.timeSpan2Millis(timeSpan, unit));
    }

    public static long getMillisByNow(long timeSpan, int unit) {
        return TimeUtils.getMillis(TimeUtils.getNowMills(), timeSpan, unit);
    }

    public static String getStringByNow(long timeSpan, int unit) {
        return TimeUtils.getStringByNow(timeSpan, TimeUtils.getDefaultFormat(), unit);
    }

    public static String getStringByNow(long timeSpan, @NonNull DateFormat format, int unit) {
        return TimeUtils.getString(TimeUtils.getNowMills(), format, timeSpan, unit);
    }

    public static Date getDateByNow(long timeSpan, int unit) {
        return TimeUtils.getDate(TimeUtils.getNowMills(), timeSpan, unit);
    }

    public static boolean isToday(String time) {
        return TimeUtils.isToday(TimeUtils.string2Millis(time, TimeUtils.getDefaultFormat()));
    }

    public static boolean isToday(String time, @NonNull DateFormat format) {
        return TimeUtils.isToday(TimeUtils.string2Millis(time, format));
    }

    public static boolean isToday(Date date) {
        return TimeUtils.isToday(date.getTime());
    }

    public static boolean isToday(long millis) {
        long wee = TimeUtils.getWeeOfToday();
        return millis >= wee && millis < wee + 86400000L;
    }

    public static boolean isLeapYear(String time) {
        return TimeUtils.isLeapYear(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()));
    }

    public static boolean isLeapYear(String time, @NonNull DateFormat format) {
        return TimeUtils.isLeapYear(TimeUtils.string2Date(time, format));
    }

    public static boolean isLeapYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = cal.get(1);
        return TimeUtils.isLeapYear(year);
    }

    public static boolean isLeapYear(long millis) {
        return TimeUtils.isLeapYear(TimeUtils.millis2Date(millis));
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static String getChineseWeek(String time) {
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()));
    }

    public static String getChineseWeek(String time, @NonNull DateFormat format) {
        return TimeUtils.getChineseWeek(TimeUtils.string2Date(time, format));
    }

    public static String getChineseWeek(Date date) {
        return new SimpleDateFormat("E", Locale.CHINA).format(date);
    }

    public static String getChineseWeek(long millis) {
        return TimeUtils.getChineseWeek(new Date(millis));
    }

    public static String getUSWeek(String time) {
        return TimeUtils.getUSWeek(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()));
    }

    public static String getUSWeek(String time, @NonNull DateFormat format) {
        return TimeUtils.getUSWeek(TimeUtils.string2Date(time, format));
    }

    public static String getUSWeek(Date date) {
        return new SimpleDateFormat("EEEE", Locale.US).format(date);
    }

    public static String getUSWeek(long millis) {
        return TimeUtils.getUSWeek(new Date(millis));
    }

    public static boolean isAm() {
        Calendar cal = Calendar.getInstance();
        return cal.get(9) == 0;
    }

    public static boolean isAm(String time) {
        return TimeUtils.getValueByCalendarField(time, TimeUtils.getDefaultFormat(), 9) == 0;
    }

    public static boolean isAm(String time, @NonNull DateFormat format) {
        return TimeUtils.getValueByCalendarField(time, format, 9) == 0;
    }

    public static boolean isAm(Date date) {
        return TimeUtils.getValueByCalendarField(date, 9) == 0;
    }

    public static boolean isAm(long millis) {
        return TimeUtils.getValueByCalendarField(millis, 9) == 0;
    }

    public static boolean isPm() {
        return !TimeUtils.isAm();
    }

    public static boolean isPm(String time) {
        return !TimeUtils.isAm(time);
    }

    public static boolean isPm(String time, @NonNull DateFormat format) {
        return !TimeUtils.isAm(time, format);
    }

    public static boolean isPm(Date date) {
        return !TimeUtils.isAm(date);
    }

    public static boolean isPm(long millis) {
        return !TimeUtils.isAm(millis);
    }

    public static int getValueByCalendarField(int field) {
        Calendar cal = Calendar.getInstance();
        return cal.get(field);
    }

    public static int getValueByCalendarField(String time, int field) {
        return TimeUtils.getValueByCalendarField(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()), field);
    }

    public static int getValueByCalendarField(String time, @NonNull DateFormat format, int field) {
        return TimeUtils.getValueByCalendarField(TimeUtils.string2Date(time, format), field);
    }

    public static int getValueByCalendarField(Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    public static int getValueByCalendarField(long millis, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal.get(field);
    }

    public static String getChineseZodiac(String time) {
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()));
    }

    public static String getChineseZodiac(String time, @NonNull DateFormat format) {
        return TimeUtils.getChineseZodiac(TimeUtils.string2Date(time, format));
    }

    public static String getChineseZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return CHINESE_ZODIAC[cal.get(1) % 12];
    }

    public static String getChineseZodiac(long millis) {
        return TimeUtils.getChineseZodiac(TimeUtils.millis2Date(millis));
    }

    public static String getChineseZodiac(int year) {
        return CHINESE_ZODIAC[year % 12];
    }

    public static String getZodiac(String time) {
        return TimeUtils.getZodiac(TimeUtils.string2Date(time, TimeUtils.getDefaultFormat()));
    }

    public static String getZodiac(String time, @NonNull DateFormat format) {
        return TimeUtils.getZodiac(TimeUtils.string2Date(time, format));
    }

    public static String getZodiac(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return TimeUtils.getZodiac(month, day);
    }

    public static String getZodiac(long millis) {
        return TimeUtils.getZodiac(TimeUtils.millis2Date(millis));
    }

    public static String getZodiac(int month, int day) {
        return ZODIAC[day >= ZODIAC_FLAGS[month - 1] ? month - 1 : (month + 10) % 12];
    }

    private static long timeSpan2Millis(long timeSpan, int unit) {
        return timeSpan * (long)unit;
    }

    private static long millis2TimeSpan(long millis, int unit) {
        return millis / (long)unit;
    }

    static String millis2FitTimeSpan(long millis, int precision) {
        if (precision <= 0) {
            return null;
        }
        precision = Math.min(precision, 5);
        String[] units = new String[]{"\u5929", "\u5c0f\u65f6", "\u5206\u949f", "\u79d2", "\u6beb\u79d2"};
        if (millis == 0L) {
            return 0 + units[precision - 1];
        }
        StringBuilder sb = new StringBuilder();
        if (millis < 0L) {
            sb.append("-");
            millis = -millis;
        }
        int[] unitLen = new int[]{86400000, 3600000, 60000, 1000, 1};
        for (int i = 0; i < precision; ++i) {
            if (millis < (long)unitLen[i]) continue;
            long mode = millis / (long)unitLen[i];
            millis -= mode * (long)unitLen[i];
            sb.append(mode).append(units[i]);
        }
        return sb.toString();
    }
}

