/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import com.netacom.base.chat.android_utils.UtilsBridge;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class ConvertUtils {
    private static final int BUFFER_SIZE = 8192;
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ConvertUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String int2HexString(int num) {
        return Integer.toHexString(num);
    }

    public static int hexString2Int(String hexString) {
        return Integer.parseInt(hexString, 16);
    }

    public static String bytes2Bits(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            for (int j = 7; j >= 0; --j) {
                sb.append((aByte >> j & 1) == 0 ? (char)'0' : '1');
            }
        }
        return sb.toString();
    }

    public static byte[] bits2Bytes(String bits) {
        int lenMod = bits.length() % 8;
        int byteLen = bits.length() / 8;
        if (lenMod != 0) {
            for (int i = lenMod; i < 8; ++i) {
                bits = "0" + bits;
            }
            ++byteLen;
        }
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            for (int j = 0; j < 8; ++j) {
                int n = i;
                bytes[n] = (byte)(bytes[n] << 1);
                int n2 = i;
                bytes[n2] = (byte)(bytes[n2] | bits.charAt(i * 8 + j) - 48);
            }
        }
        return bytes;
    }

    public static char[] bytes2Chars(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        if (len <= 0) {
            return null;
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(bytes[i] & 0xFF);
        }
        return chars;
    }

    public static byte[] chars2Bytes(char[] chars) {
        if (chars == null || chars.length <= 0) {
            return null;
        }
        int len = chars.length;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String bytes2HexString(byte[] bytes) {
        return ConvertUtils.bytes2HexString(bytes, true);
    }

    public static String bytes2HexString(byte[] bytes, boolean isUpperCase) {
        if (bytes == null) {
            return "";
        }
        char[] hexDigits = isUpperCase ? HEX_DIGITS_UPPER : HEX_DIGITS_LOWER;
        int len = bytes.length;
        if (len <= 0) {
            return "";
        }
        char[] ret = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            ret[j++] = hexDigits[bytes[i] >> 4 & 0xF];
            ret[j++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(ret);
    }

    public static byte[] hexString2Bytes(String hexString) {
        if (UtilsBridge.isSpace(hexString)) {
            return new byte[0];
        }
        int len = hexString.length();
        if (len % 2 != 0) {
            hexString = "0" + hexString;
            ++len;
        }
        char[] hexBytes = hexString.toUpperCase().toCharArray();
        byte[] ret = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            ret[i >> 1] = (byte)(ConvertUtils.hex2Dec(hexBytes[i]) << 4 | ConvertUtils.hex2Dec(hexBytes[i + 1]));
        }
        return ret;
    }

    private static int hex2Dec(char hexChar) {
        if (hexChar >= '0' && hexChar <= '9') {
            return hexChar - 48;
        }
        if (hexChar >= 'A' && hexChar <= 'F') {
            return hexChar - 65 + 10;
        }
        throw new IllegalArgumentException();
    }

    public static String bytes2String(byte[] bytes) {
        return ConvertUtils.bytes2String(bytes, "");
    }

    public static String bytes2String(byte[] bytes, String charsetName) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, ConvertUtils.getSafeCharset(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(bytes);
        }
    }

    public static byte[] string2Bytes(String string) {
        return ConvertUtils.string2Bytes(string, "");
    }

    public static byte[] string2Bytes(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(ConvertUtils.getSafeCharset(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return string.getBytes();
        }
    }

    public static JSONObject bytes2JSONObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new JSONObject(new String(bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] jsonObject2Bytes(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.toString().getBytes();
    }

    public static JSONArray bytes2JSONArray(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new JSONArray(new String(bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] jsonArray2Bytes(JSONArray jsonArray) {
        if (jsonArray == null) {
            return null;
        }
        return jsonArray.toString().getBytes();
    }

    public static <T> T bytes2Parcelable(byte[] bytes, Parcelable.Creator<T> creator) {
        if (bytes == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(bytes, 0, bytes.length);
        parcel.setDataPosition(0);
        Object result = creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)result;
    }

    public static byte[] parcelable2Bytes(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcelable.writeToParcel(parcel, 0);
        byte[] bytes = parcel.marshall();
        parcel.recycle();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object bytes2Object(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serializable2Bytes(Serializable serializable) {
        if (serializable == null) {
            return null;
        }
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(serializable);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] bitmap2Bytes(Bitmap bitmap, Bitmap.CompressFormat format, int quality) {
        return UtilsBridge.bitmap2Bytes(bitmap, format, quality);
    }

    public static Drawable bytes2Drawable(byte[] bytes) {
        return UtilsBridge.bytes2Drawable(bytes);
    }

    public static byte[] drawable2Bytes(Drawable drawable, Bitmap.CompressFormat format, int quality) {
        return UtilsBridge.drawable2Bytes(drawable, format, quality);
    }

    public static long memorySize2Byte(long memorySize, int unit) {
        if (memorySize < 0L) {
            return -1L;
        }
        return memorySize * (long)unit;
    }

    public static double byte2MemorySize(long byteSize, int unit) {
        if (byteSize < 0L) {
            return -1.0;
        }
        return (double)byteSize / (double)unit;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteSize) {
        return ConvertUtils.byte2FitMemorySize(byteSize, 3);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String byte2FitMemorySize(long byteSize, int precision) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision shouldn't be less than zero!");
        }
        if (byteSize < 0L) {
            throw new IllegalArgumentException("byteSize shouldn't be less than zero!");
        }
        if (byteSize < 1024L) {
            return String.format("%." + precision + "fB", byteSize);
        }
        if (byteSize < 0x100000L) {
            return String.format("%." + precision + "fKB", (double)byteSize / 1024.0);
        }
        if (byteSize < 0x40000000L) {
            return String.format("%." + precision + "fMB", (double)byteSize / 1048576.0);
        }
        return String.format("%." + precision + "fGB", (double)byteSize / 1.073741824E9);
    }

    public static long timeSpan2Millis(long timeSpan, int unit) {
        return timeSpan * (long)unit;
    }

    public static long millis2TimeSpan(long millis, int unit) {
        return millis / (long)unit;
    }

    public static String millis2FitTimeSpan(long millis, int precision) {
        return UtilsBridge.millis2FitTimeSpan(millis, precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream input2OutputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] b = new byte[8192];
            while ((len = is.read(b, 0, 8192)) != -1) {
                os.write(b, 0, len);
            }
            ByteArrayOutputStream byteArrayOutputStream = os;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            ByteArrayOutputStream byteArrayOutputStream = null;
            return byteArrayOutputStream;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ByteArrayInputStream output2InputStream(OutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(((ByteArrayOutputStream)out).toByteArray());
    }

    public static byte[] inputStream2Bytes(InputStream is) {
        if (is == null) {
            return null;
        }
        return ConvertUtils.input2OutputStream(is).toByteArray();
    }

    public static InputStream bytes2InputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] outputStream2Bytes(OutputStream out) {
        if (out == null) {
            return null;
        }
        return ((ByteArrayOutputStream)out).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream bytes2OutputStream(byte[] bytes) {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        ByteArrayOutputStream os = null;
        try {
            os = new ByteArrayOutputStream();
            os.write(bytes);
            ByteArrayOutputStream byteArrayOutputStream = os;
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            OutputStream outputStream = null;
            return outputStream;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String inputStream2String(InputStream is, String charsetName) {
        if (is == null) {
            return "";
        }
        try {
            ByteArrayOutputStream baos = ConvertUtils.input2OutputStream(is);
            if (baos == null) {
                return "";
            }
            return baos.toString(ConvertUtils.getSafeCharset(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static InputStream string2InputStream(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return new ByteArrayInputStream(string.getBytes(ConvertUtils.getSafeCharset(charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String outputStream2String(OutputStream out, String charsetName) {
        if (out == null) {
            return "";
        }
        try {
            return new String(ConvertUtils.outputStream2Bytes(out), ConvertUtils.getSafeCharset(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static OutputStream string2OutputStream(String string, String charsetName) {
        if (string == null) {
            return null;
        }
        try {
            return ConvertUtils.bytes2OutputStream(string.getBytes(ConvertUtils.getSafeCharset(charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> inputStream2Lines(InputStream is) {
        return ConvertUtils.inputStream2Lines(is, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> inputStream2Lines(InputStream is, String charsetName) {
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = new BufferedReader(new InputStreamReader(is, ConvertUtils.getSafeCharset(charsetName)));
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Bitmap drawable2Bitmap(Drawable drawable) {
        return UtilsBridge.drawable2Bitmap(drawable);
    }

    public static Drawable bitmap2Drawable(Bitmap bitmap) {
        return UtilsBridge.bitmap2Drawable(bitmap);
    }

    public static Bitmap view2Bitmap(View view) {
        return UtilsBridge.view2Bitmap(view);
    }

    public static int dp2px(float dpValue) {
        return UtilsBridge.dp2px(dpValue);
    }

    public static int px2dp(float pxValue) {
        return UtilsBridge.px2dp(pxValue);
    }

    public static int sp2px(float spValue) {
        return UtilsBridge.sp2px(spValue);
    }

    public static int px2sp(float pxValue) {
        return UtilsBridge.px2sp(pxValue);
    }

    private static String getSafeCharset(String charsetName) {
        String cn = charsetName;
        if (UtilsBridge.isSpace(charsetName) || !Charset.isSupported(charsetName)) {
            cn = "UTF-8";
        }
        return cn;
    }
}

