/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.security.biometric;

import androidx.biometric.BiometricManager;
import androidx.biometric.BiometricPrompt;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.netacom.base.chat.coroutine.CoroutineDispatcherProvider;
import com.netacom.base.chat.security.biometric.AuthPromptInfo;
import com.netacom.base.chat.security.biometric.Biometric;
import com.netacom.base.chat.security.biometric.BiometricAuth;
import com.netacom.base.chat.security.biometric.BiometricAvailability;
import com.netacom.base.chat.security.biometric.BiometricCipher;
import com.netacom.base.chat.security.biometric.BiometricError;
import com.netacom.base.chat.security.biometric.BiometricResult;
import java.security.Signature;
import java.util.concurrent.Executor;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\f\u0010 \u001a\u00020!*\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/netacom/base/chat/security/biometric/BiometricAuth;", "Lcom/netacom/base/chat/security/biometric/Biometric;", "biometricPromptExecutor", "Ljava/util/concurrent/Executor;", "biometricCipher", "Lcom/netacom/base/chat/security/biometric/BiometricCipher;", "biometricManager", "Landroidx/biometric/BiometricManager;", "dispatcherProvider", "Lcom/netacom/base/chat/coroutine/CoroutineDispatcherProvider;", "(Ljava/util/concurrent/Executor;Lcom/netacom/base/chat/security/biometric/BiometricCipher;Landroidx/biometric/BiometricManager;Lcom/netacom/base/chat/coroutine/CoroutineDispatcherProvider;)V", "authenticate", "Lkotlinx/coroutines/flow/Flow;", "Lcom/netacom/base/chat/security/biometric/BiometricResult;", "fragment", "Landroidx/fragment/app/Fragment;", "authPromptInfo", "Lcom/netacom/base/chat/security/biometric/AuthPromptInfo;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "biometricAuthResult", "mac", "Ljavax/crypto/Mac;", "cipher", "Ljavax/crypto/Cipher;", "signature", "Ljava/security/Signature;", "canAuthenticate", "Lcom/netacom/base/chat/security/biometric/BiometricAvailability;", "biometricError", "Lcom/netacom/base/chat/security/biometric/BiometricError;", "", "biometricPromptInfo", "Landroidx/biometric/BiometricPrompt$PromptInfo;", "netacom-base-chat_NetAloDevRelease"})
public final class BiometricAuth
implements Biometric {
    private final Executor biometricPromptExecutor;
    private final BiometricCipher biometricCipher;
    private final BiometricManager biometricManager;
    private final CoroutineDispatcherProvider dispatcherProvider;

    @Override
    @NotNull
    public BiometricAvailability canAuthenticate() {
        BiometricAvailability biometricAvailability;
        switch (this.biometricManager.canAuthenticate()) {
            case 12: {
                biometricAvailability = BiometricAvailability.NoHardware;
                break;
            }
            case 11: {
                biometricAvailability = BiometricAvailability.UserNotEnrolled;
                break;
            }
            case 1: {
                biometricAvailability = BiometricAvailability.Retry;
                break;
            }
            default: {
                biometricAvailability = BiometricAvailability.Success;
            }
        }
        return biometricAvailability;
    }

    @Override
    @ExperimentalCoroutinesApi
    @NotNull
    public Flow<BiometricResult> authenticate(@NotNull FragmentActivity fragmentActivity, @NotNull AuthPromptInfo authPromptInfo) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)authPromptInfo, (String)"authPromptInfo");
        return FlowKt.flowOn((Flow)FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super BiometricResult>, Continuation<? super Unit>, Object>(this, fragmentActivity, authPromptInfo, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ BiometricAuth this$0;
            final /* synthetic */ FragmentActivity $fragmentActivity;
            final /* synthetic */ AuthPromptInfo $authPromptInfo;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        BiometricPrompt biometricPrompt = new BiometricPrompt(this.$fragmentActivity, BiometricAuth.access$getBiometricPromptExecutor$p(this.this$0), new BiometricPrompt.AuthenticationCallback(this, (ProducerScope<? super BiometricResult>)$this$callbackFlow){
                            final /* synthetic */ authenticate.1 this$0;
                            final /* synthetic */ ProducerScope $this_callbackFlow;

                            public void onAuthenticationError(int errorCode, @NotNull CharSequence errString) {
                                Intrinsics.checkNotNullParameter((Object)errString, (String)"errString");
                                super.onAuthenticationError(errorCode, errString);
                                ChannelsKt.sendBlocking((SendChannel)((SendChannel)this.$this_callbackFlow), (Object)new BiometricResult.Error(BiometricAuth.access$biometricError(this.this$0.this$0, errorCode), ((Object)errString).toString()));
                            }

                            public void onAuthenticationFailed() {
                                super.onAuthenticationFailed();
                                ChannelsKt.sendBlocking((SendChannel)((SendChannel)this.$this_callbackFlow), (Object)BiometricResult.Failed.INSTANCE);
                            }

                            public void onAuthenticationSucceeded(@NotNull BiometricPrompt.AuthenticationResult result) {
                                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                                super.onAuthenticationSucceeded(result);
                                BiometricPrompt.CryptoObject cryptoObject = result.getCryptoObject();
                                BiometricPrompt.CryptoObject cryptoObject2 = result.getCryptoObject();
                                BiometricPrompt.CryptoObject cryptoObject3 = result.getCryptoObject();
                                ChannelsKt.sendBlocking((SendChannel)((SendChannel)this.$this_callbackFlow), (Object)BiometricAuth.access$biometricAuthResult(this.this$0.this$0, cryptoObject != null ? cryptoObject.getMac() : null, cryptoObject2 != null ? cryptoObject2.getCipher() : null, cryptoObject3 != null ? cryptoObject3.getSignature() : null));
                            }
                            {
                                this.this$0 = this$0;
                                this.$this_callbackFlow = $receiver;
                            }
                        });
                        boolean bl = false;
                        boolean bl2 = false;
                        BiometricPrompt $this$run = biometricPrompt;
                        boolean bl3 = false;
                        $this$run.authenticate(BiometricAuth.access$biometricPromptInfo(this.this$0, this.$authPromptInfo), new BiometricPrompt.CryptoObject(BiometricAuth.access$getBiometricCipher$p(this.this$0).getEncryptCipher()));
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose$default((ProducerScope)$this$callbackFlow, null, (Continuation)this, (int)1, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = biometricAuth;
                this.$fragmentActivity = fragmentActivity;
                this.$authPromptInfo = authPromptInfo;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<ProducerScope<? super BiometricResult>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineContext)((CoroutineContext)this.dispatcherProvider.main()));
    }

    @Override
    @ExperimentalCoroutinesApi
    @NotNull
    public Flow<BiometricResult> authenticate(@NotNull Fragment fragment, @NotNull AuthPromptInfo authPromptInfo) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)authPromptInfo, (String)"authPromptInfo");
        FragmentActivity fragmentActivity = fragment.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"fragment.requireActivity()");
        return this.authenticate(fragmentActivity, authPromptInfo);
    }

    private final BiometricResult biometricAuthResult(Mac mac, Cipher cipher, Signature signature) {
        return mac != null ? (BiometricResult)new BiometricResult.AuthMac(mac) : (cipher != null ? (BiometricResult)new BiometricResult.AuthCipher(cipher) : (signature != null ? (BiometricResult)new BiometricResult.AuthSignature(signature) : (BiometricResult)BiometricResult.Failed.INSTANCE));
    }

    private final BiometricPrompt.PromptInfo biometricPromptInfo(AuthPromptInfo $this$biometricPromptInfo) {
        BiometricPrompt.PromptInfo.Builder builder = new BiometricPrompt.PromptInfo.Builder();
        boolean bl = false;
        boolean bl2 = false;
        BiometricPrompt.PromptInfo.Builder it = builder;
        boolean bl3 = false;
        it.setTitle((CharSequence)$this$biometricPromptInfo.getPromptTitle());
        it.setNegativeButtonText((CharSequence)$this$biometricPromptInfo.getPromptNegativeButtonText());
        CharSequence charSequence = $this$biometricPromptInfo.getPromptSubtitle();
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            it.setSubtitle((CharSequence)$this$biometricPromptInfo.getPromptSubtitle());
        }
        if ($this$biometricPromptInfo.getDeviceCredentialAllowed() != null) {
            it.setDeviceCredentialAllowed($this$biometricPromptInfo.getDeviceCredentialAllowed().booleanValue());
        }
        BiometricPrompt.PromptInfo promptInfo = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)promptInfo, (String)"BiometricPrompt.PromptIn\u2026)\n        }\n    }.build()");
        return promptInfo;
    }

    private final BiometricError biometricError(int $this$biometricError) {
        BiometricError biometricError;
        switch ($this$biometricError) {
            case 1: {
                biometricError = BiometricError.Retry;
                break;
            }
            case 2: {
                biometricError = BiometricError.UnableToProcess;
                break;
            }
            case 3: {
                biometricError = BiometricError.Timeout;
                break;
            }
            case 4: {
                biometricError = BiometricError.NoSpace;
                break;
            }
            case 5: {
                biometricError = BiometricError.Canceled;
                break;
            }
            case 7: {
                biometricError = BiometricError.Lockout;
                break;
            }
            case 8: {
                biometricError = BiometricError.VendorSpecific;
                break;
            }
            case 9: {
                biometricError = BiometricError.LocoutPermanent;
                break;
            }
            case 10: {
                biometricError = BiometricError.UserCanceled;
                break;
            }
            case 11: {
                biometricError = BiometricError.NoBiometricsEnrolled;
                break;
            }
            case 12: {
                biometricError = BiometricError.HardweareNotPresent;
                break;
            }
            case 13: {
                biometricError = BiometricError.NegativeButtonPressed;
                break;
            }
            case 14: {
                biometricError = BiometricError.NoDeviceCredentials;
                break;
            }
            default: {
                biometricError = BiometricError.Unknown;
            }
        }
        return biometricError;
    }

    public BiometricAuth(@NotNull Executor biometricPromptExecutor, @NotNull BiometricCipher biometricCipher, @NotNull BiometricManager biometricManager, @NotNull CoroutineDispatcherProvider dispatcherProvider) {
        Intrinsics.checkNotNullParameter((Object)biometricPromptExecutor, (String)"biometricPromptExecutor");
        Intrinsics.checkNotNullParameter((Object)biometricCipher, (String)"biometricCipher");
        Intrinsics.checkNotNullParameter((Object)biometricManager, (String)"biometricManager");
        Intrinsics.checkNotNullParameter((Object)dispatcherProvider, (String)"dispatcherProvider");
        this.biometricPromptExecutor = biometricPromptExecutor;
        this.biometricCipher = biometricCipher;
        this.biometricManager = biometricManager;
        this.dispatcherProvider = dispatcherProvider;
    }

    public static final /* synthetic */ Executor access$getBiometricPromptExecutor$p(BiometricAuth $this) {
        return $this.biometricPromptExecutor;
    }

    public static final /* synthetic */ BiometricError access$biometricError(BiometricAuth $this, int $this$access_u24biometricError) {
        return $this.biometricError($this$access_u24biometricError);
    }

    public static final /* synthetic */ BiometricResult access$biometricAuthResult(BiometricAuth $this, Mac mac, Cipher cipher, Signature signature) {
        return $this.biometricAuthResult(mac, cipher, signature);
    }

    public static final /* synthetic */ BiometricPrompt.PromptInfo access$biometricPromptInfo(BiometricAuth $this, AuthPromptInfo $this$access_u24biometricPromptInfo) {
        return $this.biometricPromptInfo($this$access_u24biometricPromptInfo);
    }

    public static final /* synthetic */ BiometricCipher access$getBiometricCipher$p(BiometricAuth $this) {
        return $this.biometricCipher;
    }
}

