/*
 * Decompiled with CFR 0.152.
 */
package com.gapo.richtext.spanner.seemore;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import com.gapo.richtext.ext.RichTextExtKt;
import com.gapo.richtext.measurement.RichTextMeasurement;
import com.gapo.richtext.spanner.RichTextSpanner;
import com.gapo.richtext.spanner.seemore.RichTextSeeMoreType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\r\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/gapo/richtext/spanner/seemore/RichTextSeeMoreSpanner;", "Lcom/gapo/richtext/spanner/RichTextSpanner;", "type", "Lcom/gapo/richtext/spanner/seemore/RichTextSeeMoreType;", "(Lcom/gapo/richtext/spanner/seemore/RichTextSeeMoreType;)V", "measureLineCount", "", "charSequence", "", "measurementParams", "Lcom/gapo/richtext/measurement/RichTextMeasurement$Params;", "span", "Landroid/text/Spannable;", "findIndexToSubStr", "startIndex", "isLetterOrDigit", "", "index", "richtext_release"})
public final class RichTextSeeMoreSpanner
implements RichTextSpanner {
    @NotNull
    private final RichTextSeeMoreType type;

    public RichTextSeeMoreSpanner(@NotNull RichTextSeeMoreType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
    }

    @Override
    @NotNull
    public Spannable span(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        Spanned seeMore = this.type.getSeeMore();
        RichTextSeeMoreType richTextSeeMoreType = this.type;
        if (richTextSeeMoreType instanceof RichTextSeeMoreType.Length) {
            int expectedContentLength = ((RichTextSeeMoreType.Length)this.type).getLength();
            if (expectedContentLength > charSequence.length()) {
                CharSequence $this$toSpannable$iv = charSequence;
                boolean $i$f$toSpannable = false;
                SpannableString spannableString = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
                Intrinsics.checkNotNullExpressionValue((Object)spannableString, (String)"valueOf(this)");
                return (Spannable)spannableString;
            }
            int indexToSubStr = this.findIndexToSubStr(charSequence, expectedContentLength);
            SpannableStringBuilder $i$f$toSpannable = RichTextExtKt.toSpannableStringBuilder(charSequence.subSequence(0, indexToSubStr)).append((CharSequence)seeMore);
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$toSpannable, (String)"charSequence.subSequence\u2026         .append(seeMore)");
            return (Spannable)$i$f$toSpannable;
        }
        if (richTextSeeMoreType instanceof RichTextSeeMoreType.Line) {
            int expectedContentLineCount = ((RichTextSeeMoreType.Line)this.type).getLine();
            CharSequence limitedLineCountContent = charSequence;
            int contentLineCount = this.measureLineCount(limitedLineCountContent, ((RichTextSeeMoreType.Line)this.type).getMeasurementParams());
            if (contentLineCount < expectedContentLineCount) {
                CharSequence $this$toSpannable$iv = charSequence;
                boolean $i$f$toSpannable = false;
                SpannableString spannableString = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
                Intrinsics.checkNotNullExpressionValue((Object)spannableString, (String)"valueOf(this)");
                return (Spannable)spannableString;
            }
            int startIndex = 0;
            int length = limitedLineCountContent.length();
            int endIndex = length / 2;
            while (contentLineCount != expectedContentLineCount) {
                limitedLineCountContent = charSequence.subSequence(0, endIndex);
                contentLineCount = this.measureLineCount(limitedLineCountContent, ((RichTextSeeMoreType.Line)this.type).getMeasurementParams());
                if (contentLineCount > expectedContentLineCount) {
                    startIndex = 0;
                    length = endIndex;
                } else {
                    startIndex = endIndex;
                }
                endIndex = (length + startIndex) / 2;
            }
            endIndex = this.findIndexToSubStr(charSequence, limitedLineCountContent.length());
            limitedLineCountContent = charSequence.subSequence(0, endIndex);
            SpannableStringBuilder spannableStringBuilder = RichTextExtKt.toSpannableStringBuilder(limitedLineCountContent).append((CharSequence)seeMore);
            Intrinsics.checkNotNullExpressionValue((Object)spannableStringBuilder, (String)"limitedLineCountContent.\u2026Builder().append(seeMore)");
            return (Spannable)spannableStringBuilder;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final int measureLineCount(CharSequence charSequence, RichTextMeasurement.Params measurementParams) {
        return RichTextMeasurement.INSTANCE.getTextLineCount(charSequence, measurementParams);
    }

    private final int findIndexToSubStr(CharSequence $this$findIndexToSubStr, int startIndex) {
        int index = startIndex;
        while (this.isLetterOrDigit($this$findIndexToSubStr, index)) {
            ++index;
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLetterOrDigit(CharSequence $this$isLetterOrDigit, int index) {
        Object object = StringsKt.getOrNull((CharSequence)$this$isLetterOrDigit, (int)index);
        String string = object == null ? null : ((Character)object).toString();
        object = string;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null) return false;
        if (object.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        object = string;
        bl = false;
        bl2 = false;
        if (object == null) return false;
        if (StringsKt.isBlank((CharSequence)object)) {
            return false;
        }
        boolean bl4 = false;
        if (bl4) return false;
        if (Intrinsics.areEqual((Object)string, (Object)"\n")) return false;
        if (Intrinsics.areEqual((Object)string, (Object)"\r")) return false;
        return true;
    }
}

