/*
 * Decompiled with CFR 0.152.
 */
package com.gapo.richtext.spanner.metadata;

import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import android.view.View;
import androidx.annotation.ColorInt;
import com.gapo.richtext.RichTextClickableSpan;
import com.gapo.richtext.RichTextOnClickSpanListener;
import com.gapo.richtext.parser.RichTextMetadataParser;
import com.gapo.richtext.spanner.RichTextSpanner;
import com.gapo.richtext.spanner.metadata.RichTextMetadata;
import com.gapo.richtext.spanner.metadata.RichTextMetadataSpanFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanner;", "Lcom/gapo/richtext/spanner/RichTextSpanner;", "params", "Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanner$Params;", "(Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanner$Params;)V", "span", "Landroid/text/Spannable;", "charSequence", "", "metadata", "Lcom/gapo/richtext/spanner/metadata/RichTextMetadata;", "Params", "richtext_release"})
public final class RichTextMetadataSpanner
implements RichTextSpanner {
    @NotNull
    private final Params params;

    private RichTextMetadataSpanner(Params params) {
        this.params = params;
    }

    @Override
    @NotNull
    public Spannable span(@NotNull CharSequence charSequence) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        RichTextMetadataParser richTextMetadataParser = this.params.getMetadataParser$richtext_release();
        List<RichTextMetadata> list = richTextMetadataParser == null ? null : richTextMetadataParser.parse(charSequence);
        List<RichTextMetadata> metadata = list == null ? this.params.getMetadata$richtext_release() : list;
        CharSequence $this$toSpannable$iv = charSequence;
        boolean $i$f$toSpannable = false;
        SpannableString spannableString = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
        Intrinsics.checkNotNullExpressionValue((Object)spannableString, (String)"valueOf(this)");
        Spannable spannable = (Spannable)spannableString;
        Iterable $this$forEach$iv = metadata;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RichTextMetadata meta = (RichTextMetadata)element$iv;
            boolean bl = false;
            this.span(spannable, this.params, meta);
        }
        return spannable;
    }

    private final Spannable span(Spannable $this$span, Params params, RichTextMetadata metadata) {
        int start = metadata.getStart();
        int end = metadata.getEnd();
        if (start < 0 || start >= end || end > $this$span.length()) {
            return $this$span;
        }
        List<CharacterStyle> spans = params.createSpans$richtext_release(metadata);
        Iterable $this$forEach$iv = spans;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CharacterStyle span = (CharacterStyle)element$iv;
            boolean bl = false;
            $this$span.setSpan((Object)span, start, end, params.getFlag$richtext_release());
        }
        return $this$span;
    }

    public /* synthetic */ RichTextMetadataSpanner(Params params, DefaultConstructorMarker $constructor_marker) {
        this(params);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010 \u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020$J\u001b\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\f2\u0006\u0010\u000b\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020\u00002\b\b\u0001\u0010\u0003\u001a\u00020\u0004J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010*\u001a\u00020\u00002\b\b\u0001\u0010\n\u001a\u00020\u0004J\u0014\u0010+\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010-\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001eR\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanner$Params;", "", "()V", "backgroundColor", "", "flag", "getFlag$richtext_release", "()I", "setFlag$richtext_release", "(I)V", "foregroundColor", "metadata", "", "Lcom/gapo/richtext/spanner/metadata/RichTextMetadata;", "getMetadata$richtext_release", "()Ljava/util/List;", "setMetadata$richtext_release", "(Ljava/util/List;)V", "metadataParser", "Lcom/gapo/richtext/parser/RichTextMetadataParser;", "getMetadataParser$richtext_release", "()Lcom/gapo/richtext/parser/RichTextMetadataParser;", "setMetadataParser$richtext_release", "(Lcom/gapo/richtext/parser/RichTextMetadataParser;)V", "onClickSpanListener", "Lcom/gapo/richtext/RichTextOnClickSpanListener;", "spanFactories", "", "Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanFactory;", "strikethrough", "", "underline", "addAllSpanFactory", "addSpanFactory", "spanFactory", "create", "Lcom/gapo/richtext/spanner/metadata/RichTextMetadataSpanner;", "createSpans", "Landroid/text/style/CharacterStyle;", "createSpans$richtext_release", "setBackgroundColor", "setFlag", "setForegroundColor", "setMetadata", "setMetadataParser", "setOnClickListener", "setStrikethrough", "setUnderline", "richtext_release"})
    public static final class Params {
        @NotNull
        private List<RichTextMetadata> metadata;
        @Nullable
        private RichTextMetadataParser metadataParser;
        private int flag;
        @ColorInt
        private int foregroundColor;
        @ColorInt
        private int backgroundColor;
        private boolean underline;
        private boolean strikethrough;
        @NotNull
        private List<RichTextMetadataSpanFactory> spanFactories;
        @Nullable
        private RichTextOnClickSpanListener onClickSpanListener;

        public Params() {
            boolean bl = false;
            this.metadata = CollectionsKt.emptyList();
            this.flag = 33;
            bl = false;
            this.spanFactories = new ArrayList();
        }

        @NotNull
        public final List<RichTextMetadata> getMetadata$richtext_release() {
            return this.metadata;
        }

        public final void setMetadata$richtext_release(@NotNull List<RichTextMetadata> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.metadata = list;
        }

        @Nullable
        public final RichTextMetadataParser getMetadataParser$richtext_release() {
            return this.metadataParser;
        }

        public final void setMetadataParser$richtext_release(@Nullable RichTextMetadataParser richTextMetadataParser) {
            this.metadataParser = richTextMetadataParser;
        }

        public final int getFlag$richtext_release() {
            return this.flag;
        }

        public final void setFlag$richtext_release(int n) {
            this.flag = n;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CharacterStyle> createSpans$richtext_release(@NotNull RichTextMetadata metadata) {
            Collection<CharacterStyle> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            RichTextOnClickSpanListener listener;
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            boolean bl = false;
            List spans = new ArrayList();
            if (this.backgroundColor != 0) {
                spans.add(new BackgroundColorSpan(this.backgroundColor));
            }
            if (this.foregroundColor != 0) {
                spans.add(new ForegroundColorSpan(this.foregroundColor));
            }
            if ((listener = this.onClickSpanListener) != null) {
                spans.add(new RichTextClickableSpan(listener, metadata){
                    final /* synthetic */ RichTextOnClickSpanListener $listener;
                    final /* synthetic */ RichTextMetadata $metadata;
                    {
                        this.$listener = $listener;
                        this.$metadata = $metadata;
                    }

                    public void updateDrawState(@NotNull TextPaint textPaint) {
                        Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
                        this.$listener.updateDrawState(textPaint);
                    }

                    public void onClick(@NotNull View widget) {
                        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
                        this.$listener.onClickSpan(widget, this.$metadata);
                    }

                    public void onLongClick(@NotNull View widget) {
                        Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
                        this.$listener.onLongClickSpan(widget, this.$metadata);
                    }
                });
            }
            if (this.underline) {
                spans.add(new UnderlineSpan());
            }
            if (this.strikethrough) {
                spans.add(new StrikethroughSpan());
            }
            Iterable iterable = this.spanFactories;
            List list = spans;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RichTextMetadataSpanFactory richTextMetadataSpanFactory = (RichTextMetadataSpanFactory)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                CharacterStyle characterStyle = it.create();
                collection.add(characterStyle);
            }
            collection = (List)destination$iv$iv;
            list.addAll((Collection)collection);
            return spans;
        }

        @NotNull
        public final Params setMetadata(@NotNull List<RichTextMetadata> metadata) {
            Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setMetadata_u24lambda_u2d1 = params;
            boolean bl3 = false;
            $this$setMetadata_u24lambda_u2d1.setMetadata$richtext_release(metadata);
            return params;
        }

        @NotNull
        public final Params setMetadataParser(@NotNull RichTextMetadataParser metadataParser) {
            Intrinsics.checkNotNullParameter((Object)metadataParser, (String)"metadataParser");
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setMetadataParser_u24lambda_u2d2 = params;
            boolean bl3 = false;
            $this$setMetadataParser_u24lambda_u2d2.setMetadataParser$richtext_release(metadataParser);
            return params;
        }

        @NotNull
        public final Params setFlag(int flag) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setFlag_u24lambda_u2d3 = params;
            boolean bl3 = false;
            $this$setFlag_u24lambda_u2d3.setFlag$richtext_release(flag);
            return params;
        }

        @NotNull
        public final Params setBackgroundColor(@ColorInt int backgroundColor) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setBackgroundColor_u24lambda_u2d4 = params;
            boolean bl3 = false;
            $this$setBackgroundColor_u24lambda_u2d4.backgroundColor = backgroundColor;
            return params;
        }

        @NotNull
        public final Params setForegroundColor(@ColorInt int foregroundColor) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setForegroundColor_u24lambda_u2d5 = params;
            boolean bl3 = false;
            $this$setForegroundColor_u24lambda_u2d5.foregroundColor = foregroundColor;
            return params;
        }

        @NotNull
        public final Params setUnderline(boolean underline) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setUnderline_u24lambda_u2d6 = params;
            boolean bl3 = false;
            $this$setUnderline_u24lambda_u2d6.underline = underline;
            return params;
        }

        @NotNull
        public final Params setStrikethrough(boolean strikethrough) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setStrikethrough_u24lambda_u2d7 = params;
            boolean bl3 = false;
            $this$setStrikethrough_u24lambda_u2d7.strikethrough = strikethrough;
            return params;
        }

        @NotNull
        public final Params addSpanFactory(@NotNull RichTextMetadataSpanFactory spanFactory) {
            Intrinsics.checkNotNullParameter((Object)spanFactory, (String)"spanFactory");
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$addSpanFactory_u24lambda_u2d8 = params;
            boolean bl3 = false;
            $this$addSpanFactory_u24lambda_u2d8.spanFactories.add(spanFactory);
            return params;
        }

        @NotNull
        public final Params addAllSpanFactory(@NotNull List<? extends RichTextMetadataSpanFactory> spanFactories) {
            Intrinsics.checkNotNullParameter(spanFactories, (String)"spanFactories");
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$addAllSpanFactory_u24lambda_u2d9 = params;
            boolean bl3 = false;
            $this$addAllSpanFactory_u24lambda_u2d9.spanFactories.addAll((Collection<RichTextMetadataSpanFactory>)spanFactories);
            return params;
        }

        @NotNull
        public final Params setOnClickListener(@Nullable RichTextOnClickSpanListener onClickSpanListener) {
            Params params = this;
            boolean bl = false;
            boolean bl2 = false;
            Params $this$setOnClickListener_u24lambda_u2d10 = params;
            boolean bl3 = false;
            $this$setOnClickListener_u24lambda_u2d10.onClickSpanListener = onClickSpanListener;
            return params;
        }

        @NotNull
        public final RichTextMetadataSpanner create() {
            return new RichTextMetadataSpanner(this, null);
        }
    }
}

