/*
 * Decompiled with CFR 0.152.
 */
package com.gapo.richtext.measurement;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextPaint;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lcom/gapo/richtext/measurement/RichTextMeasurement;", "", "()V", "getStaticLayout", "Landroid/text/StaticLayout;", "text", "", "params", "Lcom/gapo/richtext/measurement/RichTextMeasurement$Params;", "getTextLineCount", "", "textView", "Landroid/widget/TextView;", "getTextLines", "", "Params", "richtext_release"})
public final class RichTextMeasurement {
    @NotNull
    public static final RichTextMeasurement INSTANCE = new RichTextMeasurement();

    private RichTextMeasurement() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CharSequence> getTextLines(@NotNull CharSequence text, @NotNull Params params) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        StaticLayout layout = this.getStaticLayout(text, params);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)layout.getLineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = layout.getText().subSequence(layout.getLineStart((int)it), layout.getLineEnd((int)it));
            collection.add(charSequence);
        }
        return (List)destination$iv$iv;
    }

    public final int getTextLineCount(@NotNull CharSequence text, @NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        StaticLayout layout = this.getStaticLayout(text, params);
        return layout.getLineCount();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CharSequence> getTextLines(@NotNull TextView textView) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        CharSequence charSequence = textView.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"textView.text");
        StaticLayout layout = this.getStaticLayout(charSequence, new Params.Builder().from(textView).build());
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)layout.getLineCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence2 = layout.getText().subSequence(layout.getLineStart((int)it), layout.getLineEnd((int)it));
            collection.add(charSequence2);
        }
        return (List)destination$iv$iv;
    }

    public final int getTextLineCount(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        CharSequence charSequence = textView.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"textView.text");
        StaticLayout layout = this.getStaticLayout(charSequence, new Params.Builder().from(textView).build());
        return layout.getLineCount();
    }

    private final StaticLayout getStaticLayout(CharSequence text, Params params) {
        StaticLayout staticLayout;
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout.Builder builder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)params.getTextPaint(), (int)params.getTextWidth()).setAlignment(params.getAlignment()).setLineSpacing(params.getLineSpacingExtra(), params.getLineSpacingMultiplier()).setIncludePad(params.getIncludeFontPadding()).setBreakStrategy(params.getBreakStrategy()).setHyphenationFrequency(params.getHyphenationFrequency());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"obtain(text, 0, text.len\u2026ams.hyphenationFrequency)");
            StaticLayout.Builder builder2 = builder;
            if (Build.VERSION.SDK_INT >= 26) {
                builder2.setJustificationMode(params.getJustificationMode());
            }
            if (Build.VERSION.SDK_INT >= 28) {
                builder2.setUseLineSpacingFromFallbacks(params.getUseFallbackLineSpacing());
            }
            if (Build.VERSION.SDK_INT >= 29 && params.getTextDirectionHeuristic() != null) {
                builder2.setTextDirection(params.getTextDirectionHeuristic());
            }
            StaticLayout staticLayout2 = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)staticLayout2, (String)"{\n        val builder = \u2026    builder.build()\n    }");
            staticLayout = staticLayout2;
        } else {
            staticLayout = new StaticLayout(text, params.getTextPaint(), params.getTextWidth(), params.getAlignment(), params.getLineSpacingMultiplier(), params.getLineSpacingExtra(), params.getIncludeFontPadding());
        }
        return staticLayout;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Ba\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0011\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001aR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001d\u00a8\u0006)"}, d2={"Lcom/gapo/richtext/measurement/RichTextMeasurement$Params;", "", "builder", "Lcom/gapo/richtext/measurement/RichTextMeasurement$Params$Builder;", "(Lcom/gapo/richtext/measurement/RichTextMeasurement$Params$Builder;)V", "textPaint", "Landroid/text/TextPaint;", "alignment", "Landroid/text/Layout$Alignment;", "lineSpacingExtra", "", "lineSpacingMultiplier", "includeFontPadding", "", "breakStrategy", "", "hyphenationFrequency", "justificationMode", "useFallbackLineSpacing", "textDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "textWidth", "(Landroid/text/TextPaint;Landroid/text/Layout$Alignment;FFZIIIZLandroid/text/TextDirectionHeuristic;I)V", "getAlignment", "()Landroid/text/Layout$Alignment;", "getBreakStrategy", "()I", "getHyphenationFrequency", "getIncludeFontPadding", "()Z", "getJustificationMode", "getLineSpacingExtra", "()F", "getLineSpacingMultiplier", "getTextDirectionHeuristic", "()Landroid/text/TextDirectionHeuristic;", "getTextPaint", "()Landroid/text/TextPaint;", "getTextWidth", "getUseFallbackLineSpacing", "Builder", "richtext_release"})
    public static final class Params {
        @NotNull
        private final TextPaint textPaint;
        @NotNull
        private final Layout.Alignment alignment;
        private final float lineSpacingExtra;
        private final float lineSpacingMultiplier;
        private final boolean includeFontPadding;
        private final int breakStrategy;
        private final int hyphenationFrequency;
        private final int justificationMode;
        private final boolean useFallbackLineSpacing;
        @Nullable
        private final TextDirectionHeuristic textDirectionHeuristic;
        private final int textWidth;

        private Params(TextPaint textPaint, Layout.Alignment alignment, float lineSpacingExtra, float lineSpacingMultiplier, boolean includeFontPadding, int breakStrategy, int hyphenationFrequency, int justificationMode, boolean useFallbackLineSpacing, TextDirectionHeuristic textDirectionHeuristic, int textWidth) {
            this.textPaint = textPaint;
            this.alignment = alignment;
            this.lineSpacingExtra = lineSpacingExtra;
            this.lineSpacingMultiplier = lineSpacingMultiplier;
            this.includeFontPadding = includeFontPadding;
            this.breakStrategy = breakStrategy;
            this.hyphenationFrequency = hyphenationFrequency;
            this.justificationMode = justificationMode;
            this.useFallbackLineSpacing = useFallbackLineSpacing;
            this.textDirectionHeuristic = textDirectionHeuristic;
            this.textWidth = textWidth;
        }

        @NotNull
        public final TextPaint getTextPaint() {
            return this.textPaint;
        }

        @NotNull
        public final Layout.Alignment getAlignment() {
            return this.alignment;
        }

        public final float getLineSpacingExtra() {
            return this.lineSpacingExtra;
        }

        public final float getLineSpacingMultiplier() {
            return this.lineSpacingMultiplier;
        }

        public final boolean getIncludeFontPadding() {
            return this.includeFontPadding;
        }

        public final int getBreakStrategy() {
            return this.breakStrategy;
        }

        public final int getHyphenationFrequency() {
            return this.hyphenationFrequency;
        }

        public final int getJustificationMode() {
            return this.justificationMode;
        }

        public final boolean getUseFallbackLineSpacing() {
            return this.useFallbackLineSpacing;
        }

        @Nullable
        public final TextDirectionHeuristic getTextDirectionHeuristic() {
            return this.textDirectionHeuristic;
        }

        public final int getTextWidth() {
            return this.textWidth;
        }

        public Params(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this(builder.getTextPaint(), builder.getAlignment(), builder.getLineSpacingExtra(), builder.getLineSpacingMultiplier(), builder.getIncludeFontPadding(), builder.getBreakStrategy(), builder.getHyphenationFrequency(), builder.getJustificationMode(), builder.getUseFallbackLineSpacing(), builder.getTextDirectionHeuristic(), builder.getTextWidth());
        }

        /*
         * Duplicate member names - consider using --renamedupmembers true
         */
        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020:J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010(\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u000e\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u00020\nJ\u000e\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\f\"\u0004\b2\u0010\u000eR\u001a\u00103\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0015\"\u0004\b5\u0010\u0017\u00a8\u0006;"}, d2={"Lcom/gapo/richtext/measurement/RichTextMeasurement$Params$Builder;", "", "()V", "alignment", "Landroid/text/Layout$Alignment;", "getAlignment", "()Landroid/text/Layout$Alignment;", "setAlignment", "(Landroid/text/Layout$Alignment;)V", "breakStrategy", "", "getBreakStrategy", "()I", "setBreakStrategy", "(I)V", "hyphenationFrequency", "getHyphenationFrequency", "setHyphenationFrequency", "includeFontPadding", "", "getIncludeFontPadding", "()Z", "setIncludeFontPadding", "(Z)V", "justificationMode", "getJustificationMode", "setJustificationMode", "lineSpacingExtra", "", "getLineSpacingExtra", "()F", "setLineSpacingExtra", "(F)V", "lineSpacingMultiplier", "getLineSpacingMultiplier", "setLineSpacingMultiplier", "textDirectionHeuristic", "Landroid/text/TextDirectionHeuristic;", "getTextDirectionHeuristic", "()Landroid/text/TextDirectionHeuristic;", "setTextDirectionHeuristic", "(Landroid/text/TextDirectionHeuristic;)V", "textPaint", "Landroid/text/TextPaint;", "getTextPaint", "()Landroid/text/TextPaint;", "setTextPaint", "(Landroid/text/TextPaint;)V", "textWidth", "getTextWidth", "setTextWidth", "useFallbackLineSpacing", "getUseFallbackLineSpacing", "setUseFallbackLineSpacing", "build", "Lcom/gapo/richtext/measurement/RichTextMeasurement$Params;", "from", "textView", "Landroid/widget/TextView;", "richtext_release"})
        public static final class Builder {
            @NotNull
            private TextPaint textPaint = new TextPaint();
            @NotNull
            private Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
            private float lineSpacingExtra;
            private float lineSpacingMultiplier = 1.0f;
            private boolean includeFontPadding = true;
            private int breakStrategy;
            private int hyphenationFrequency;
            private int justificationMode;
            private boolean useFallbackLineSpacing;
            @Nullable
            private TextDirectionHeuristic textDirectionHeuristic;
            private int textWidth;

            @NotNull
            public final TextPaint getTextPaint() {
                return this.textPaint;
            }

            public final void setTextPaint(@NotNull TextPaint textPaint) {
                Intrinsics.checkNotNullParameter((Object)textPaint, (String)"<set-?>");
                this.textPaint = textPaint;
            }

            @NotNull
            public final Layout.Alignment getAlignment() {
                return this.alignment;
            }

            public final void setAlignment(@NotNull Layout.Alignment alignment) {
                Intrinsics.checkNotNullParameter((Object)alignment, (String)"<set-?>");
                this.alignment = alignment;
            }

            public final float getLineSpacingExtra() {
                return this.lineSpacingExtra;
            }

            public final void setLineSpacingExtra(float f) {
                this.lineSpacingExtra = f;
            }

            public final float getLineSpacingMultiplier() {
                return this.lineSpacingMultiplier;
            }

            public final void setLineSpacingMultiplier(float f) {
                this.lineSpacingMultiplier = f;
            }

            public final boolean getIncludeFontPadding() {
                return this.includeFontPadding;
            }

            public final void setIncludeFontPadding(boolean bl) {
                this.includeFontPadding = bl;
            }

            public final int getBreakStrategy() {
                return this.breakStrategy;
            }

            public final void setBreakStrategy(int n) {
                this.breakStrategy = n;
            }

            public final int getHyphenationFrequency() {
                return this.hyphenationFrequency;
            }

            public final void setHyphenationFrequency(int n) {
                this.hyphenationFrequency = n;
            }

            public final int getJustificationMode() {
                return this.justificationMode;
            }

            public final void setJustificationMode(int n) {
                this.justificationMode = n;
            }

            public final boolean getUseFallbackLineSpacing() {
                return this.useFallbackLineSpacing;
            }

            public final void setUseFallbackLineSpacing(boolean bl) {
                this.useFallbackLineSpacing = bl;
            }

            @Nullable
            public final TextDirectionHeuristic getTextDirectionHeuristic() {
                return this.textDirectionHeuristic;
            }

            public final void setTextDirectionHeuristic(@Nullable TextDirectionHeuristic textDirectionHeuristic) {
                this.textDirectionHeuristic = textDirectionHeuristic;
            }

            public final int getTextWidth() {
                return this.textWidth;
            }

            public final void setTextWidth(int n) {
                this.textWidth = n;
            }

            @NotNull
            public final Builder from(@NotNull TextView textView) {
                Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$from_u24lambda_u2d0 = builder;
                boolean bl3 = false;
                Layout layout = textView.getLayout();
                TextPaint textPaint = layout.getPaint();
                Intrinsics.checkNotNullExpressionValue((Object)textPaint, (String)"layout.paint");
                $this$from_u24lambda_u2d0.setTextPaint(textPaint);
                textPaint = layout.getAlignment();
                Intrinsics.checkNotNullExpressionValue((Object)textPaint, (String)"layout.alignment");
                $this$from_u24lambda_u2d0.setAlignment((Layout.Alignment)textPaint);
                $this$from_u24lambda_u2d0.setTextWidth(textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight());
                $this$from_u24lambda_u2d0.setLineSpacingExtra(textView.getLineSpacingExtra());
                $this$from_u24lambda_u2d0.setLineSpacingMultiplier(textView.getLineSpacingMultiplier());
                $this$from_u24lambda_u2d0.setIncludeFontPadding(textView.getIncludeFontPadding());
                if (Build.VERSION.SDK_INT >= 23) {
                    $this$from_u24lambda_u2d0.setBreakStrategy(textView.getBreakStrategy());
                    $this$from_u24lambda_u2d0.setHyphenationFrequency(textView.getHyphenationFrequency());
                }
                if (Build.VERSION.SDK_INT >= 26) {
                    $this$from_u24lambda_u2d0.setJustificationMode(textView.getJustificationMode());
                }
                if (Build.VERSION.SDK_INT >= 28) {
                    $this$from_u24lambda_u2d0.setUseFallbackLineSpacing(textView.isFallbackLineSpacing());
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    textPaint = textView.getTextDirectionHeuristic();
                    Intrinsics.checkNotNullExpressionValue((Object)textPaint, (String)"textView.textDirectionHeuristic");
                    $this$from_u24lambda_u2d0.setTextDirectionHeuristic((TextDirectionHeuristic)textPaint);
                }
                return builder;
            }

            @NotNull
            public final Builder setTextPaint(@NotNull TextPaint textPaint) {
                Intrinsics.checkNotNullParameter((Object)textPaint, (String)"textPaint");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setTextPaint_u24lambda_u2d1 = builder;
                boolean bl3 = false;
                $this$setTextPaint_u24lambda_u2d1.setTextPaint(textPaint);
                return builder;
            }

            @NotNull
            public final Builder setAlignment(@NotNull Layout.Alignment alignment) {
                Intrinsics.checkNotNullParameter((Object)alignment, (String)"alignment");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setAlignment_u24lambda_u2d2 = builder;
                boolean bl3 = false;
                $this$setAlignment_u24lambda_u2d2.setAlignment(alignment);
                return builder;
            }

            @NotNull
            public final Builder setLineSpacingExtra(float lineSpacingExtra) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setLineSpacingExtra_u24lambda_u2d3 = builder;
                boolean bl3 = false;
                $this$setLineSpacingExtra_u24lambda_u2d3.setLineSpacingExtra(lineSpacingExtra);
                return builder;
            }

            @NotNull
            public final Builder setLineSpacingMultiplier(float lineSpacingMultiplier) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setLineSpacingMultiplier_u24lambda_u2d4 = builder;
                boolean bl3 = false;
                $this$setLineSpacingMultiplier_u24lambda_u2d4.setLineSpacingMultiplier(lineSpacingMultiplier);
                return builder;
            }

            @NotNull
            public final Builder setIncludeFontPadding(boolean includeFontPadding) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setIncludeFontPadding_u24lambda_u2d5 = builder;
                boolean bl3 = false;
                $this$setIncludeFontPadding_u24lambda_u2d5.setIncludeFontPadding(includeFontPadding);
                return builder;
            }

            @NotNull
            public final Builder setBreakStrategy(int breakStrategy) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setBreakStrategy_u24lambda_u2d6 = builder;
                boolean bl3 = false;
                $this$setBreakStrategy_u24lambda_u2d6.setBreakStrategy(breakStrategy);
                return builder;
            }

            @NotNull
            public final Builder setHyphenationFrequency(int hyphenationFrequency) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setHyphenationFrequency_u24lambda_u2d7 = builder;
                boolean bl3 = false;
                $this$setHyphenationFrequency_u24lambda_u2d7.setHyphenationFrequency(hyphenationFrequency);
                return builder;
            }

            @NotNull
            public final Builder setJustificationMode(int justificationMode) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setJustificationMode_u24lambda_u2d8 = builder;
                boolean bl3 = false;
                $this$setJustificationMode_u24lambda_u2d8.setJustificationMode(justificationMode);
                return builder;
            }

            @NotNull
            public final Builder setUseFallbackLineSpacing(boolean useFallbackLineSpacing) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setUseFallbackLineSpacing_u24lambda_u2d9 = builder;
                boolean bl3 = false;
                $this$setUseFallbackLineSpacing_u24lambda_u2d9.setUseFallbackLineSpacing(useFallbackLineSpacing);
                return builder;
            }

            @NotNull
            public final Builder setTextDirectionHeuristic(@NotNull TextDirectionHeuristic textDirectionHeuristic) {
                Intrinsics.checkNotNullParameter((Object)textDirectionHeuristic, (String)"textDirectionHeuristic");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setTextDirectionHeuristic_u24lambda_u2d10 = builder;
                boolean bl3 = false;
                $this$setTextDirectionHeuristic_u24lambda_u2d10.setTextDirectionHeuristic(textDirectionHeuristic);
                return builder;
            }

            @NotNull
            public final Builder setTextWidth(int textWidth) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$setTextWidth_u24lambda_u2d11 = builder;
                boolean bl3 = false;
                $this$setTextWidth_u24lambda_u2d11.setTextWidth(textWidth);
                return builder;
            }

            @NotNull
            public final Params build() {
                return new Params(this);
            }
        }
    }
}

