/*
 * Decompiled with CFR 0.152.
 */
package com.gapo.richtext;

import android.text.Spannable;
import android.text.SpannableString;
import android.util.Log;
import com.gapo.richtext.spanner.RichTextSpanner;
import com.gapo.richtext.spanner.seemore.RichTextSeeMoreSpanner;
import com.gapo.richtext.spanner.seemore.RichTextSeeMoreType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lcom/gapo/richtext/RichText;", "", "original", "", "spannable", "Landroid/text/Spannable;", "seeMoreSpannable", "(Ljava/lang/CharSequence;Landroid/text/Spannable;Landroid/text/Spannable;)V", "hasSeeMore", "", "getHasSeeMore", "()Z", "isEmpty", "getOriginal", "()Ljava/lang/CharSequence;", "getSeeMoreSpannable", "()Landroid/text/Spannable;", "getSpannable", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "Builder", "richtext_release"})
public final class RichText {
    @NotNull
    private final CharSequence original;
    @NotNull
    private final Spannable spannable;
    @Nullable
    private final Spannable seeMoreSpannable;

    public RichText(@NotNull CharSequence original, @NotNull Spannable spannable, @Nullable Spannable seeMoreSpannable) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)spannable, (String)"spannable");
        this.original = original;
        this.spannable = spannable;
        this.seeMoreSpannable = seeMoreSpannable;
    }

    public /* synthetic */ RichText(CharSequence charSequence, Spannable spannable, Spannable spannable2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            spannable2 = null;
        }
        this(charSequence, spannable, spannable2);
    }

    @NotNull
    public final CharSequence getOriginal() {
        return this.original;
    }

    @NotNull
    public final Spannable getSpannable() {
        return this.spannable;
    }

    @Nullable
    public final Spannable getSeeMoreSpannable() {
        return this.seeMoreSpannable;
    }

    public final boolean isEmpty() {
        CharSequence charSequence = this.original;
        boolean bl = false;
        return charSequence.length() == 0;
    }

    public final boolean getHasSeeMore() {
        return this.seeMoreSpannable != null;
    }

    @NotNull
    public final CharSequence component1() {
        return this.original;
    }

    @NotNull
    public final Spannable component2() {
        return this.spannable;
    }

    @Nullable
    public final Spannable component3() {
        return this.seeMoreSpannable;
    }

    @NotNull
    public final RichText copy(@NotNull CharSequence original, @NotNull Spannable spannable, @Nullable Spannable seeMoreSpannable) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)spannable, (String)"spannable");
        return new RichText(original, spannable, seeMoreSpannable);
    }

    public static /* synthetic */ RichText copy$default(RichText richText, CharSequence charSequence, Spannable spannable, Spannable spannable2, int n, Object object) {
        if ((n & 1) != 0) {
            charSequence = richText.original;
        }
        if ((n & 2) != 0) {
            spannable = richText.spannable;
        }
        if ((n & 4) != 0) {
            spannable2 = richText.seeMoreSpannable;
        }
        return richText.copy(charSequence, spannable, spannable2);
    }

    @NotNull
    public String toString() {
        return "RichText(original=" + this.original + ", spannable=" + this.spannable + ", seeMoreSpannable=" + this.seeMoreSpannable + ')';
    }

    public int hashCode() {
        int result = this.original.hashCode();
        result = result * 31 + this.spannable.hashCode();
        result = result * 31 + (this.seeMoreSpannable == null ? 0 : this.seeMoreSpannable.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RichText)) {
            return false;
        }
        RichText richText = (RichText)other;
        if (!Intrinsics.areEqual((Object)this.original, (Object)richText.original)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.spannable, (Object)richText.spannable)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.seeMoreSpannable, (Object)richText.seeMoreSpannable);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/gapo/richtext/RichText$Builder;", "", "()V", "seeMoreType", "Lcom/gapo/richtext/spanner/seemore/RichTextSeeMoreType;", "spanners", "", "Lcom/gapo/richtext/spanner/RichTextSpanner;", "text", "", "addSpanner", "spanner", "index", "", "build", "Lcom/gapo/richtext/RichText;", "setSeeMoreType", "setText", "richtext_release"})
    public static final class Builder {
        @NotNull
        private CharSequence text = "";
        @NotNull
        private List<RichTextSpanner> spanners;
        @Nullable
        private RichTextSeeMoreType seeMoreType;

        public Builder() {
            boolean bl = false;
            this.spanners = new ArrayList();
        }

        @NotNull
        public final Builder setText(@NotNull CharSequence text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setText_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$setText_u24lambda_u2d0.text = text;
            return builder;
        }

        @NotNull
        public final Builder addSpanner(@NotNull RichTextSpanner spanner) {
            Intrinsics.checkNotNullParameter((Object)spanner, (String)"spanner");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$addSpanner_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$addSpanner_u24lambda_u2d1.spanners.add(spanner);
            return builder;
        }

        @NotNull
        public final Builder addSpanner(int index, @NotNull RichTextSpanner spanner) {
            Intrinsics.checkNotNullParameter((Object)spanner, (String)"spanner");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$addSpanner_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$addSpanner_u24lambda_u2d2.spanners.add(index, spanner);
            return builder;
        }

        @NotNull
        public final Builder setSeeMoreType(@NotNull RichTextSeeMoreType seeMoreType) {
            Intrinsics.checkNotNullParameter((Object)seeMoreType, (String)"seeMoreType");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$setSeeMoreType_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$setSeeMoreType_u24lambda_u2d3.seeMoreType = seeMoreType;
            return builder;
        }

        @NotNull
        public final RichText build() {
            CharSequence charSequence = this.text;
            boolean bl = false;
            if (charSequence.length() == 0) {
                CharSequence $this$toSpannable$iv = this.text;
                boolean $i$f$toSpannable = false;
                SpannableString spannableString = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
                Intrinsics.checkNotNullExpressionValue((Object)spannableString, (String)"valueOf(this)");
                return new RichText(this.text, (Spannable)spannableString, null);
            }
            Spannable spannable = null;
            CharSequence $this$toSpannable$iv = this.text;
            boolean $i$f$toSpannable = false;
            Object object = SpannableString.valueOf((CharSequence)$this$toSpannable$iv);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueOf(this)");
            spannable = (Spannable)object;
            Iterable $this$forEach$iv = this.spanners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RichTextSpanner it = (RichTextSpanner)element$iv;
                boolean bl2 = false;
                try {
                    spannable = it.span((CharSequence)spannable);
                }
                catch (Exception e) {
                    Log.e((String)"RichText", (String)"build: ", (Throwable)e);
                }
            }
            RichTextSeeMoreType seeMoreType = this.seeMoreType;
            Object shortSpannable = null;
            if (seeMoreType != null) {
                try {
                    object = new RichTextSeeMoreSpanner(seeMoreType).span((CharSequence)spannable);
                }
                catch (Exception e) {
                    Log.e((String)"RichText", (String)"build: ", (Throwable)e);
                    object = null;
                }
                shortSpannable = object;
            }
            return new RichText(this.text, spannable, (Spannable)shortSpannable);
        }
    }
}

