/*
 * Decompiled with CFR 0.152.
 */
package vn.funtap.funtapsdklite.ui;

import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.TextInputEditText;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.AppCompatEditText;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import vn.funtap.funtapsdklite.FuntapSDK;
import vn.funtap.funtapsdklite.R;
import vn.funtap.funtapsdklite.model.Data;
import vn.funtap.funtapsdklite.rest.APIService;
import vn.funtap.funtapsdklite.rest.RestfulApi;
import vn.funtap.funtapsdklite.utils.Preference;
import vn.funtap.funtapsdklite.utils.Utils;

public class SignInActivity
extends AppCompatActivity {
    private static final String TAG = SignInActivity.class.getSimpleName();
    private Button btnLogin;
    private ImageButton btnClose;
    private AppCompatEditText edUsername;
    private TextInputEditText edPassword;
    private APIService mAPIService;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_sign_in);
        this.btnLogin = (Button)this.findViewById(R.id.btn_login);
        this.btnClose = (ImageButton)this.findViewById(R.id.btn_closeform);
        this.edUsername = (AppCompatEditText)this.findViewById(R.id.edit_username);
        this.edPassword = (TextInputEditText)this.findViewById(R.id.edit_password);
        this.mAPIService = RestfulApi.getAPIService();
        this.btnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SignInActivity.this.setResult(FuntapSDK.REQUESTCODE_CALLBACK, null);
                SignInActivity.this.finish();
            }
        });
        this.btnLogin.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    if (!SignInActivity.this.validateInputForm((EditText)SignInActivity.this.edUsername)) {
                        return;
                    }
                    String username = SignInActivity.this.edUsername.getText().toString();
                    if (!SignInActivity.this.validateInputForm((EditText)SignInActivity.this.edPassword)) {
                        return;
                    }
                    String password = SignInActivity.this.edPassword.getText().toString();
                    String appkey = Preference.getString(SignInActivity.this.getApplicationContext(), FuntapSDK.SHARED_PREF_APPKEY);
                    String sec = Preference.getString(SignInActivity.this.getApplicationContext(), FuntapSDK.SHARED_PREF_SECRETKEY);
                    String input = sec + appkey + username + password;
                    String signature = Hashing.sha256().hashString((CharSequence)input, StandardCharsets.UTF_8).toString();
                    Log.d((String)TAG, (String)("Signature and something: " + signature + " , appkey " + appkey + ", username : " + username + " , password : " + password));
                    SignInActivity.this.loginPostRequest(appkey, username, password, signature);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void loginPostRequest(String appkey, String username, String password, String signature) {
        this.mAPIService.loginPost(appkey, username, password, signature).enqueue((Callback)new Callback<Data>(){

            public void onResponse(Call<Data> call, Response<Data> response) {
                try {
                    if (response.isSuccessful()) {
                        Data.UserInfo userInfo = ((Data)response.body()).getUserInfo();
                        Gson gson = new GsonBuilder().create();
                        String json = gson.toJson((Object)userInfo);
                        Intent intent = SignInActivity.this.getIntent();
                        intent.putExtra("data", json);
                        SignInActivity.this.setResult(FuntapSDK.REQUESTCODE_CALLBACK, intent);
                        SignInActivity.this.finish();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void onFailure(Call<Data> call, Throwable t) {
                SignInActivity.this.edUsername.setError((CharSequence)"Email/T\u00ean \u0111\u0103ng nh\u1eadp/S\u0110T/ M\u1eadt kh\u1ea9u kh\u00f4ng \u0111\u00fang");
                Intent intent = SignInActivity.this.getIntent();
                intent.putExtra("fails", t.getMessage().toString());
                SignInActivity.this.setResult(FuntapSDK.REQUESTCODE_CALLBACK, intent);
            }
        });
    }

    private String getSig() {
        String str = "ZKbkPEor+kDxxu2G9svRbXvxlJd7h0DeeB8fVwOTWg0=";
        byte[] decode = Base64.decode((String)str, (int)0);
        return Utils.decryptionDataECB(decode);
    }

    private boolean validateInputForm(EditText editText) {
        return editText.getText().toString().trim() != null || !editText.getText().toString().trim().equals("");
    }
}

