/*
 * Decompiled with CFR 0.152.
 */
package vn.funtap.funtapsdklite;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import vn.funtap.funtapsdklite.FuntapListener;
import vn.funtap.funtapsdklite.model.Data;
import vn.funtap.funtapsdklite.ui.SignInActivity;
import vn.funtap.funtapsdklite.utils.Preference;

public class FuntapSDK {
    private static final String TAG = FuntapSDK.class.getSimpleName();
    public static String SHARED_PREF_APPKEY = "shared_pref_appkey";
    public static String SHARED_PREF_SECRETKEY = "shared_pref_secretkey";
    public static int REQUESTCODE_CALLBACK = 9090;
    private FuntapListener mListener;
    private static FuntapSDK INSTANCE;
    private Activity mActivity;

    public static FuntapSDK getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FuntapSDK();
        }
        return INSTANCE;
    }

    public void init(Activity activity, String appkey, String sec) {
        this.mActivity = activity;
        try {
            Preference.save((Context)activity, SHARED_PREF_APPKEY, appkey);
            Preference.save((Context)activity, SHARED_PREF_SECRETKEY, sec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mListener == null) {
            this.setMobGameListener(new FuntapListener(){

                @Override
                public void onLoginSuccessful(String access_token, String ft_id) {
                }

                @Override
                public void onError(int errorCode, String message) {
                }

                @Override
                public void onCloseForm() {
                }
            });
        }
    }

    public void setMobGameListener(FuntapListener listener) {
        FuntapListener onLoginListener;
        final FuntapListener fl = listener;
        this.mListener = onLoginListener = new FuntapListener(){

            @Override
            public void onLoginSuccessful(String access_token, String ft_id) {
                fl.onLoginSuccessful(access_token, ft_id);
            }

            @Override
            public void onError(int errorCode, String message) {
                fl.onError(errorCode, message);
            }

            @Override
            public void onCloseForm() {
                fl.onCloseForm();
            }
        };
    }

    public void login() {
        Intent intent = new Intent((Context)this.mActivity, SignInActivity.class);
        this.mActivity.startActivityForResult(intent, REQUESTCODE_CALLBACK);
    }

    public void logout() {
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == REQUESTCODE_CALLBACK) {
            if (data != null) {
                if (data.getStringExtra("data") != null) {
                    String status = data.getStringExtra("data");
                    Log.d((String)TAG, (String)("data from activityResult : " + data));
                    Gson gson = new GsonBuilder().create();
                    Data.UserInfo response = (Data.UserInfo)gson.fromJson(status, Data.UserInfo.class);
                    this.mListener.onLoginSuccessful(response.getAccessToken(), response.getFtId());
                    this.mListener.onCloseForm();
                }
                if (data.getStringExtra("fails") != null) {
                    String error = data.getStringExtra("fails");
                    this.mListener.onError(-1, error);
                }
            } else {
                this.mListener.onCloseForm();
            }
        }
    }
}

