/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.plugin.auth.impl.LdapAuthenticationProvider;
import com.alibaba.nacos.plugin.auth.impl.configuration.ConditionOnLdapAuth;
import com.alibaba.nacos.plugin.auth.impl.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.plugin.auth.impl.users.NacosUserDetailsServiceImpl;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@EnableAutoConfiguration(exclude={LdapAutoConfiguration.class})
public class LdapAuthConfig {
    @Value(value="${nacos.core.auth.ldap.url:ldap://localhost:389}")
    private String ldapUrl;
    @Value(value="${nacos.core.auth.ldap.basedc:dc=example,dc=org}")
    private String ldapBaseDc;
    @Value(value="${nacos.core.auth.ldap.timeout:3000}")
    private String ldapTimeOut;
    @Value(value="${nacos.core.auth.ldap.userDn:cn=admin,dc=example,dc=org}")
    private String userDn;
    @Value(value="${nacos.core.auth.ldap.password:password}")
    private String password;
    @Value(value="${nacos.core.auth.ldap.filter.prefix:uid}")
    private String filterPrefix;

    @Bean
    @Conditional(value={ConditionOnLdapAuth.class})
    public LdapTemplate ldapTemplate() {
        LdapContextSource contextSource = new LdapContextSource();
        HashMap<String, String> config = new HashMap<String, String>(16);
        contextSource.setUrl(this.ldapUrl);
        contextSource.setBase(this.ldapBaseDc);
        contextSource.setUserDn(this.userDn);
        contextSource.setPassword(this.password);
        config.put("java.naming.ldap.attributes.binary", "objectGUID");
        config.put("com.sun.jndi.ldap.connect.timeout", this.ldapTimeOut);
        contextSource.setPooled(true);
        contextSource.setBaseEnvironmentProperties(config);
        contextSource.afterPropertiesSet();
        return new LdapTemplate((ContextSource)contextSource);
    }

    @Bean
    @Conditional(value={ConditionOnLdapAuth.class})
    public LdapAuthenticationProvider ldapAuthenticationProvider(LdapTemplate ldapTemplate, NacosUserDetailsServiceImpl userDetailsService, NacosRoleServiceImpl nacosRoleService, String filterPrefix) {
        return new LdapAuthenticationProvider(ldapTemplate, userDetailsService, nacosRoleService, filterPrefix);
    }
}

