/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.selector.context;

import com.alibaba.nacos.api.cmdb.pojo.Entity;
import com.alibaba.nacos.api.cmdb.pojo.PreservedEntityTypes;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.selector.context.CmdbContext;
import com.alibaba.nacos.api.selector.context.SelectorContextBuilder;
import com.alibaba.nacos.cmdb.service.CmdbReader;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class CmdbSelectorContextBuilder<T extends Instance>
implements SelectorContextBuilder<CmdbContext<Instance>, String, List<T>> {
    private static final String CONTEXT_TYPE = "CMDB";

    public CmdbReader getCmdbReader() {
        return (CmdbReader)ApplicationUtils.getBean(CmdbReader.class);
    }

    public CmdbContext<Instance> build(String consumer, List<T> provider) {
        Entity consumerEntity = this.getCmdbReader().queryEntity(consumer, PreservedEntityTypes.ip.name());
        Instance consumerInstance = new Instance();
        consumerInstance.setIp(consumer);
        CmdbContext.CmdbInstance consumerCmdbInstance = new CmdbContext.CmdbInstance();
        consumerCmdbInstance.setEntity(consumerEntity);
        consumerCmdbInstance.setInstance((Object)consumerInstance);
        CmdbContext cmdbContext = new CmdbContext();
        cmdbContext.setConsumer(consumerCmdbInstance);
        List providerCmdbInstances = Optional.ofNullable(provider).orElse(Collections.emptyList()).stream().map(is -> {
            CmdbContext.CmdbInstance providerCmdbInstance = new CmdbContext.CmdbInstance();
            providerCmdbInstance.setInstance(is);
            Entity providerEntity = this.getCmdbReader().queryEntity(is.getIp(), PreservedEntityTypes.ip.name());
            providerCmdbInstance.setEntity(providerEntity);
            return providerCmdbInstance;
        }).collect(Collectors.toList());
        cmdbContext.setProviders(providerCmdbInstances);
        return cmdbContext;
    }

    public String getContextType() {
        return CONTEXT_TYPE;
    }
}

