/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.task;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.misc.Loggers;
import java.util.HashSet;
import java.util.Set;

public class PushDelayTask
extends AbstractDelayTask {
    private final Service service;
    private boolean pushToAll;
    private Set<String> targetClients;

    public PushDelayTask(Service service, long delay) {
        this.service = service;
        this.pushToAll = true;
        this.targetClients = null;
        this.setTaskInterval(delay);
        this.setLastProcessTime(System.currentTimeMillis());
    }

    public PushDelayTask(Service service, long delay, String targetClient) {
        this.service = service;
        this.pushToAll = false;
        this.targetClients = new HashSet<String>(1);
        this.targetClients.add(targetClient);
        this.setTaskInterval(delay);
        this.setLastProcessTime(System.currentTimeMillis());
    }

    public void merge(AbstractDelayTask task) {
        if (!(task instanceof PushDelayTask)) {
            return;
        }
        PushDelayTask oldTask = (PushDelayTask)task;
        if (this.isPushToAll() || oldTask.isPushToAll()) {
            this.pushToAll = true;
            this.targetClients = null;
        } else {
            this.targetClients.addAll(oldTask.getTargetClients());
        }
        this.setLastProcessTime(Math.min(this.getLastProcessTime(), task.getLastProcessTime()));
        Loggers.PUSH.info("[PUSH] Task merge for {}", (Object)this.service);
    }

    public Service getService() {
        return this.service;
    }

    public boolean isPushToAll() {
        return this.pushToAll;
    }

    public Set<String> getTargetClients() {
        return this.targetClients;
    }
}

