/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.core.distributed.distro.DistroConfig;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class GlobalConfig {
    @PostConstruct
    public void printGlobalConfig() {
        this.overrideDistroConfiguration();
    }

    private void overrideDistroConfiguration() {
        Loggers.SRV_LOG.warn("naming.distro config will be removed, please use core.protocol.distro replace.");
        Loggers.SRV_LOG.warn("Using naming.distro config to replace core.distro config");
        DistroConfig.getInstance().setSyncDelayMillis((long)this.getTaskDispatchPeriod());
        DistroConfig.getInstance().setSyncRetryDelayMillis(this.getSyncRetryDelay());
        DistroConfig.getInstance().setLoadDataRetryDelayMillis(this.getLoadDataRetryDelayMillis());
    }

    @Deprecated
    public int getTaskDispatchPeriod() {
        return (Integer)EnvUtil.getProperty((String)"nacos.naming.distro.taskDispatchPeriod", Integer.class, (Object)2000);
    }

    @Deprecated
    public int getBatchSyncKeyCount() {
        return (Integer)EnvUtil.getProperty((String)"nacos.naming.distro.batchSyncKeyCount", Integer.class, (Object)1000);
    }

    public long getSyncRetryDelay() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.distro.syncRetryDelay", Long.class, (Object)5000L);
    }

    public boolean isDataWarmup() {
        return (Boolean)EnvUtil.getProperty((String)"nacos.naming.data.warmup", Boolean.class, (Object)false);
    }

    public boolean isExpireInstance() {
        return (Boolean)EnvUtil.getProperty((String)"nacos.naming.expireInstance", Boolean.class, (Object)true);
    }

    public long getLoadDataRetryDelayMillis() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.clean.loadDataRetryDelayMillis", Long.class, (Object)60000L);
    }

    public static Long getEmptyServiceCleanInterval() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.clean.empty-service.interval", Long.class, (Object)60000L);
    }

    public static Long getEmptyServiceExpiredTime() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.clean.empty-service.expired-time", Long.class, (Object)60000L);
    }

    public static Long getExpiredMetadataCleanInterval() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.clean.expired-metadata.interval", Long.class, (Object)5000L);
    }

    public static Long getExpiredMetadataExpiredTime() {
        return (Long)EnvUtil.getProperty((String)"nacos.naming.clean.expired-metadata.expired-time", Long.class, (Object)60000L);
    }
}

