/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.extend;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.naming.healthcheck.HealthCheckProcessor;
import com.alibaba.nacos.naming.healthcheck.extend.AbstractHealthCheckProcessorExtend;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckProcessorExtendV1
extends AbstractHealthCheckProcessorExtend {
    private final Collection<HealthCheckProcessor> processors = NacosServiceLoader.load(HealthCheckProcessor.class);

    @Override
    public Set<String> addProcessor(Set<String> origin) {
        Iterator<HealthCheckProcessor> processorIt = this.processors.iterator();
        HashSet<String> processorType = new HashSet<String>(origin);
        while (processorIt.hasNext()) {
            HealthCheckProcessor processor = processorIt.next();
            String type = processor.getType();
            if (processorType.contains(type)) {
                throw new RuntimeException("More than one processor of the same type was found : [type=\"" + type + "\"]");
            }
            processorType.add(type);
            this.registry.registerSingleton(this.lowerFirstChar(processor.getClass().getSimpleName()), (Object)processor);
        }
        return processorType;
    }
}

