/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.InternetAddressUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeJudgement;
import com.alibaba.nacos.naming.healthcheck.heartbeat.BeatCheckTask;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingProxy;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public class ClientBeatCheckTask
implements BeatCheckTask {
    private Service service;
    public static final String EPHEMERAL = "true";

    public ClientBeatCheckTask(Service service) {
        this.service = service;
    }

    @JsonIgnore
    public UdpPushService getPushService() {
        return (UdpPushService)ApplicationUtils.getBean(UdpPushService.class);
    }

    @JsonIgnore
    public DistroMapper getDistroMapper() {
        return (DistroMapper)((Object)ApplicationUtils.getBean(DistroMapper.class));
    }

    public GlobalConfig getGlobalConfig() {
        return (GlobalConfig)ApplicationUtils.getBean(GlobalConfig.class);
    }

    public SwitchDomain getSwitchDomain() {
        return (SwitchDomain)ApplicationUtils.getBean(SwitchDomain.class);
    }

    @Override
    public String taskKey() {
        return KeyBuilder.buildServiceMetaKey(this.service.getNamespaceId(), this.service.getName());
    }

    @Override
    public void run() {
        try {
            if (((UpgradeJudgement)((Object)ApplicationUtils.getBean(UpgradeJudgement.class))).isUseGrpcFeatures()) {
                return;
            }
            if (!this.getDistroMapper().responsible(this.service.getName())) {
                return;
            }
            if (!this.getSwitchDomain().isHealthCheckEnabled()) {
                return;
            }
            List<Instance> instances = this.service.allIPs(true);
            for (Instance instance : instances) {
                if (System.currentTimeMillis() - instance.getLastBeat() <= instance.getInstanceHeartBeatTimeOut() || instance.isMarked() || !instance.isHealthy()) continue;
                instance.setHealthy(false);
                Loggers.EVT_LOG.info("{POS} {IP-DISABLED} valid: {}:{}@{}@{}, region: {}, msg: client timeout after {}, last beat: {}", new Object[]{instance.getIp(), instance.getPort(), instance.getClusterName(), this.service.getName(), "unknown", instance.getInstanceHeartBeatTimeOut(), instance.getLastBeat()});
                this.getPushService().serviceChanged(this.service);
            }
            if (!this.getGlobalConfig().isExpireInstance()) {
                return;
            }
            for (Instance instance : instances) {
                if (instance.isMarked() || System.currentTimeMillis() - instance.getLastBeat() <= instance.getIpDeleteTimeout()) continue;
                Loggers.SRV_LOG.info("[AUTO-DELETE-IP] service: {}, ip: {}", (Object)this.service.getName(), (Object)JacksonUtils.toJson((Object)instance));
                this.deleteIp(instance);
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("Exception while processing client beat time out.", (Throwable)e);
        }
    }

    private void deleteIp(final Instance instance) {
        try {
            NamingProxy.Request request = NamingProxy.Request.newRequest();
            request.appendParam("ip", instance.getIp()).appendParam("port", String.valueOf(instance.getPort())).appendParam("ephemeral", EPHEMERAL).appendParam("clusterName", instance.getClusterName()).appendParam("serviceName", this.service.getName()).appendParam("namespaceId", this.service.getNamespaceId());
            String url = "http://" + InternetAddressUtil.localHostIP() + ":" + EnvUtil.getPort() + EnvUtil.getContextPath() + "/v1/ns" + "/instance" + "?" + request.toUrl();
            HttpClient.asyncHttpDelete(url, null, null, new Callback<String>(){

                public void onReceive(RestResult<String> result) {
                    if (!result.ok()) {
                        Loggers.SRV_LOG.error("[IP-DEAD] failed to delete ip automatically, ip: {}, caused {}, resp code: {}", new Object[]{instance.toJson(), result.getMessage(), result.getCode()});
                    }
                }

                public void onError(Throwable throwable) {
                    Loggers.SRV_LOG.error("[IP-DEAD] failed to delete ip automatically, ip: {}, error: {}", (Object)instance.toJson(), (Object)throwable);
                }

                public void onCancel() {
                }
            });
        }
        catch (Exception e) {
            Loggers.SRV_LOG.error("[IP-DEAD] failed to delete ip automatically, ip: {}, error: {}", (Object)instance.toJson(), (Object)e);
        }
    }
}

