/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.index.ServiceStorage;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteAction;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteInstanceChangeToV2Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteMetadataChangeToV2Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.DoubleWriteServiceRemovalToV2Task;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.InstanceUpgradeHelper;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.ServiceMetadataUpgradeHelper;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.HashSet;
import java.util.List;

public class ServiceChangeV1Task
extends AbstractDelayTask {
    private final String namespace;
    private final String serviceName;
    private final boolean ephemeral;
    private DoubleWriteContent content;
    private DoubleWriteAction action;

    public ServiceChangeV1Task(String namespace, String serviceName, boolean ephemeral, DoubleWriteContent content) {
        this(namespace, serviceName, ephemeral, content, DoubleWriteAction.UPDATE);
    }

    public ServiceChangeV1Task(String namespace, String serviceName, boolean ephemeral, DoubleWriteContent content, DoubleWriteAction action) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.ephemeral = ephemeral;
        this.content = action == DoubleWriteAction.REMOVE ? DoubleWriteContent.BOTH : content;
        this.action = action;
        this.setLastProcessTime(System.currentTimeMillis());
        this.setTaskInterval(1000L);
    }

    public void merge(AbstractDelayTask task) {
        if (!(task instanceof ServiceChangeV1Task)) {
            return;
        }
        ServiceChangeV1Task oldTask = (ServiceChangeV1Task)task;
        if (!this.action.equals((Object)oldTask.getAction())) {
            this.action = DoubleWriteAction.REMOVE;
            this.content = DoubleWriteContent.BOTH;
            return;
        }
        if (!this.content.equals((Object)oldTask.getContent())) {
            this.content = DoubleWriteContent.BOTH;
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public DoubleWriteContent getContent() {
        return this.content;
    }

    public DoubleWriteAction getAction() {
        return this.action;
    }

    public static String getKey(String namespace, String serviceName, boolean ephemeral) {
        return "v1:" + namespace + "_" + serviceName + "_" + ephemeral;
    }

    public static class ServiceChangeV1TaskProcessor
    implements NacosTaskProcessor {
        public boolean process(NacosTask task) {
            ServiceChangeV1Task serviceTask = (ServiceChangeV1Task)task;
            if (serviceTask.getAction() == DoubleWriteAction.REMOVE) {
                Loggers.SRV_LOG.info("double write removal of service {}, ephemeral: {}", (Object)serviceTask.getServiceName(), (Object)serviceTask.isEphemeral());
                this.dispatchRemoveAllTask(serviceTask);
                return true;
            }
            Loggers.SRV_LOG.info("double write for service {}, ephemeral: {}, content {}", new Object[]{serviceTask.getServiceName(), serviceTask.isEphemeral(), serviceTask.getContent()});
            ServiceManager serviceManager = (ServiceManager)ApplicationUtils.getBean(ServiceManager.class);
            Service service = serviceManager.getService(serviceTask.getNamespace(), serviceTask.getServiceName());
            if (null != service) {
                switch (serviceTask.getContent()) {
                    case METADATA: {
                        this.dispatchMetadataTask(service, serviceTask.isEphemeral());
                        break;
                    }
                    case INSTANCE: {
                        this.dispatchInstanceTask(service, serviceTask.isEphemeral());
                        break;
                    }
                    default: {
                        this.dispatchAllTask(service, serviceTask.isEphemeral());
                    }
                }
            }
            return true;
        }

        private void dispatchRemoveAllTask(ServiceChangeV1Task serviceTask) {
            com.alibaba.nacos.naming.core.v2.pojo.Service serviceV2 = com.alibaba.nacos.naming.core.v2.pojo.Service.newService(serviceTask.getNamespace(), NamingUtils.getGroupName((String)serviceTask.getServiceName()), NamingUtils.getServiceName((String)serviceTask.getServiceName()), serviceTask.isEphemeral());
            DoubleWriteServiceRemovalToV2Task serviceRemovalTask = new DoubleWriteServiceRemovalToV2Task(serviceV2);
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(serviceV2.getName(), serviceRemovalTask);
        }

        private void dispatchAllTask(Service service, boolean ephemeral) {
            this.dispatchMetadataTask(service, ephemeral);
            this.dispatchInstanceTask(service, ephemeral);
        }

        private void dispatchInstanceTask(Service service, boolean ephemeral) {
            DoubleWriteInstanceChangeToV2Task instanceTask;
            ServiceStorage serviceStorage = (ServiceStorage)ApplicationUtils.getBean(ServiceStorage.class);
            InstanceUpgradeHelper instanceUpgradeHelper = (InstanceUpgradeHelper)ApplicationUtils.getBean(InstanceUpgradeHelper.class);
            ServiceInfo serviceInfo = serviceStorage.getPushData(this.transfer(service, ephemeral));
            List<Instance> newInstance = service.allIPs(ephemeral);
            HashSet<String> instances = new HashSet<String>();
            for (Instance each : newInstance) {
                instances.add(each.toIpAddr());
                com.alibaba.nacos.api.naming.pojo.Instance instance = instanceUpgradeHelper.toV2(each);
                instance.setEphemeral(ephemeral);
                instanceTask = new DoubleWriteInstanceChangeToV2Task(service.getNamespaceId(), service.getName(), instance, true);
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(IpPortBasedClient.getClientId(each.toIpAddr(), ephemeral), instanceTask);
            }
            List oldInstance = serviceInfo.getHosts();
            for (com.alibaba.nacos.api.naming.pojo.Instance each : oldInstance) {
                if (instances.contains(each.toInetAddr())) continue;
                instanceTask = new DoubleWriteInstanceChangeToV2Task(service.getNamespaceId(), service.getName(), each, false);
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(IpPortBasedClient.getClientId(each.toInetAddr(), ephemeral), instanceTask);
            }
        }

        private com.alibaba.nacos.naming.core.v2.pojo.Service transfer(Service service, boolean ephemeral) {
            return com.alibaba.nacos.naming.core.v2.pojo.Service.newService(service.getNamespaceId(), NamingUtils.getGroupName((String)service.getName()), NamingUtils.getServiceName((String)service.getName()), ephemeral);
        }

        private void dispatchMetadataTask(Service service, boolean ephemeral) {
            ServiceMetadataUpgradeHelper upgradeHelper = (ServiceMetadataUpgradeHelper)ApplicationUtils.getBean(ServiceMetadataUpgradeHelper.class);
            ServiceMetadata serviceMetadata = upgradeHelper.toV2ServiceMetadata(service, ephemeral);
            DoubleWriteMetadataChangeToV2Task metadataTask = new DoubleWriteMetadataChangeToV2Task(service.getNamespaceId(), service.getName(), ephemeral, serviceMetadata);
            NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(service.getName(), metadataTask);
        }
    }
}

