/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.metadata;

import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.consistency.SerializeFactory;
import com.alibaba.nacos.consistency.Serializer;
import com.alibaba.nacos.consistency.cp.CPProtocol;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.core.distributed.ProtocolManager;
import com.alibaba.nacos.naming.core.v2.metadata.ClusterMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.metadata.MetadataOperation;
import com.alibaba.nacos.naming.core.v2.metadata.ServiceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.google.protobuf.ByteString;
import org.springframework.stereotype.Component;

@Component
public class NamingMetadataOperateService {
    private final CPProtocol cpProtocol;
    private final Serializer serializer;

    public NamingMetadataOperateService(ProtocolManager protocolManager) {
        this.cpProtocol = protocolManager.getCpProtocol();
        this.serializer = SerializeFactory.getDefault();
    }

    public void updateServiceMetadata(Service service, ServiceMetadata serviceMetadata) {
        MetadataOperation<ServiceMetadata> operation = this.buildMetadataOperation(service);
        operation.setMetadata(serviceMetadata);
        WriteRequest operationLog = WriteRequest.newBuilder().setGroup("naming_service_metadata").setOperation(DataOperation.CHANGE.name()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(operation))).build();
        this.submitMetadataOperation(operationLog);
    }

    public void deleteServiceMetadata(Service service) {
        MetadataOperation operation = this.buildMetadataOperation(service);
        WriteRequest operationLog = WriteRequest.newBuilder().setGroup("naming_service_metadata").setOperation(DataOperation.DELETE.name()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(operation))).build();
        this.submitMetadataOperation(operationLog);
    }

    public void updateInstanceMetadata(Service service, String metadataId, InstanceMetadata instanceMetadata) {
        MetadataOperation<InstanceMetadata> operation = this.buildMetadataOperation(service);
        operation.setTag(metadataId);
        operation.setMetadata(instanceMetadata);
        WriteRequest operationLog = WriteRequest.newBuilder().setGroup("naming_instance_metadata").setOperation(DataOperation.CHANGE.name()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(operation))).build();
        this.submitMetadataOperation(operationLog);
    }

    public void deleteInstanceMetadata(Service service, String metadataId) {
        MetadataOperation operation = this.buildMetadataOperation(service);
        operation.setTag(metadataId);
        WriteRequest operationLog = WriteRequest.newBuilder().setGroup("naming_instance_metadata").setOperation(DataOperation.DELETE.name()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(operation))).build();
        this.submitMetadataOperation(operationLog);
    }

    public void addClusterMetadata(Service service, String clusterName, ClusterMetadata clusterMetadata) {
        MetadataOperation<ServiceMetadata> operation = this.buildMetadataOperation(service);
        ServiceMetadata serviceMetadata = new ServiceMetadata();
        serviceMetadata.setEphemeral(service.isEphemeral());
        serviceMetadata.getClusters().put(clusterName, clusterMetadata);
        operation.setMetadata(serviceMetadata);
        WriteRequest operationLog = WriteRequest.newBuilder().setGroup("naming_service_metadata").setOperation(DataOperation.ADD.name()).setData(ByteString.copyFrom((byte[])this.serializer.serialize(operation))).build();
        this.submitMetadataOperation(operationLog);
    }

    private <T> MetadataOperation<T> buildMetadataOperation(Service service) {
        MetadataOperation result = new MetadataOperation();
        result.setNamespace(service.getNamespace());
        result.setGroup(service.getGroup());
        result.setServiceName(service.getName());
        return result;
    }

    private void submitMetadataOperation(WriteRequest operationLog) {
        try {
            Response response = this.cpProtocol.write(operationLog);
            if (!response.getSuccess()) {
                throw new NacosRuntimeException(500, "do metadata operation failed " + response.getErrMsg());
            }
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, "do metadata operation failed", (Throwable)e);
        }
    }
}

