/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.RecordListener;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftConsistencyServiceImpl;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.pojo.Record;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@RequestMapping(value={"/v1/ns/raft", "/nacos/v1/ns/raft"})
public class RaftController {
    private final RaftConsistencyServiceImpl raftConsistencyService;
    private final ServiceManager serviceManager;
    private final RaftCore raftCore;
    private final ClusterVersionJudgement versionJudgement;

    public RaftController(RaftConsistencyServiceImpl raftConsistencyService, ServiceManager serviceManager, RaftCore raftCore, ClusterVersionJudgement versionJudgement) {
        this.raftConsistencyService = raftConsistencyService;
        this.serviceManager = serviceManager;
        this.raftCore = raftCore;
        this.versionJudgement = versionJudgement;
    }

    @PostMapping(value={"/vote"})
    public JsonNode vote(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        RaftPeer peer = this.raftCore.receivedVote((RaftPeer)JacksonUtils.toObj((String)WebUtils.required((HttpServletRequest)request, (String)"vote"), RaftPeer.class));
        return JacksonUtils.transferToJsonNode((Object)peer);
    }

    @PostMapping(value={"/beat"})
    public JsonNode beat(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        String entity = new String(IoUtils.tryDecompress((InputStream)request.getInputStream()), StandardCharsets.UTF_8);
        String value = URLDecoder.decode(entity, "UTF-8");
        value = URLDecoder.decode(value, "UTF-8");
        JsonNode json = JacksonUtils.toObj((String)value);
        RaftPeer peer = this.raftCore.receivedBeat(JacksonUtils.toObj((String)json.get("beat").asText()));
        return JacksonUtils.transferToJsonNode((Object)peer);
    }

    @GetMapping(value={"/peer"})
    public JsonNode getPeer(HttpServletRequest request, HttpServletResponse response) {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        List<RaftPeer> peers = this.raftCore.getPeers();
        RaftPeer peer = null;
        for (RaftPeer peer1 : peers) {
            if (!StringUtils.equals((String)peer1.ip, (String)NetUtils.localServer())) continue;
            peer = peer1;
        }
        if (peer == null) {
            peer = new RaftPeer();
            peer.ip = NetUtils.localServer();
        }
        return JacksonUtils.transferToJsonNode(peer);
    }

    @PutMapping(value={"/datum/reload"})
    public String reloadDatum(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        String key = WebUtils.required((HttpServletRequest)request, (String)"key");
        this.raftCore.loadDatum(key);
        return "ok";
    }

    @PostMapping(value={"/datum"})
    public String publish(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        String entity = IoUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        String value = URLDecoder.decode(entity, "UTF-8");
        JsonNode json = JacksonUtils.toObj((String)value);
        String key = json.get("key").asText();
        if (KeyBuilder.matchInstanceListKey(key)) {
            this.raftConsistencyService.put(key, (Record)JacksonUtils.toObj((String)json.get("value").toString(), Instances.class));
            return "ok";
        }
        if (KeyBuilder.matchSwitchKey(key)) {
            this.raftConsistencyService.put(key, (Record)JacksonUtils.toObj((String)json.get("value").toString(), SwitchDomain.class));
            return "ok";
        }
        if (KeyBuilder.matchServiceMetaKey(key)) {
            this.raftConsistencyService.put(key, (Record)JacksonUtils.toObj((String)json.get("value").toString(), Service.class));
            return "ok";
        }
        throw new NacosException(400, "unknown type publish key: " + key);
    }

    @DeleteMapping(value={"/datum"})
    public String delete(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        this.raftConsistencyService.remove(WebUtils.required((HttpServletRequest)request, (String)"key"));
        return "ok";
    }

    @GetMapping(value={"/datum"})
    public String get(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        String keysString = WebUtils.required((HttpServletRequest)request, (String)"keys");
        keysString = URLDecoder.decode(keysString, "UTF-8");
        String[] keys = keysString.split(",");
        ArrayList datums = new ArrayList();
        for (String key : keys) {
            Datum<?> datum = this.raftCore.getDatum(key);
            datums.add(datum);
        }
        return JacksonUtils.toJson(datums);
    }

    @GetMapping(value={"/state"})
    public JsonNode state(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("services", this.serviceManager.getServiceCount());
        result.replace("peers", JacksonUtils.transferToJsonNode(this.raftCore.getPeers()));
        return result;
    }

    @PostMapping(value={"/datum/commit"})
    public String onPublish(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        String entity = IoUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        String value = URLDecoder.decode(entity, "UTF-8");
        JsonNode jsonObject = JacksonUtils.toObj((String)value);
        String key = "key";
        RaftPeer source = (RaftPeer)JacksonUtils.toObj((String)jsonObject.get("source").toString(), RaftPeer.class);
        JsonNode datumJson = jsonObject.get("datum");
        Datum datum = null;
        if (KeyBuilder.matchInstanceListKey(datumJson.get(key).asText())) {
            datum = (Datum)JacksonUtils.toObj((String)jsonObject.get("datum").toString(), (TypeReference)new TypeReference<Datum<Instances>>(){});
        } else if (KeyBuilder.matchSwitchKey(datumJson.get(key).asText())) {
            datum = (Datum)JacksonUtils.toObj((String)jsonObject.get("datum").toString(), (TypeReference)new TypeReference<Datum<SwitchDomain>>(){});
        } else if (KeyBuilder.matchServiceMetaKey(datumJson.get(key).asText())) {
            datum = (Datum)JacksonUtils.toObj((String)jsonObject.get("datum").toString(), (TypeReference)new TypeReference<Datum<Service>>(){});
        }
        this.raftConsistencyService.onPut(datum, source);
        return "ok";
    }

    @DeleteMapping(value={"/datum/commit"})
    public String onDelete(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        response.setHeader("Content-Type", "application/json; charset=" + RaftController.getAcceptEncoding(request));
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Encode", "gzip");
        String entity = IoUtils.toString((InputStream)request.getInputStream(), (String)"UTF-8");
        String value = URLDecoder.decode(entity, "UTF-8");
        value = URLDecoder.decode(value, "UTF-8");
        JsonNode jsonObject = JacksonUtils.toObj((String)value);
        Datum datum = (Datum)JacksonUtils.toObj((String)jsonObject.get("datum").toString(), Datum.class);
        RaftPeer source = (RaftPeer)JacksonUtils.toObj((String)jsonObject.get("source").toString(), RaftPeer.class);
        this.raftConsistencyService.onRemove(datum, source);
        return "ok";
    }

    @GetMapping(value={"/leader"})
    public JsonNode getLeader(HttpServletRequest request, HttpServletResponse response) {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("leader", JacksonUtils.toJson((Object)this.raftCore.getLeader()));
        return result;
    }

    @GetMapping(value={"/listeners"})
    public JsonNode getAllListeners(HttpServletRequest request, HttpServletResponse response) {
        if (this.versionJudgement.allMemberIsNewVersion()) {
            throw new IllegalStateException("old raft protocol already stop");
        }
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        Map<String, ConcurrentHashSet<RecordListener>> listeners = this.raftCore.getListeners();
        ArrayNode listenerArray = JacksonUtils.createEmptyArrayNode();
        for (String key : listeners.keySet()) {
            listenerArray.add(key);
        }
        result.replace("listeners", (JsonNode)listenerArray);
        return result;
    }

    public static String getAcceptEncoding(HttpServletRequest req) {
        String encode = StringUtils.defaultIfEmpty((String)req.getHeader("Accept-Charset"), (String)"UTF-8");
        encode = encode.contains(",") ? encode.substring(0, encode.indexOf(",")) : encode;
        return encode.contains(";") ? encode.substring(0, encode.indexOf(";")) : encode;
    }
}

