/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.combined;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.DistroConfig;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.core.distributed.distro.task.delay.DistroDelayTaskExecuteEngine;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKey;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKeyDelayTask;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.Loggers;

public class DistroHttpCombinedKeyExecuteTask
extends AbstractExecuteTask {
    private final GlobalConfig globalConfig;
    private final DistroDelayTaskExecuteEngine distroDelayTaskExecuteEngine;
    private final DistroKey singleDistroKey;
    private final DataOperation taskAction;

    public DistroHttpCombinedKeyExecuteTask(GlobalConfig globalConfig, DistroDelayTaskExecuteEngine distroDelayTaskExecuteEngine, DistroKey singleDistroKey, DataOperation taskAction) {
        this.globalConfig = globalConfig;
        this.distroDelayTaskExecuteEngine = distroDelayTaskExecuteEngine;
        this.singleDistroKey = singleDistroKey;
        this.taskAction = taskAction;
    }

    public void run() {
        try {
            DistroKey newKey = new DistroKey(DistroHttpCombinedKey.getSequenceKey(), DistroHttpCombinedKeyDelayTask.class.getSimpleName(), this.singleDistroKey.getTargetServer());
            DistroHttpCombinedKeyDelayTask combinedTask = new DistroHttpCombinedKeyDelayTask(newKey, this.taskAction, DistroConfig.getInstance().getSyncDelayMillis(), this.globalConfig.getBatchSyncKeyCount());
            combinedTask.getActualResourceKeys().add(this.singleDistroKey.getResourceKey());
            this.distroDelayTaskExecuteEngine.addTask((Object)newKey, (AbstractDelayTask)combinedTask);
        }
        catch (Exception e) {
            Loggers.DISTRO.error("[DISTRO-FAILED] Combined key for http failed. ", (Throwable)e);
        }
    }
}

