/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.naming.pojo;

import com.alibaba.nacos.api.common.Constants;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Instance
implements Serializable {
    private static final long serialVersionUID = -742906310567291979L;
    private String instanceId;
    private String ip;
    private int port;
    private double weight = 1.0;
    private boolean healthy = true;
    private boolean enabled = true;
    private boolean ephemeral = true;
    private String clusterName;
    private String serviceName;
    private Map<String, String> metadata = new HashMap<String, String>();

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public void addMetadata(String key, String value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>(4);
        }
        this.metadata.put(key, value);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public String toString() {
        return "Instance{instanceId='" + this.instanceId + '\'' + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", weight=" + this.weight + ", healthy=" + this.healthy + ", enabled=" + this.enabled + ", ephemeral=" + this.ephemeral + ", clusterName='" + this.clusterName + '\'' + ", serviceName='" + this.serviceName + '\'' + ", metadata=" + this.metadata + '}';
    }

    public String toInetAddr() {
        return this.ip + ":" + this.port;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance host = (Instance)obj;
        return Instance.strEquals(host.toString(), this.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private static boolean strEquals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public long getInstanceHeartBeatInterval() {
        return this.getMetaDataByKeyWithDefault("preserved.heart.beat.interval", Constants.DEFAULT_HEART_BEAT_INTERVAL);
    }

    public long getInstanceHeartBeatTimeOut() {
        return this.getMetaDataByKeyWithDefault("preserved.heart.beat.timeout", Constants.DEFAULT_HEART_BEAT_TIMEOUT);
    }

    public long getIpDeleteTimeout() {
        return this.getMetaDataByKeyWithDefault("preserved.ip.delete.timeout", Constants.DEFAULT_IP_DELETE_TIMEOUT);
    }

    public String getInstanceIdGenerator() {
        return this.getMetaDataByKeyWithDefault("preserved.instance.id.generator", "simple");
    }

    public boolean containsMetadata(String key) {
        if (this.getMetadata() == null || this.getMetadata().isEmpty()) {
            return false;
        }
        return this.getMetadata().containsKey(key);
    }

    private long getMetaDataByKeyWithDefault(String key, long defaultValue) {
        if (this.getMetadata() == null || this.getMetadata().isEmpty()) {
            return defaultValue;
        }
        String value = this.getMetadata().get(key);
        if (NamingUtils.isNumber(value)) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    private String getMetaDataByKeyWithDefault(String key, String defaultValue) {
        if (this.getMetadata() == null || this.getMetadata().isEmpty()) {
            return defaultValue;
        }
        return this.getMetadata().get(key);
    }
}

