/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import video.pano.CapturerObserver;
import video.pano.MediaSource;
import video.pano.NativeCapturerObserver;

public class VideoSource
extends MediaSource {
    private final NativeCapturerObserver capturerObserver;

    public VideoSource(long nativeSource) {
        super(nativeSource);
        this.capturerObserver = new NativeCapturerObserver(VideoSource.nativeGetInternalSource(nativeSource));
    }

    public void adaptOutputFormat(int width, int height, int fps) {
        int maxSide = Math.max(width, height);
        int minSide = Math.min(width, height);
        this.adaptOutputFormat(maxSide, minSide, minSide, maxSide, fps);
    }

    public void adaptOutputFormat(int landscapeWidth, int landscapeHeight, int portraitWidth, int portraitHeight, int fps) {
        VideoSource.nativeAdaptOutputFormat(this.getNativeVideoTrackSource(), landscapeWidth, landscapeHeight, portraitWidth, portraitHeight, fps);
    }

    public CapturerObserver getCapturerObserver() {
        return this.capturerObserver;
    }

    long getNativeVideoTrackSource() {
        return this.getNativeMediaSource();
    }

    private static native long nativeGetInternalSource(long var0);

    private static native void nativeAdaptOutputFormat(long var0, int var2, int var3, int var4, int var5, int var6);
}

