/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import java.util.ArrayList;
import java.util.HashMap;
import video.pano.LibH264Encoder;
import video.pano.LibvpxVp8Encoder;
import video.pano.LibvpxVp9Encoder;
import video.pano.VideoCodecInfo;
import video.pano.VideoEncoder;
import video.pano.VideoEncoderFactory;

public class SoftwareVideoEncoderFactory
implements VideoEncoderFactory {
    @Override
    public VideoEncoder createEncoder(VideoCodecInfo info) {
        if (info.name.equalsIgnoreCase("VP8")) {
            return new LibvpxVp8Encoder();
        }
        if (info.name.equalsIgnoreCase("VP9") && LibvpxVp9Encoder.nativeIsSupported()) {
            return new LibvpxVp9Encoder();
        }
        if (info.name.equalsIgnoreCase("H264") && LibH264Encoder.nativeIsSupported()) {
            return new LibH264Encoder();
        }
        return null;
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        return SoftwareVideoEncoderFactory.supportedCodecs();
    }

    static VideoCodecInfo[] supportedCodecs() {
        ArrayList<VideoCodecInfo> codecs = new ArrayList<VideoCodecInfo>();
        codecs.add(new VideoCodecInfo("VP8", new HashMap<String, String>()));
        if (LibvpxVp9Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("VP9", new HashMap<String, String>()));
        }
        if (LibH264Encoder.nativeIsSupported()) {
            codecs.add(new VideoCodecInfo("H264", new HashMap<String, String>()));
        }
        return codecs.toArray(new VideoCodecInfo[codecs.size()]);
    }
}

