/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import java.util.concurrent.atomic.AtomicInteger;
import video.pano.RefCounted;

class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final Runnable releaseCallback;

    public RefCountDelegate(Runnable releaseCallback) {
        this.releaseCallback = releaseCallback;
    }

    @Override
    public void retain() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.refCount.decrementAndGet() == 0 && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }
}

