/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.media.MediaCodecInfo;
import android.os.Build;
import java.util.HashMap;
import java.util.Map;
import video.pano.H264Utils;
import video.pano.VideoCodecType;

class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String MTK_PREFIX = "OMX.MTK.";
    static final String IMG_PREFIX = "OMX.IMG.TOPAZ.";
    static final String HISI_PREFIX = "OMX.hisi.";
    static final String K3_PREFIX = "OMX.k3.";
    static final String AMLOGIC_PREFIX = "OMX.amlogic.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String RK_PREFIX = "OMX.rk.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int[] DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    static Integer selectColorFormat(String name, int[] supportedColorFormats, MediaCodecInfo.CodecCapabilities capabilities) {
        boolean YUV420SemiPlanarOk = false;
        for (int colorFormat : capabilities.colorFormats) {
            if (21 != colorFormat) continue;
            YUV420SemiPlanarOk = true;
        }
        for (int supportedColorFormat : supportedColorFormats) {
            for (int codecColorFormat : capabilities.colorFormats) {
                if (codecColorFormat != supportedColorFormat) continue;
                if (codecColorFormat == 19 && YUV420SemiPlanarOk && (name.startsWith(IMG_PREFIX) || name.startsWith(HISI_PREFIX) || name.startsWith(K3_PREFIX))) {
                    codecColorFormat = 21;
                }
                return codecColorFormat;
            }
        }
        return null;
    }

    static boolean codecSupportsType(MediaCodecInfo info, VideoCodecType type) {
        for (String mimeType : info.getSupportedTypes()) {
            if (!type.mimeType().equals(mimeType)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecType type, boolean highProfile) {
        switch (type) {
            case VP8: 
            case VP9: {
                return new HashMap<String, String>();
            }
            case H264: {
                return H264Utils.getDefaultH264Params(highProfile);
            }
        }
        throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)type));
    }

    private MediaCodecUtils() {
    }
}

