/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.hardware.Camera;
import android.os.SystemClock;
import java.util.ArrayList;
import java.util.List;
import video.pano.Camera1Capturer;
import video.pano.CameraEnumerationAndroid;
import video.pano.CameraEnumerator;
import video.pano.CameraVideoCapturer;
import video.pano.Logging;
import video.pano.Size;

public class Camera1Enumerator
implements CameraEnumerator {
    private static final String TAG = "Camera1Enumerator";
    private static List<CameraEnumerationAndroid.CameraSettings> cachedCameraSettings;
    private final boolean captureToTexture;

    public Camera1Enumerator() {
        this(true);
    }

    public Camera1Enumerator(boolean captureToTexture) {
        this.captureToTexture = captureToTexture;
    }

    @Override
    public String[] getDeviceNames() {
        ArrayList<String> namesList = new ArrayList<String>();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            String name = Camera1Enumerator.getDeviceName(i);
            if (name != null) {
                namesList.add(name);
                Logging.d(TAG, "Index: " + i + ". " + name);
                continue;
            }
            Logging.e(TAG, "Index: " + i + ". Failed to query camera name.");
        }
        String[] namesArray = new String[namesList.size()];
        return namesList.toArray(namesArray);
    }

    @Override
    public boolean isFrontFacing(String deviceName) {
        Camera.CameraInfo info = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(deviceName));
        return info != null && info.facing == 1;
    }

    @Override
    public boolean isBackFacing(String deviceName) {
        Camera.CameraInfo info = Camera1Enumerator.getCameraInfo(Camera1Enumerator.getCameraIndex(deviceName));
        return info != null && info.facing == 0;
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(String deviceName) {
        CameraEnumerationAndroid.CameraSettings settings = Camera1Enumerator.getCameraSettings(Camera1Enumerator.getCameraIndex(deviceName));
        if (settings == null) {
            return new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        }
        return settings.captureFormats;
    }

    @Override
    public CameraEnumerationAndroid.CameraSettings getCameraSettings(String deviceName) {
        return Camera1Enumerator.getCameraSettings(Camera1Enumerator.getCameraIndex(deviceName));
    }

    @Override
    public CameraVideoCapturer createCapturer(String deviceName, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return new Camera1Capturer(deviceName, eventsHandler, this.captureToTexture);
    }

    private static Camera.CameraInfo getCameraInfo(int index) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)info);
        }
        catch (Exception e) {
            Logging.e(TAG, "getCameraInfo failed on index " + index, e);
            return null;
        }
        return info;
    }

    static synchronized CameraEnumerationAndroid.CameraSettings getCameraSettings(int cameraId) {
        CameraEnumerationAndroid.CameraSettings settings;
        boolean newCache = false;
        if (cachedCameraSettings == null) {
            newCache = true;
            cachedCameraSettings = new ArrayList<CameraEnumerationAndroid.CameraSettings>();
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                cachedCameraSettings.add(Camera1Enumerator.enumerateSettings(i));
            }
        }
        if ((settings = cachedCameraSettings.get(cameraId)) == null && !newCache) {
            settings = Camera1Enumerator.enumerateSettings(cameraId);
            cachedCameraSettings.set(cameraId, settings);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CameraEnumerationAndroid.CameraSettings enumerateSettings(int cameraId) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported camera settings for camera index " + cameraId + ".");
        long startTimeMs = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.d(TAG, "Opening camera with index " + cameraId);
            camera = Camera.open((int)cameraId);
            parameters = camera.getParameters();
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Open camera failed on camera index " + cameraId, e);
            CameraEnumerationAndroid.CameraSettings cameraSettings = new CameraEnumerationAndroid.CameraSettings();
            return cameraSettings;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        CameraEnumerationAndroid.CameraSettings settings = new CameraEnumerationAndroid.CameraSettings();
        try {
            int minFps = 0;
            int maxFps = 0;
            List listFpsRange = parameters.getSupportedPreviewFpsRange();
            if (listFpsRange != null) {
                int[] range = (int[])listFpsRange.get(listFpsRange.size() - 1);
                minFps = range[0];
                maxFps = range[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                settings.captureFormats.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, minFps, maxFps));
            }
            settings.maxExposureCompensation = parameters.getMaxExposureCompensation();
            settings.minExposureCompensation = parameters.getMinExposureCompensation();
            settings.exposureCompensationStep = parameters.getExposureCompensationStep();
            settings.isZoomSupported = parameters.isZoomSupported();
            if (settings.isZoomSupported) {
                settings.maxZoom = parameters.getMaxZoom();
                settings.minZoom = 1.0f;
            }
        }
        catch (Exception e) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + cameraId, e);
        }
        long endTimeMs = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + cameraId + " done. Time spent: " + (endTimeMs - startTimeMs) + " ms.");
        return settings;
    }

    static List<Size> convertSizes(List<Camera.Size> cameraSizes) {
        ArrayList<Size> sizes = new ArrayList<Size>();
        for (Camera.Size size : cameraSizes) {
            sizes.add(new Size(size.width, size.height));
        }
        return sizes;
    }

    static List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> convertFramerates(List<int[]> arrayRanges) {
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> ranges = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        for (int[] range : arrayRanges) {
            ranges.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(range[0], range[1]));
        }
        return ranges;
    }

    static int getCameraIndex(String deviceName) {
        Logging.d(TAG, "getCameraIndex: " + deviceName);
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            if (!deviceName.equals(Camera1Enumerator.getDeviceName(i))) continue;
            return i;
        }
        throw new IllegalArgumentException("No such camera: " + deviceName);
    }

    static String getDeviceName(int index) {
        Camera.CameraInfo info = Camera1Enumerator.getCameraInfo(index);
        if (info == null) {
            return null;
        }
        String facing = info.facing == 1 ? "front" : "back";
        return "Camera " + index + ", Facing " + facing + ", Orientation " + info.orientation;
    }
}

