/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageVignetteFilter
extends GPUImageFilter {
    public static final String VIGNETTING_FRAGMENT_SHADER = " uniform sampler2D inputImageTexture;\n varying highp vec2 textureCoordinate;\n \n uniform lowp vec2 vignetteCenter;\n uniform lowp vec3 vignetteColor;\n uniform highp float vignetteStart;\n uniform highp float vignetteEnd;\n \n void main()\n {\n     /*\n     lowp vec3 rgb = texture2D(inputImageTexture, textureCoordinate).rgb;\n     lowp float d = distance(textureCoordinate, vec2(0.5,0.5));\n     rgb *= (1.0 - smoothstep(vignetteStart, vignetteEnd, d));\n     gl_FragColor = vec4(vec3(rgb),1.0);\n      */\n     \n     lowp vec3 rgb = texture2D(inputImageTexture, textureCoordinate).rgb;\n     lowp float d = distance(textureCoordinate, vec2(vignetteCenter.x, vignetteCenter.y));\n     lowp float percent = smoothstep(vignetteStart, vignetteEnd, d);\n     gl_FragColor = vec4(mix(rgb.x, vignetteColor.x, percent), mix(rgb.y, vignetteColor.y, percent), mix(rgb.z, vignetteColor.z, percent), 1.0);\n }";
    private int vignetteCenterLocation;
    private PointF vignetteCenter;
    private int vignetteColorLocation;
    private float[] vignetteColor;
    private int vignetteStartLocation;
    private float vignetteStart;
    private int vignetteEndLocation;
    private float vignetteEnd;

    public GPUImageVignetteFilter() {
        this(new PointF(), new float[]{0.0f, 0.0f, 0.0f}, 0.3f, 0.75f);
    }

    public GPUImageVignetteFilter(PointF vignetteCenter, float[] vignetteColor, float vignetteStart, float vignetteEnd) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", VIGNETTING_FRAGMENT_SHADER);
        this.vignetteCenter = vignetteCenter;
        this.vignetteColor = vignetteColor;
        this.vignetteStart = vignetteStart;
        this.vignetteEnd = vignetteEnd;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.vignetteCenterLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vignetteCenter");
        this.vignetteColorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vignetteColor");
        this.vignetteStartLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vignetteStart");
        this.vignetteEndLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"vignetteEnd");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setVignetteCenter(this.vignetteCenter);
        this.setVignetteColor(this.vignetteColor);
        this.setVignetteStart(this.vignetteStart);
        this.setVignetteEnd(this.vignetteEnd);
    }

    public void setVignetteCenter(PointF vignetteCenter) {
        this.vignetteCenter = vignetteCenter;
        this.setPoint(this.vignetteCenterLocation, this.vignetteCenter);
    }

    public void setVignetteColor(float[] vignetteColor) {
        this.vignetteColor = vignetteColor;
        this.setFloatVec3(this.vignetteColorLocation, this.vignetteColor);
    }

    public void setVignetteStart(float vignetteStart) {
        this.vignetteStart = vignetteStart;
        this.setFloat(this.vignetteStartLocation, this.vignetteStart);
    }

    public void setVignetteEnd(float vignetteEnd) {
        this.vignetteEnd = vignetteEnd;
        this.setFloat(this.vignetteEndLocation, this.vignetteEnd);
    }
}

