/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageSolarizeFilter
extends GPUImageFilter {
    public static final String SOLATIZE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform highp float threshold;\n\nconst highp vec3 W = vec3(0.2125, 0.7154, 0.0721);\n\nvoid main()\n{\n    highp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n    highp float luminance = dot(textureColor.rgb, W);\n    highp float thresholdResult = step(luminance, threshold);\n    highp vec3 finalColor = abs(thresholdResult - textureColor.rgb);\n    \n    gl_FragColor = vec4(finalColor, textureColor.w);\n}";
    private int uniformThresholdLocation;
    private float threshold;

    public GPUImageSolarizeFilter() {
        this(0.5f);
    }

    public GPUImageSolarizeFilter(float threshold) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", SOLATIZE_FRAGMENT_SHADER);
        this.threshold = threshold;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.uniformThresholdLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"threshold");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setThreshold(this.threshold);
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
        this.setFloat(this.uniformThresholdLocation, threshold);
    }
}

