/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageMonochromeFilter
extends GPUImageFilter {
    public static final String MONOCHROME_FRAGMENT_SHADER = " precision lowp float;\n  \n  varying highp vec2 textureCoordinate;\n  \n  uniform sampler2D inputImageTexture;\n  uniform float intensity;\n  uniform vec3 filterColor;\n  \n  const mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n  \n  void main()\n  {\n \t//desat, then apply overlay blend\n \tlowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n \tfloat luminance = dot(textureColor.rgb, luminanceWeighting);\n \t\n \tlowp vec4 desat = vec4(vec3(luminance), 1.0);\n \t\n \t//overlay\n \tlowp vec4 outputColor = vec4(\n                                  (desat.r < 0.5 ? (2.0 * desat.r * filterColor.r) : (1.0 - 2.0 * (1.0 - desat.r) * (1.0 - filterColor.r))),\n                                  (desat.g < 0.5 ? (2.0 * desat.g * filterColor.g) : (1.0 - 2.0 * (1.0 - desat.g) * (1.0 - filterColor.g))),\n                                  (desat.b < 0.5 ? (2.0 * desat.b * filterColor.b) : (1.0 - 2.0 * (1.0 - desat.b) * (1.0 - filterColor.b))),\n                                  1.0\n                                  );\n \t\n \t//which is better, or are they equal?\n \tgl_FragColor = vec4( mix(textureColor.rgb, outputColor.rgb, intensity), textureColor.a);\n  }";
    private int intensityLocation;
    private float intensity;
    private int filterColorLocation;
    private float[] color;

    public GPUImageMonochromeFilter() {
        this(1.0f, new float[]{0.6f, 0.45f, 0.3f, 1.0f});
    }

    public GPUImageMonochromeFilter(float intensity, float[] color) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", MONOCHROME_FRAGMENT_SHADER);
        this.intensity = intensity;
        this.color = color;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.intensityLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"intensity");
        this.filterColorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"filterColor");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setIntensity(1.0f);
        this.setColor(new float[]{0.6f, 0.45f, 0.3f, 1.0f});
    }

    public void setIntensity(float intensity) {
        this.intensity = intensity;
        this.setFloat(this.intensityLocation, this.intensity);
    }

    public void setColor(float[] color) {
        this.color = color;
        this.setColor(this.color[0], this.color[1], this.color[2]);
    }

    public void setColor(float red, float green, float blue) {
        this.setFloatVec3(this.filterColorLocation, new float[]{red, green, blue});
    }
}

