/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.impl.screen;

import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.nio.ByteBuffer;
import video.pano.CapturerObserver;
import video.pano.EglBase;
import video.pano.ScreenCapturerAndroid;
import video.pano.SurfaceTextureHelper;
import video.pano.VideoCapturer;
import video.pano.VideoFrame;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.impl.GlobalRef;

public class ScreenCapturer {
    public static Intent screenCaptureIntent;
    private final long nativeHandle;
    private VideoCapturer capturer;
    private int maxWidth;
    private int maxHeight;
    private int captureFps;
    private int captureWidth;
    private int captureHeight;
    private Status status = Status.IDLE;
    private int lastRotation;
    private final Display display;

    public ScreenCapturer(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.display = ((WindowManager)GlobalRef.applicationContext.getSystemService("window")).getDefaultDisplay();
    }

    @CalledByNative
    public int start() {
        if (Build.VERSION.SDK_INT < 21) {
            return -9;
        }
        if (this.status == Status.RUNNING) {
            return -4;
        }
        this.lastRotation = this.display.getRotation();
        this.capturer = new ScreenCapturerAndroid(screenCaptureIntent, new MediaProjection.Callback(){

            public void onStop() {
                ScreenCapturer.this.capturer = null;
            }
        });
        EglBase.Context eglBaseContext = EglBase.create().getEglBaseContext();
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create((String)"PanoCaptureThread", (EglBase.Context)eglBaseContext);
        this.capturer.initialize(surfaceTextureHelper, GlobalRef.applicationContext, new CapturerObserver(){

            public void onCapturerStarted(boolean success) {
                ScreenCapturer.nativeCapturerStarted(ScreenCapturer.this.nativeHandle, success);
            }

            public void onCapturerStopped() {
                ScreenCapturer.nativeCapturerStopped(ScreenCapturer.this.nativeHandle);
            }

            public void onFrameCaptured(VideoFrame videoFrame) {
                if (ScreenCapturer.this.status != Status.RUNNING) {
                    return;
                }
                ScreenCapturer.this.checkRotationChange();
                VideoFrame.Buffer buffer = videoFrame.getBuffer();
                VideoFrame.I420Buffer i420Buffer = buffer.toI420();
                ByteBuffer[] byteBuffers = new ByteBuffer[]{i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV()};
                ImageFormat imageFormat = new ImageFormat();
                imageFormat.pxfmt = 8;
                imageFormat.width = videoFrame.getBuffer().getWidth();
                imageFormat.height = videoFrame.getBuffer().getHeight();
                int[] strides = new int[]{i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV()};
                imageFormat.stride = strides;
                ScreenCapturer.nativeOnFrameCaptured(ScreenCapturer.this.nativeHandle, byteBuffers, imageFormat, 0L);
                i420Buffer.release();
            }
        });
        this.getCaptureSize();
        this.capturer.startCapture(this.captureWidth, this.captureHeight, this.captureFps);
        this.status = Status.RUNNING;
        return 0;
    }

    private void checkRotationChange() {
        int currentRotation = this.display.getRotation();
        if ((currentRotation + this.lastRotation) % 2 == 1) {
            this.getCaptureSize();
            this.capturer.changeCaptureFormat(this.captureWidth, this.captureHeight, this.captureFps);
        }
        this.lastRotation = currentRotation;
    }

    private void getCaptureSize() {
        DisplayMetrics dm = new DisplayMetrics();
        this.display.getRealMetrics(dm);
        int screenWidth = dm.widthPixels;
        int screenHeight = dm.heightPixels;
        if (screenWidth >= screenHeight) {
            this.captureWidth = Math.min(this.maxWidth, screenWidth);
            this.captureHeight = Math.min(this.maxHeight, screenHeight);
        } else {
            this.captureWidth = Math.min(this.maxHeight, screenWidth);
            this.captureHeight = Math.min(this.maxWidth, screenHeight);
        }
        float ratioW = (float)screenWidth * 1.0f / (float)this.captureWidth;
        float ratioH = (float)screenHeight * 1.0f / (float)this.captureHeight;
        if (ratioW >= ratioH) {
            this.captureHeight = (int)((float)(screenHeight * this.captureWidth) * 1.0f / (float)screenWidth);
        } else {
            this.captureWidth = (int)((float)(screenWidth * this.captureHeight) * 1.0f / (float)screenHeight);
        }
    }

    @CalledByNative
    public int pause() {
        this.status = Status.PAUSED;
        return 0;
    }

    @CalledByNative
    public int resume() {
        this.status = Status.RUNNING;
        return 0;
    }

    @CalledByNative
    public int stop() {
        this.status = Status.IDLE;
        if (this.capturer != null) {
            try {
                this.capturer.stopCapture();
                return 0;
            }
            catch (InterruptedException e) {
                return -2;
            }
        }
        return -9;
    }

    @CalledByNative
    public int setCaptureFps(int fps) {
        this.captureFps = fps;
        this.getCaptureSize();
        if (this.capturer != null) {
            this.capturer.changeCaptureFormat(this.captureWidth, this.captureHeight, this.captureFps);
        }
        return 0;
    }

    @CalledByNative
    public int setMaxCaptureSize(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
        return 0;
    }

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeCapturerError(long var0, int var2);

    private static native void nativeOnFrameCaptured(long var0, ByteBuffer[] var2, ImageFormat var3, long var4);

    private static enum Status {
        IDLE,
        RUNNING,
        PAUSED;

    }

    public static class ImageFormat {
        int pxfmt = 0;
        int width = 0;
        int height = 0;
        int rotation = 0;
        int[] stride;
    }
}

