/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import java.io.File;
import java.util.List;
import java.util.Locale;
import video.pano.rtc.base.util.Checker;
import video.pano.rtc.base.util.Compatibility;
import video.pano.rtc.base.util.StringUtils;
import video.pano.rtc.base.util.SystemPermissionUtils;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.PLogger;

public class SystemUtils {
    public static boolean isAppDebug(Context context) {
        Checker.checkNotNull(context);
        return (context.getApplicationInfo().flags & 2) != 0;
    }

    static boolean isLargeHeap(Context context) {
        Checker.checkNotNull(context);
        return (context.getApplicationInfo().flags & 0x100000) != 0;
    }

    public static String defaultLogDir(Context context) {
        File log = context.getExternalFilesDir("log");
        if (log == null || -1 == context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName())) {
            log = context.getDir("log", 0);
        }
        return log.getAbsolutePath();
    }

    public static boolean isRooted() {
        boolean emulator = SystemUtils.runningOnEmulator();
        String tags = Build.TAGS;
        if (!emulator && tags != null && tags.contains("test-keys")) {
            return true;
        }
        if (new File("/system/app/Superuser.apk").exists()) {
            return true;
        }
        return !emulator && new File("/system/xbin/su").exists();
    }

    private static boolean runningOnEmulator() {
        if (StringUtils.isNotEmpty(Build.MODEL) && Build.MODEL.toLowerCase().contains("sdk")) {
            return true;
        }
        if (StringUtils.isNotEmpty(Build.MANUFACTURER) && Build.MANUFACTURER.toLowerCase().contains("unknown")) {
            return true;
        }
        return StringUtils.isNotEmpty(Build.DEVICE) && Build.DEVICE.toLowerCase().contains("generic");
    }

    public static String battery() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = GlobalRef.applicationContext.registerReceiver(null, filter);
        if (intent != null) {
            int level = intent.getIntExtra("level", -1);
            int scale = intent.getIntExtra("scale", -1);
            if (scale != -1) {
                return String.format(Locale.US, "%d %%", level * 100 / scale);
            }
        }
        return "--";
    }

    public static void checkIsInPowerWhiteList(Context context) {
        Checker.checkNotNull(context);
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (Compatibility.runningOnMarshmallowOrHigher() && powerManager != null) {
            boolean ignore = powerManager.isIgnoringBatteryOptimizations(context.getPackageName());
            if (!ignore) {
                PLogger.w("PanoRtc", "app is not on the device's power whitelist, please refer to https://goo.gl/FE5SeB");
            } else {
                PLogger.i("PanoRtc", "app is on the device's power whitelist");
            }
        }
    }

    public static void checkSelfPermission(Context context) {
        List<String> miss = SystemPermissionUtils.checkPermission(context);
        if (miss.isEmpty()) {
            PLogger.i("PanoRtc", "Permission is OK");
        } else {
            for (String permission2 : miss) {
                if (StringUtils.isEmpty(permission2)) continue;
                PLogger.e("PanoRtc", "Permission miss : " + permission2);
            }
        }
    }
}

