/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;

public class NetworkUtils {
    public static NetworkType getConnectivityStatus(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return NetworkType.NOT_CONNECTED;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities capabilities = cm.getNetworkCapabilities(cm.getActiveNetwork());
            if (capabilities != null) {
                if (capabilities.hasTransport(1)) {
                    return NetworkType.WIFI;
                }
                if (capabilities.hasTransport(0)) {
                    return NetworkType.MOBILE;
                }
                if (capabilities.hasTransport(3)) {
                    return NetworkType.ETHERNET;
                }
            }
        } else {
            NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
            if (activeNetwork != null) {
                if (activeNetwork.getType() == 1) {
                    return NetworkType.WIFI;
                }
                if (activeNetwork.getType() == 0) {
                    return NetworkType.MOBILE;
                }
                if (activeNetwork.getType() == 9) {
                    return NetworkType.ETHERNET;
                }
            }
        }
        return NetworkType.NOT_CONNECTED;
    }

    static String getConnectivityStatusString(NetworkType type) {
        String status = null;
        if (type == NetworkType.WIFI) {
            status = "Wifi enabled";
        } else if (type == NetworkType.MOBILE) {
            status = "Mobile data enabled";
        } else if (type == NetworkType.NOT_CONNECTED) {
            status = "Not connected to Internet";
        }
        return status;
    }

    public static enum NetworkType {
        NOT_CONNECTED(0),
        WIFI(1),
        MOBILE(2),
        ETHERNET(3);

        private final int value;

        private NetworkType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }
    }
}

