/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.os.AsyncTask;
import android.util.Log;
import android.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private static final String TAG = "HttpRequest";
    private ReqTask mReqTask;
    Callback mCallback;
    private final Map<String, String> mHeaders = new HashMap<String, String>();

    public HttpRequest addHeader(String name, String value) {
        this.mHeaders.put(name, value);
        return this;
    }

    public boolean get(String url, Callback cb) {
        this.mCallback = cb;
        this.mReqTask = new ReqTask();
        this.mReqTask.execute(new String[]{"GET", url});
        return true;
    }

    public boolean post(String url, String body, Callback cb) {
        this.mCallback = cb;
        this.mReqTask = new ReqTask();
        this.mReqTask.execute(new String[]{"POST", url, body});
        return true;
    }

    public void close() {
        this.mReqTask.cancel(true);
        this.mHeaders.clear();
    }

    private class ReqTask
    extends AsyncTask<String, Integer, Pair<Integer, String>> {
        private ReqTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Pair<Integer, String> doInBackground(String ... params) {
            HttpURLConnection urlConn = null;
            int statusCode = -1;
            try {
                urlConn = (HttpURLConnection)new URL(params[1]).openConnection();
                urlConn.setConnectTimeout(20000);
                urlConn.setReadTimeout(20000);
                String body = "";
                if (params.length > 2 && !(body = params[2]).isEmpty()) {
                    urlConn.setDoOutput(true);
                }
                urlConn.setDoInput(true);
                urlConn.setUseCaches(false);
                urlConn.setRequestMethod(params[0]);
                urlConn.setInstanceFollowRedirects(true);
                for (Map.Entry entry : HttpRequest.this.mHeaders.entrySet()) {
                    urlConn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                urlConn.connect();
                if (!body.isEmpty()) {
                    DataOutputStream dos = new DataOutputStream(urlConn.getOutputStream());
                    dos.write(body.getBytes());
                    dos.flush();
                    dos.close();
                }
                statusCode = urlConn.getResponseCode();
                String result = this.streamToString(urlConn.getInputStream());
                Pair pair = new Pair((Object)statusCode, (Object)result);
                return pair;
            }
            catch (Exception e) {
                if (statusCode == -1) {
                    Log.e((String)HttpRequest.TAG, (String)("HttpRequest error: " + e.toString()));
                }
            }
            finally {
                urlConn.disconnect();
            }
            return new Pair((Object)statusCode, (Object)"");
        }

        protected void onPostExecute(Pair<Integer, String> result) {
            int statusCode = (Integer)result.first;
            String response = (String)result.second;
            if (statusCode == -1) {
                HttpRequest.this.mCallback.onError(-1);
            } else {
                HttpRequest.this.mCallback.onResponse(statusCode, response);
            }
        }

        private String streamToString(InputStream is) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, len);
                }
                baos.close();
                is.close();
                byte[] byteArray = baos.toByteArray();
                return new String(byteArray);
            }
            catch (Exception e) {
                Log.e((String)HttpRequest.TAG, (String)e.toString());
                return null;
            }
        }
    }

    public static interface Callback {
        public void onResponse(int var1, String var2);

        public void onError(int var1);
    }
}

