/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.preference.PreferenceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public class DeviceUuid {
    private static final String DEVICES_ID_KEY = "DEVICES_ID_KEY";
    private static final String CACHE_IMAGE_DIR = "pano/cache/devices";
    private static final String DEVICES_FILE_NAME = ".DEVICES";

    private DeviceUuid() {
    }

    public static String getDeviceID(Context context) {
        try {
            UUID uuid;
            String readDeviceId = DeviceUuid.readDeviceID(context);
            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            String appDeviceId = preferences.getString(DEVICES_ID_KEY, "");
            if (!(appDeviceId.isEmpty() || readDeviceId != null && !readDeviceId.isEmpty() && appDeviceId.equals(readDeviceId))) {
                readDeviceId = appDeviceId;
                DeviceUuid.saveDeviceID(readDeviceId, context);
            }
            if ((readDeviceId == null || readDeviceId.isEmpty()) && (readDeviceId = (uuid = UUID.randomUUID()).toString().replace("-", "")).length() > 0) {
                DeviceUuid.saveDeviceID(readDeviceId, context);
            }
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(DEVICES_ID_KEY, readDeviceId);
            editor.apply();
            return readDeviceId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String readDeviceID(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return "";
        }
        File file = DeviceUuid.getDevicesDir(context);
        StringBuffer buffer = new StringBuffer();
        try {
            int i;
            FileInputStream fis = new FileInputStream(file);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
            BufferedReader in = new BufferedReader(isr);
            while ((i = ((Reader)in).read()) > -1) {
                buffer.append((char)i);
            }
            ((Reader)in).close();
            return buffer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveDeviceID(String str, Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return;
        }
        File file = DeviceUuid.getDevicesDir(context);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
            out.write(str);
            ((Writer)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getDevicesDir(Context context) {
        File cropFile = null;
        if (Environment.getExternalStorageState().equals("mounted")) {
            File cropdir = new File(Environment.getExternalStorageDirectory(), CACHE_IMAGE_DIR);
            if (!cropdir.exists()) {
                cropdir.mkdirs();
            }
            cropFile = new File(cropdir, DEVICES_FILE_NAME);
        } else {
            File cropdir = new File(context.getFilesDir(), CACHE_IMAGE_DIR);
            if (!cropdir.exists()) {
                cropdir.mkdirs();
            }
            cropFile = new File(cropdir, DEVICES_FILE_NAME);
        }
        return cropFile;
    }
}

