/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.audio;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import java.util.List;
import java.util.Set;
import video.pano.rtc.audio.AudioDeviceManager;
import video.pano.rtc.base.thread.ThreadUtils;
import video.pano.rtc.base.util.SystemPermissionUtils;
import video.pano.rtc.impl.PLogger;

class BluetoothManager {
    private static final String TAG = "BluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 6000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 3;
    private final Context mContext;
    private final AudioDeviceManager mAudioDeviceManager;
    private final AudioManager mAudioManager;
    private final Handler mHandler;
    private int mScoConnectionAttempts;
    private State mBluetoothState;
    private final BluetoothProfile.ServiceListener mBluetoothServiceListener;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothDevice;
    private final BroadcastReceiver mBluetoothHeadsetReceiver;
    private final Runnable mBluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            BluetoothManager.this.bluetoothTimeout();
        }
    };

    static BluetoothManager create(Context context, AudioDeviceManager manager) {
        PLogger.ni(TAG, "create bluetooth manager");
        return new BluetoothManager(context, manager);
    }

    private BluetoothManager(Context context, AudioDeviceManager manager) {
        PLogger.ni(TAG, "ctor");
        ThreadUtils.checkIsOnUiThread();
        this.mContext = context;
        this.mAudioDeviceManager = manager;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mBluetoothState = State.UNINITIALIZED;
        this.mBluetoothServiceListener = new BluetoothServiceListener();
        this.mBluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
    }

    public void start() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.nd(TAG, "start");
        if (!SystemPermissionUtils.checkBluetoothPermission(this.mContext)) {
            PLogger.ne(TAG, "Missing permission android.permission.BLUETOOTH");
            return;
        }
        if (!this.mAudioManager.isBluetoothScoAvailableOffCall()) {
            PLogger.ne(TAG, "Bluetooth is not available off call");
            return;
        }
        if (this.mBluetoothState != State.UNINITIALIZED) {
            PLogger.ne(TAG, "Invalid BT state");
            return;
        }
        this.mBluetoothHeadset = null;
        this.mBluetoothDevice = null;
        this.mScoConnectionAttempts = 0;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.mBluetoothAdapter == null) {
            PLogger.ne(TAG, "Bluetooth is not supported  on this hardware platform");
            return;
        }
        this.logBluetoothAdapterInfo(this.mBluetoothAdapter);
        if (!this.mBluetoothAdapter.getProfileProxy(this.mContext, this.mBluetoothServiceListener, 1)) {
            PLogger.ne(TAG, "BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        filter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        filter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        this.mContext.registerReceiver(this.mBluetoothHeadsetReceiver, filter);
        PLogger.nd(TAG, "HEADSET profile state: " + this.connectionStateToString(this.mBluetoothAdapter.getProfileConnectionState(1)));
        PLogger.nd(TAG, "Bluetooth proxy for headset profile has started");
        this.mBluetoothState = State.HEADSET_UNAVAILABLE;
        PLogger.nd(TAG, "start done: BT state=" + (Object)((Object)this.mBluetoothState));
    }

    public void stop() {
        ThreadUtils.checkIsOnUiThread();
        try {
            this.mContext.unregisterReceiver(this.mBluetoothHeadsetReceiver);
        }
        catch (Exception exception) {
            // empty catch block
        }
        PLogger.nd(TAG, "stop: BT state=" + (Object)((Object)this.mBluetoothState));
        if (this.mBluetoothAdapter != null) {
            this.stopScoAudio();
            if (this.mBluetoothState != State.UNINITIALIZED) {
                this.cancelTimer();
                if (this.mBluetoothHeadset != null) {
                    this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBluetoothHeadset);
                    this.mBluetoothHeadset = null;
                }
                this.mBluetoothAdapter = null;
                this.mBluetoothDevice = null;
                this.mBluetoothState = State.UNINITIALIZED;
            }
        }
        PLogger.nd(TAG, "stop done: BT state=" + (Object)((Object)this.mBluetoothState));
    }

    public State getState() {
        ThreadUtils.checkIsOnUiThread();
        return this.mBluetoothState;
    }

    boolean startScoAudio() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.ni(TAG, "startSco: BT state=" + (Object)((Object)this.mBluetoothState) + ", attempts: " + this.mScoConnectionAttempts + ", SCO is on: " + this.mAudioManager.isBluetoothScoOn());
        if (this.mScoConnectionAttempts >= 3) {
            PLogger.ne(TAG, "BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.mBluetoothState != State.HEADSET_AVAILABLE) {
            PLogger.ne(TAG, "BT SCO connection fails - no headset available");
            return false;
        }
        PLogger.nd(TAG, "Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.mBluetoothState = State.SCO_CONNECTING;
        this.mAudioManager.startBluetoothSco();
        ++this.mScoConnectionAttempts;
        this.startTimer();
        PLogger.nd(TAG, "startScoAudio done: BT state=" + (Object)((Object)this.mBluetoothState));
        return true;
    }

    void stopScoAudio() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.ni(TAG, "stopScoAudio: BT state=" + (Object)((Object)this.mBluetoothState) + ", SCO is on: " + this.mAudioManager.isBluetoothScoOn());
        if (this.mBluetoothState != State.SCO_CONNECTING && this.mBluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.mAudioManager.stopBluetoothSco();
        this.mBluetoothState = State.SCO_DISCONNECTING;
        PLogger.nd(TAG, "stopScoAudio done: BT state=" + (Object)((Object)this.mBluetoothState));
    }

    private void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        PLogger.nd(TAG, "BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.adapterStateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress());
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            PLogger.nd(TAG, "paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                PLogger.nd(TAG, "name=" + device.getName() + ", address=" + device.getAddress());
            }
        }
    }

    private String connectionStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 2: {
                return "CONNECTED";
            }
            case 3: {
                return "DISCONNECTING";
            }
        }
        return "INVALID(" + state + ")";
    }

    private String audioStateToString(int state) {
        switch (state) {
            case 12: {
                return "CONNECTED";
            }
            case 11: {
                return "CONNECTING";
            }
            case 10: {
                return "DISCONNECTED";
            }
        }
        return "INVALID(" + state + ")";
    }

    private String scoStateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 1: {
                return "CONNECTED";
            }
            case 2: {
                return "CONNECTING";
            }
        }
        return "ERROR";
    }

    private String adapterStateToString(int state) {
        switch (state) {
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID(" + state + ")";
    }

    private void startTimer() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.nd(TAG, "startTimer");
        this.mHandler.postDelayed(this.mBluetoothTimeoutRunnable, 6000L);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.nd(TAG, "cancelTimer");
        this.mHandler.removeCallbacks(this.mBluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnUiThread();
        if (this.mBluetoothState == State.UNINITIALIZED || this.mBluetoothHeadset == null) {
            return;
        }
        PLogger.ne(TAG, "bluetoothTimeout: BT state=" + (Object)((Object)this.mBluetoothState) + ", attempts: " + this.mScoConnectionAttempts + ", SCO is on: " + this.mAudioManager.isBluetoothScoOn());
        if (this.mBluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.mBluetoothHeadset.getConnectedDevices();
        if (!devices.isEmpty()) {
            this.mBluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.mBluetoothHeadset.isAudioConnected(this.mBluetoothDevice)) {
                PLogger.nd(TAG, "SCO connected with " + this.mBluetoothDevice.getName());
                scoConnected = true;
            } else {
                PLogger.nd(TAG, "SCO is not connected with " + this.mBluetoothDevice.getName());
            }
        }
        if (scoConnected) {
            this.mBluetoothState = State.SCO_CONNECTED;
            this.mScoConnectionAttempts = 0;
        } else {
            PLogger.ne(TAG, "BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        PLogger.nd(TAG, "bluetoothTimeout done: BT state=" + (Object)((Object)this.mBluetoothState));
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnUiThread();
        PLogger.nd(TAG, "updateAudioDeviceState");
        this.mAudioDeviceManager.updateAudioDeviceState();
    }

    void updateDevice() {
        if (this.mBluetoothState == State.UNINITIALIZED || this.mBluetoothHeadset == null) {
            return;
        }
        PLogger.nd(TAG, "updateDevice");
        List devices = this.mBluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.mBluetoothDevice = null;
            this.mBluetoothState = State.HEADSET_UNAVAILABLE;
            PLogger.nd(TAG, "No connected bluetooth headset");
        } else {
            this.mBluetoothDevice = (BluetoothDevice)devices.get(0);
            this.mBluetoothState = State.HEADSET_AVAILABLE;
            PLogger.nd(TAG, "Connected bluetooth headset: name=" + this.mBluetoothDevice.getName() + ", state=" + this.connectionStateToString(this.mBluetoothHeadset.getConnectionState(this.mBluetoothDevice)) + ", SCO audio=" + this.mBluetoothHeadset.isAudioConnected(this.mBluetoothDevice));
        }
        PLogger.nd(TAG, "updateDevice done: BT state=" + (Object)((Object)this.mBluetoothState));
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (BluetoothManager.this.mBluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if ("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED".equals(action)) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                int preState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 0);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + BluetoothManager.this.connectionStateToString(state) + ", ps=" + BluetoothManager.this.connectionStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState) + ", d=" + (device == null ? "null" : device.getName()) + ", ds=" + BluetoothManager.this.connectionStateToString(BluetoothManager.this.mBluetoothHeadset == null ? -1 : BluetoothManager.this.mBluetoothHeadset.getConnectionState(device)));
                if (state == 2) {
                    BluetoothManager.this.mScoConnectionAttempts = 0;
                    BluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    BluetoothManager.this.stopScoAudio();
                    BluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                int preState = intent.getIntExtra("android.bluetooth.profile.extra.PREVIOUS_STATE", 10);
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + BluetoothManager.this.audioStateToString(state) + ", ps=" + BluetoothManager.this.audioStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState) + ", d=" + (device == null ? "null" : device.getName()) + ", sco=" + (BluetoothManager.this.mBluetoothHeadset == null ? "false" : Boolean.valueOf(BluetoothManager.this.mBluetoothHeadset.isAudioConnected(device))));
                if (state == 12) {
                    BluetoothManager.this.cancelTimer();
                    if (BluetoothManager.this.mBluetoothState == State.SCO_CONNECTING) {
                        PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Bluetooth audio SCO is now connected");
                        BluetoothManager.this.mBluetoothState = State.SCO_CONNECTED;
                        BluetoothManager.this.mScoConnectionAttempts = 0;
                        BluetoothManager.this.updateAudioDeviceState();
                    } else {
                        PLogger.ne(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state == 11) {
                    PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Bluetooth audio SCO is now connecting...");
                } else if (state == 10) {
                    PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Bluetooth audio SCO is now disconnected");
                    if (this.isInitialStickyBroadcast()) {
                        PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    BluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.media.ACTION_SCO_AUDIO_STATE_UPDATED")) {
                int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", 0);
                int preState = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", 0);
                PLogger.nd(BluetoothManager.TAG, "BluetoothHeadsetReceiver.onReceive: a=ACTION_SCO_AUDIO_STATE_UPDATED, s=" + BluetoothManager.this.scoStateToString(state) + ", ps=" + BluetoothManager.this.scoStateToString(preState) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            }
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || BluetoothManager.this.mBluetoothState == State.UNINITIALIZED) {
                return;
            }
            PLogger.ni(BluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            BluetoothManager.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
            BluetoothManager.this.updateAudioDeviceState();
            PLogger.ni(BluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected done: BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || BluetoothManager.this.mBluetoothState == State.UNINITIALIZED) {
                return;
            }
            PLogger.ni(BluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
            BluetoothManager.this.stopScoAudio();
            BluetoothManager.this.mBluetoothHeadset = null;
            BluetoothManager.this.mBluetoothDevice = null;
            BluetoothManager.this.mBluetoothState = State.HEADSET_UNAVAILABLE;
            BluetoothManager.this.updateAudioDeviceState();
            PLogger.ni(BluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected done: BT state=" + (Object)((Object)BluetoothManager.this.mBluetoothState));
        }
    }

    static enum State {
        UNINITIALIZED,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

